/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#include "DynamicLoader.h"
#include <Windows.h>
#include "Utils.h"

using namespace NS_DM_Client;

DynamicLoader::DynamicLoader()
: m_handle(0)
{

}


DynamicLoader::~DynamicLoader()
{
    if (m_handle)
    {
        Unload();
    }

}


void* DynamicLoader::Load(const char* lib, const char* method, long param)
{
    if (m_handle)
    {
		m_error = "Lib already loaded";
        return 0;
    }

    void* resource = 0;
    HMODULE dl_handle = LoadLibraryA( lib );
    if (dl_handle)
    {
        CREATE_FUNC func = (CREATE_FUNC)GetProcAddress( dl_handle, method );
        if (func)
        {
            resource = (*func)(param);
		    m_handle = dl_handle;
        }
        else
        {
		    FreeLibrary(dl_handle);
        }
    }
	
	char buf[256];
	__sprintf(buf, "Last error: %d", ::GetLastError());
	m_error = buf;

    return resource;
}


void DynamicLoader::Unload()
{
    FreeLibrary((HMODULE)m_handle);
    m_handle = 0;
}

const char* DynamicLoader::GetLoadErrorDescription() const
{
	return m_error.c_str();
}
