/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#pragma once

#include "IFIFOWrapper.h"
#include "CritSection.h"
#include "lock.h"

namespace NS_DM_Client
{

class PosixFIFOWrapper : public IFIFOWrapper
{
public:
    virtual StatusCode Open(const String& name, bool readMode, bool blockedMode, bool immediateOpen = false);

    virtual StatusCode Read(Buffer& buffer, bool exitIfNoWriter = false);
    virtual StatusCode Write(const Buffer& buffer, bool exitIfNoReader = false);
    virtual StatusCode Write(const void* buffer, size_t length, bool exitIfNoReader = false);

    virtual StatusCode Close();

    virtual void Release();

    virtual ~PosixFIFOWrapper();
protected:
    virtual StatusCode open();

private:
    bool changePIPESignalDisposition();

    int m_fifo;

    String m_name;
    bool m_readMode;
    bool m_blockedMode;

    NS_Common::CritSection m_stateMutex;
};


}


