/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#include <mach/mach_time.h>
#include "TimeLog.h"

using namespace NS_DM_Client::NS_Common;

TimeLog::TimeLog()
{
}

TimeLog::~TimeLog()
{
}

int TimeLog::Snap()
{
	m_start = m_end;
	m_end   = mach_absolute_time();
    return 0;
}

long int TimeLog::NanoSeconds()
{
	uint64_t difference = m_end - m_start;
	static mach_timebase_info_data_t info = {0,0};  
	
	if (info.denom == 0)  
		mach_timebase_info(&info);  
	
	uint64_t elapsednanosec = difference * (info.numer / info.denom);  
	
	return elapsednanosec;
}
