/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

// TestLogger.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "Logger/Logger.h"

int main()
{
 	NS_Logging::Logger& logger = NS_Logging::GetLogger("TestLogger");
	logger.SetMinimalCategory(NS_Logging::e_info);
	logger.Error("to log w/o logging place info, uses %s format", "printf()");

	LOG_(logger, "with functionname, uses %s format", "printf()");

	logger.Debug("debug message shouldn't appear because of priority filter");
	logger.Warning("warning message");
	logger.SetMaxMessageSize(98);
	logger.Log("this long log message should be truncated because of too short buffer");

	NS_Logging::Logger& anotherLogger = NS_Logging::GetLogger("AnotherTestLogger");
	LOG_ERROR_(anotherLogger, "error with another logger with funcname");
	anotherLogger.Error("error with another logger w/o funcname");
	anotherLogger.Warning("warning message with abother logger");

	return 0;
}

