/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#pragma once

#include "serverexchange/IServerExchangeManager.h"
#include <syncml/core/DevInf.h>
#include <spds/AccessConfig.h>
#include "daemon/IManager.h"
#include <NotificationListener/SessionInfo.h>

namespace NS_DM_Client
{
	class MockServerExchangeManager : public IServerExchangeManager
	{
	public:
		/// Add message to the queue
		virtual void AddCommand(NS_SyncMLCommand::SCommandPtr ptrCommand, const char *connid) {};
		virtual void AddCommands(NS_SyncMLCommand::SCommandsArray &commands, const char *connid) {};

		virtual NS_Communication::IConnection * DefaultConnection() { return NULL; };
		virtual void DefaultConnectionName(String &) {};

		virtual void HandleNetworkEntrance(int homeNspID, const char* operatorName, bool startWIB) {};
		virtual void NotifyDiagnosticsReady(String &serverID, String &origID) {};
		virtual void NotifyFWJobStatus(String &serverID, int result, ExecPtr &exec, const char *alertType){};

		/// Post authentification messages into the sending queue
		virtual void SetServerPollerInfo(bool pollingSupported, int pollingInterval, int pollingAttempts) {};

		/// Set server id; value is checked while performing commands on MO tree
		/// typically stored in the MO tree under the ./DMAcc/<X>/ServerID path

		virtual bool HasAccountFor(String &serverID) { return false; };
		virtual void SetConnectionsInfo(NS_Communication::ConnInfoList &) {};

		/// Set device info, read from the dmtree
		virtual void SetDevInfo(Funambol::DevInf &devInf) {};

		/// Run client initiated session
		virtual void StartClientSession() {};
		virtual void StartClientSession(NS_SyncMLCommand::SAlertCommandPtr ptrAlert) {};

		/// request for DM session
		virtual void RequestSessionStart(const NS_NotificationListener::SessionInfo& sessionInfo) {};

		/// Start downloading FW file from the specified URL.
		virtual void ProcessBootstrapMessage(const char *bsm, uint length) {};


		virtual bool Init(const StringMap& settings, const String& loggerInstance, ProfileComponentsHolder& pch) { return true; };
		virtual bool Start() { return true; };
		virtual bool Stop() { return true; };
		virtual void Release() {};

		virtual void RequestFWUpdate(bool userInitiated, const char *fumouri, int data) {}
		virtual void UpdateFW(ExecPtr cmd) {};

		virtual void StartWIB() {};
		virtual NS_Communication::FirmwareManager* GetFirmwareManager() { return NULL; };
	};
}
