#include "ManagementObjects/TNDSMgmtTree/TNDSCreator.h"
#include "Common.h"
#include "Utils.h"
#include <syncml/formatter/Formatter.h>
#include <syncml/core/ObjectDel.h>
#include <Logger/LoggerMacroses.h>

const char* const c_LogName = "TNDSCreator";

namespace NS_DM_Client
{
    TNDSCreator::TNDSCreator(): m_buffer(new Funambol::StringBuffer((S_beginScope + S_mgmtTree + S_versionNS + S_endScope).c_str()))
    {
        if(m_buffer == (Funambol::StringBuffer*)NULL)
        {
             GDLERROR("mo_buffer is NULL");
        }
        appendVersion();
    }
    //-------------------------------------------------------------------------------------------

    TNDSCreator::~TNDSCreator()
    {
        Funambol::deleteStringBuffer(&m_buffer);
    }
    //-------------------------------------------------------------------------------------------

    void TNDSCreator::appendVersion()
    {
        Funambol::VerDTD ver(S_verDTD.c_str());
        Funambol::StringBuffer* verDTD = Funambol::Formatter::getVerDTD(&ver);
        m_buffer->append(verDTD);
        Funambol::deleteStringBuffer(&verDTD);
    }
    //-------------------------------------------------------------------------------------------

    void TNDSCreator::Append(const String& path, const String& name, const String& value)
    {
        append(path, name, S_formatLeaf, value);
    }
    //-------------------------------------------------------------------------------------------
    void TNDSCreator::Append(const String& path, const String& name, bool value)
    {
        String tmpValue = "false";
        if(value) tmpValue = "true";
        append(path, name, S_boolFormat, (String &)tmpValue);
    }
    //-------------------------------------------------------------------------------------------

    void TNDSCreator::append(const String& path, const String& name, const String& format, const String& value)
    {
        Funambol::StringBuffer* node = new Funambol::StringBuffer();
        if(node == (Funambol::StringBuffer*)NULL)
        {
            GDLERROR("new node");
            return;
        }
        node->append((S_beginScope + S_node + S_endScope).c_str());
        appendValue(node, S_nodeName, name);
        appendValue(node, S_path, path);

        Funambol::StringBuffer* RTPProperties = new Funambol::StringBuffer((S_beginScope + S_RTProperties + S_endScope).c_str());
        if(RTPProperties == (Funambol::StringBuffer*)NULL)
        {
            GDLERROR("new RTPProperties");
            Funambol::deleteStringBuffer(&node);
            return;
        }
        appendValue(RTPProperties, S_format, format);
        if (S_formatNode != format)
        {
            appendValue(RTPProperties, S_value, value);
        }
        RTPProperties->append((S_beginScope + S_slash + S_RTProperties + S_endScope).c_str());
        node->append(RTPProperties);

        node->append((S_beginScope + S_slash + S_node + S_endScope).c_str());

        m_buffer->append(node);
        Funambol::deleteStringBuffer(&RTPProperties);
        Funambol::deleteStringBuffer(&node);
    }
    //-------------------------------------------------------------------------------------------

    void TNDSCreator::Append(const String& path, const String& name, size_t value)
    {
        String strValue = ToString(value);
        Append(path, name, strValue);
    }
    //-------------------------------------------------------------------------------------------

    void TNDSCreator::Append(const String& path, const String& nodeName)
    {
        append(path, nodeName, S_formatNode);
    }
    //-------------------------------------------------------------------------------------------

    void TNDSCreator::Get(String& xml)
    {
        xml = String(m_buffer->c_str()) + S_beginScope + S_slash + S_mgmtTree + S_endScope;
    }
    //-------------------------------------------------------------------------------------------

    void TNDSCreator::appendValue(Funambol::StringBuffer*& nodeXml, const String& target, const String& value)
    {
        Funambol::StringBuffer* valueBuffer = Funambol::Formatter::getValue(target.c_str(), value.c_str());
        nodeXml->append(valueBuffer);
        Funambol::deleteStringBuffer(&valueBuffer);
    }
    //-------------------------------------------------------------------------------------------
}
