#include <iostream>

#include <DaemonDM/TestingAPI.h>
#include "commontypes.h"
#include "platform.h"

#include "Errors.h"

#if defined PLATFORM_WINDOWS
	//NULL;
#else
	#include <sys/param.h>
	#include <getopt.h>

	const char* const c_clSmallOptions = "hg:u:d:";
	const struct option LongOptions[] =
	{
	{"help",       0,      NULL,       c_clSmallOptions[0]},
	{"get",        0,      NULL,       c_clSmallOptions[1]},
	{"user",       0,      NULL,       c_clSmallOptions[2]},
	{"device",     0,      NULL,       c_clSmallOptions[3]},
	{NULL,         0,      NULL,       0}
	};
#endif

//------------------------------------------------------------------------------------------------------

void print_usage(FILE* stream, const char* prog_name)
{
    fprintf(stream, "Usage: %s options \n", prog_name);
    fprintf(stream,
        "   -h      		--help              Display this usage information\n"
        "   -g uri  		--get uri           Get value from tree. Set uri of needed value in format: profile:uri \n"
        "   -u profile  	--user profile      Send request for user initiated firmvare update \n"
        "   -d profile  	--device profile   	Send request for device initiated firmvare update \n"
    );
}

//------------------------------------------------------------------------------------------------------

using namespace NS_DM_Client;

void CheckCommandLine(int argc, char** argv, TestingAPI& test)
{
#if defined PLATFORM_WINDOWS
	if (argc > 1)
	{
		char arg[2];
		arg[0] = argv[1][0];
		arg[1] = argv[1][1];
		
		if ((arg[0] == '-') && (arg[1] == 'g'))
		{
			String uri = argv[1];
			uri = uri.substr(2);
            
			fprintf (stdout, "requested uri:\n%s\n", uri.c_str());
            String result;
           StatusCode res = test.GetValueFromTree(uri, result);
            String res_status;
            if (res == e_Ok)
            {
				res_status = "success";
            }
            else if (res == e_NotFound)
            {
				res_status = "not found";
            }
            else
			{
				res_status = "failed";
            }
            fprintf (stdout, "result status:\n%s\n", res_status.c_str());
			if (res == e_Ok)
            {
				fprintf (stdout, "result:\n%s\n", result.c_str());
            }
		}
		else if ((arg[0] == '-') && (arg[1] == 'h'))
		{

		}
	}
#else
    int next_option;
	if (argc > 1)
    {
       do
        {
            next_option = getopt_long(argc, argv, c_clSmallOptions, LongOptions, 0);
            switch (next_option)
            {
                case 'h':
                {
                    print_usage(stdout, argv[0]);
                    break;
                }
                case 'g':
                {
                    String uri = optarg;
                    if (!uri.empty())
                    {
                        fprintf (stdout, "requested uri:\n%s\n", uri.c_str());
                        String result;
                        StatusCode res = test.GetValueFromTree(uri, result);
                        String res_status;
                        if (res == e_Ok)
                        {
                            res_status = "success";
                        }
                        else if (res == e_NotFound)
                        {
                            res_status = "not found";
                        }
                        else
                        {
                            res_status = "failed";
                        }
                        fprintf (stdout, "result status:\n%s\n", res_status.c_str());
                        if (res == e_Ok)
                        {
                            fprintf (stdout, "result:\n%s\n", result.c_str());
                        }
                    }
                    else
                    {
                        fprintf (stdout, "uri is empty. Fill correct argument list. Use -h for help\n");
                    }
                    break;
                }
                case 'u':
                {
                    String profile = optarg;
                    StatusCode res = test.RequestFirmwareUpdate(profile, true);
                    String res_status;
                    if (res == e_Ok)
                    {
                        sleep(2000);
                        res_status = "success";
                    }
                    else
                    {
                        res_status = "failed";
                    }
                    fprintf (stdout, "result status: %s\n", res_status.c_str());
                    break;
                }
                case 'd':
                {
                    String profile = optarg;
                    StatusCode res = test.RequestFirmwareUpdate(profile, false);
                    String res_status;
                    if (res == e_Ok)
                    {
                        sleep(2000);
                        res_status = "success";
                    }
                    else
                    {
                        res_status = "failed";
                    }
                    fprintf (stdout, "result status: %s\n", res_status.c_str());
                    break;
                }                
				default:
                {
                    fprintf (stdout, "No valid command line argument. Use -h for help\n");
                    break;
                }
            }

            // only one parameter may be in command line
            exit(EXIT_SUCCESS);
        }
        while (next_option != -1);
    }
#endif

}

//------------------------------------------------------------------------------------------------------

int main(int argc, char** argv)
{
    TestingAPI test;
    if (test.Start())
    {
        CheckCommandLine(argc, argv, test);

		/*
                    String uri = "WiMAX_Profile:./DevDetail/OEM";
                    if (!uri.empty())
                    {
                        fprintf (stdout, "requested uri: %s \n", uri.c_str());
                        String result;
                        StatusCode res = test.GetValueFromTree(uri, result);
                        String res_status;
                        if (res == e_Ok)
                        {
                            res_status = "success";
                        }
                        else if (res == e_NotFound)
                        {
                            res_status = "not found";
                        }
                        else
                        {
                            res_status = "failed";
                        }
                        fprintf (stdout, "result status: %s \n", res_status.c_str());
                        if (res == e_Ok)
                        {
                            fprintf (stdout, "result: %s \n", result.c_str());
                        }
                    }
                    else
                    {
                        fprintf (stdout, "uri is empty. Fill correct argument list. Use -h for help\n");
                    }

			*/
    }
    else
    {
        fprintf (stdout, "can't start testing API. Daemon not alive or some internal error \n");
    }
    return 0;
}
