#include <iostream>

#include <DaemonDM/ProfileManager.h>
#include "commontypes.h"
#include "Errors.h"

#if defined PLATFORM_WINDOWS
	//NULL;
#else
	#include <sys/param.h>
	#include <getopt.h>

	const char* const c_clSmallOptions = "hge:d:";
	const struct option LongOptions[] =
	{
		{"help",       0,      NULL,       c_clSmallOptions[0]},
		{"get",        0,      NULL,       c_clSmallOptions[1]},
		{"enable",     0,      NULL,       c_clSmallOptions[2]},
		{"disable",    0,      NULL,       c_clSmallOptions[3]},
		{NULL,         0,      NULL,       0}
	};
#endif

//------------------------------------------------------------------------------------------------------

void print_usage(FILE* stream, const char* prog_name)
{
    fprintf(stream, "Usage: %s options \n", prog_name);
    fprintf(stream,
        "   -h          --help              Display this usage information\n"
        "   -g          --get               Get information about profiles \n"
        "   -e profile  --enable profile    Set profile enable. Profile - name of profile \n"
        "   -d profile  --disable profile   Set profile disable. Profile - name of profile \n"
    );
}

//------------------------------------------------------------------------------------------------------

using namespace NS_DM_Client;

void CheckCommandLine(int argc, char** argv, ProfileManager& ui)
{

#if defined PLATFORM_WINDOWS
	//NULL;
#else
    int next_option;
    if (argc > 1)
    {
        do
        {
            next_option = getopt_long(argc, argv, c_clSmallOptions, LongOptions, 0);
            switch (next_option)
            {
                case 'h':
                {
                    print_usage(stdout, argv[0]);
                    break;
                }
                case 'g':
                {
                    ProfileInfo profile;
                    if (ui.FetchFirstProfileInfo(profile))
                    {
                        fprintf (stdout, "avialable profiles: \n");
                        fprintf (stdout, "name: %s description: %s, is enabled: %d \n", profile.m_Name, profile.m_Description, profile.m_IsEnabled);
                        ui.ReleaseProfileInfo(profile);
                        while (ui.FetchNextProfileInfo(profile) == e_Ok)
                        {
                            fprintf (stdout, "name: %s description: %s, is enabled %d \n", profile.m_Name, profile.m_Description, profile.m_IsEnabled);
                            ui.ReleaseProfileInfo(profile);
                        }
                    }
                    break;
                }
                case 'e':
                {
                    if (ui.EnableProfile(optarg, true) == e_Ok)
                    {
                        fprintf (stdout, "enable profile %s is set \n", optarg);
                    }
                    else
                    {
                        fprintf (stdout, "enable profile %s is not set \n", optarg);
                    }
                    break;
                }
                case 'd':
                {
                    if (ui.EnableProfile(optarg, false) == e_Ok)
                    {
                        fprintf (stdout, "disable profile %s is set \n", optarg);
                    }
                    else
                    {
                        fprintf (stdout, "disable profile %s is not set \n", optarg);
                    }
                    break;
                }
                default:
                {
                    fprintf (stdout, "No valid command line argument. Use -h for help\n");
                    break;
                }
            }
            // only one parameter may be in command line
            exit(EXIT_SUCCESS);
        }
        while (next_option != -1);
    }
#endif


}
//------------------------------------------------------------------------------------------------------
int main(int argc, char** argv)
{
    ProfileManager* ui = GetProfileManager();
	if (ui)
	{    
		if (ui->Init())
    	{
        	CheckCommandLine(argc, argv, *ui);
		}
		else
		{
        	fprintf (stdout, "can't Init instance of ProfileManager. Daemon not alive or some internal error \n");
		}    
        ui->Release();
	}
    else
    {
        fprintf (stdout, "can't get instance of ProfileManager \n");
    }
    return 0;
}
//------------------------------------------------------------------------------------------------------
