/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#pragma once
#include <vector>
#include "common/commontypes.h"
#include "daemon/INotification.h"

namespace NS_DM_Client
{
	typedef unsigned char byte;
	struct Message;

	class MessageSerializer
	{
	public:
		MessageSerializer();
		typedef std::vector<byte> PlainData;
		// id + type + subtype + sizebody + body
		const PlainData& operator()(const Message& message);
	
	private:
		std::vector<byte> m_buffer;
	};
	
	void SerializeOperatorProfile(const String& name, const String& type, const String& description, String& data);
	void SerializeConfirmationResponse(const String& requestMessage, size_t confCode, String& data);
	void SerializeDMSessionNotification(EventType eventType, Initiator initiator, NotificationStatus statusCode, String& data);
	void SerializeFirmwareInfo(const String& localpath, const String& filename, int size, String& data);
	void SerializePasswords(const String& oldPassword, const String& newPassword, String& data);
	void SerializePasswordsAndServerID(const String& serverID, const String& oldPassword, const String& newPassword, String& data);
}
