/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#include "SetMgmtTreeCommand.h"
#include "treemanager/IMOTreeManager.h"

#include "ManagementObjects/TNDSMgmtTree/TNDSExtractor.h"
#include "Logger/Logger.h"

namespace NS_DM_Client
{
	SetMgmtTreeCommand::SetMgmtTreeCommand(ProfileComponentsHolder* holder, const String& mgmtTree, 
		NS_Common::EventEx* executionCompleted, bool& executionResult): 
		IMOTreeCommand(holder, 0, executionCompleted, executionResult), m_mgmtTree(mgmtTree)
	{

	}
	//-------------------------------------------------------------------------------------------

	bool SetMgmtTreeCommand::run(IMOTreeManager& treeManager)
	{
		NS_DM_Client::TNDSExtractor extractor(m_mgmtTree);
		bool res = extractor.SerializeToTree(treeManager);
		if (!res)
		{
			LOG_ERROR_(m_logger, "Serialization to tree failed");
		}
		return res;
	}
}
