#include "ProfileActivationStatusCommand.h"
#include "Event.h"

namespace NS_DM_Client
{
	ProfileActivationStatusCommand::ProfileActivationStatusCommand(ProfileComponentsHolder &pch, IResultSink &rsink, 
		NS_Common::EventEx* executionCompleted):
		ValidDMAccAvailableCommand(pch, rsink), m_executionCompleted(executionCompleted)
	{

	}
	//-------------------------------------------------------------------------------------------

	ProfileActivationStatusCommand::~ProfileActivationStatusCommand()
	{
		if (m_executionCompleted)
		{
			m_executionCompleted->signal();
		}
	}
	//-------------------------------------------------------------------------------------------

	bool ProfileActivationStatusCommand::Execute()
	{
		bool res = ValidDMAccAvailableCommand::Execute();
		if (m_executionCompleted)
		{
			m_executionCompleted->signal();
			m_executionCompleted = NULL;
		}
		return res;
	}
}
