#include "ProfileActivationStatusByServerIDCommand.h"
#include "Event.h"

namespace NS_DM_Client
{
	ProfileActivationStatusByServerIDCommand::ProfileActivationStatusByServerIDCommand(
		ProfileComponentsHolder &pch, IResultSink &rsink, 
		NS_Common::EventEx* executionCompleted, const String& serverID)
		:
		ValidDMAccByServerIDCommand(pch, rsink, serverID), m_executionCompleted(executionCompleted)
	{

	}
	//-------------------------------------------------------------------------------------------

	ProfileActivationStatusByServerIDCommand::~ProfileActivationStatusByServerIDCommand()
	{
		if (m_executionCompleted)
		{
			m_executionCompleted->signal();
		}
	}
	//-------------------------------------------------------------------------------------------

	bool ProfileActivationStatusByServerIDCommand::Execute()
	{
		bool res = ValidDMAccByServerIDCommand::Execute();
		if (m_executionCompleted)
		{
			m_executionCompleted->signal();
			m_executionCompleted = NULL;
		}
		return res;
	}
}
