#include "GetMgmtTreeCommand.h"
#include "treemanager/IMOTreeManager.h"
#include "ManagementObjects/IMgmtObject.h"
#include "Logger/Logger.h"

namespace NS_DM_Client
{
	GetMgmtTreeCommand::GetMgmtTreeCommand(ProfileComponentsHolder* holder, const String& uri, String& mgmtTree, 
		NS_Common::EventEx* executionCompleted, bool& executionResult): 
		IMOTreeCommand(holder, 0, executionCompleted, executionResult), m_uri(uri), m_mgmtTree(mgmtTree)
	{
	}
	//-------------------------------------------------------------------------------------------

	bool GetMgmtTreeCommand::run(IMOTreeManager& treeManager)
	{
		LOG_(m_logger, "GetMgmtTreeCommand started");
		NS_DM_Client::IMOTreeManager::RequiredProperties reqPropetries;

		reqPropetries.push_back(e_TNDS_format);
		reqPropetries.push_back(e_TNDS_tstamp);
		reqPropetries.push_back(e_TNDS_title);
		reqPropetries.push_back(e_TNDS_value);
		reqPropetries.push_back(e_TNDS_type);
		reqPropetries.push_back(e_TNDS_ACL);
		reqPropetries.push_back(e_TNDS_name);

		Funambol::StringBuffer* xml = 0;
		LOG_(m_logger, "Trying to extract information from tree");
		NS_DM_Client::StatusCode res = treeManager.GetAttributeTNDS(m_uri, reqPropetries, xml);
		if (res == NS_DM_Client::e_Ok)
		{
			m_mgmtTree = xml->c_str();
			return true;
		}
		return false;
	}
}
