#pragma once

#include "IFIFOWrapper.h"
#include <queue>

namespace NS_DM_Client
{
	typedef unsigned char byte;
	class ClientAdapterProxy;
	class ClientAdapterStub;

	void SetFIFOWrappers(ClientAdapterProxy& clientAdapterProxy, NS_DM_Client::IFIFOWrapper* inFIFOWrapper, 
		NS_DM_Client::IFIFOWrapper* outFIFOWrapper);
	void SetFIFOWrappers(ClientAdapterStub& clientAdapterStub, NS_DM_Client::IFIFOWrapper* inFIFOWrapper, 
		NS_DM_Client::IFIFOWrapper* outFIFOWrapper);

	// simulate FIFO's interprocess work but in the same process
	class MockFIFOWrapper: public IFIFOWrapper
	{
		friend void ClearFIFO(MockFIFOWrapper& fifoWrapper);

	public:
		MockFIFOWrapper();
		virtual ~MockFIFOWrapper();

		virtual StatusCode Open(const String& name, bool readMode, bool blockedMode, bool immediateOpen = false);
		virtual StatusCode Read(Buffer& buffer, bool exitIfNoWriter = false);
		virtual StatusCode Write(const Buffer& buffer, bool exitIfNoReader = false);
		virtual StatusCode Write(const void* buffer, size_t length, bool exitIfNoReader = false);
		virtual StatusCode Close();
		virtual void Release();

		size_t GetMessagesCount() const;
		void FreezeOff();

	private:
		void freeze();

	protected:
		virtual StatusCode open();

	private:
		typedef std::vector<byte> QueueData;
		std::queue<QueueData> m_queue;
		bool m_isFreezed;
	};

	void ClearFIFO(MockFIFOWrapper& fifoWrapper);
}
