/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#pragma once

#include <iostream>

namespace NS_DM_Client
{
	class IFIFOWrapper;
	class ProfileComponentsHolder;
	class IMOTreeManager;
	class INotificationCenter;
	class IServerExchangeManager;

	namespace NS_Daemon
	{
		class Configuration;
	}
}

extern NS_DM_Client::IFIFOWrapper* S_inFIFOWrapper;
extern NS_DM_Client::IFIFOWrapper* S_outFIFOWrapper;
extern NS_DM_Client::ProfileComponentsHolder* S_profileHolder;
extern NS_DM_Client::IMOTreeManager* S_treeManager;
extern NS_DM_Client::NS_Daemon::Configuration* S_configuration;
extern NS_DM_Client::INotificationCenter* S_notificationCenter;
extern NS_DM_Client::IServerExchangeManager* S_serverExchangeManager;

void SimulateResponse(NS_DM_Client::IFIFOWrapper* fifoWrapper, size_t msdId, size_t msgType, 
					  size_t msgSubType, const std::string& data = "");
void SimulateRequest(NS_DM_Client::IFIFOWrapper* fifoWrapper, size_t msdId, size_t msgType, 
					  size_t msgSubType, const std::string& data = "");
void FreezeOffFIFO(NS_DM_Client::IFIFOWrapper* fifoWrapper);

void FillDevInfoAsTnds(std::string& tndsDevInfo);

void Wait(int ms = 2000);
void TearDown();

