/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include "Errors.h"
#include "treemanager/MOTreeCommand.h"
#include "serverexchange/commands/ServerExchangeCommand.h"
#include "serverexchange/wrappers/SCommandAdapter.h"
#include "serverexchange/ICommandsSink.h"
	
namespace NS_DM_Client
{
    class MOTreeResponseCommand : public ServerExchangeCommand
    {
    public:
        MOTreeResponseCommand(IServerExchangeManager &sem,
							  AbstractCommandPtr cmd, 
							  StatusCode cmdStatus, 
							  const String& msgID,
							  const char *serverid);

        MOTreeResponseCommand(IServerExchangeManager &sem,
							  ItemizedCommandPtr cmd, 
							  StatusCode cmdStatus, 
							  const String& msgID,
							  const char *serverid);
        
		virtual ~MOTreeResponseCommand();
		virtual bool Execute();
		void SetCommandsSink(NS_SyncMLCommand::ICommandsSink &);

	protected:
        AbstractCommandPtr	      m_acommand;
        ItemizedCommandPtr	      m_icommand;
        StatusCode			      m_status;
        const String		      m_messageID;
		const char              * m_serverID;
		NS_SyncMLCommand::ICommandsSink           * m_pCommandsSink;
		
        void enqueueCommand(NS_SyncMLCommand::SCommandPtr ptrCommand);

    private:

        bool performOperation();
    };
}
