/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include <vector>
#include "treemanager/MOTreeResponseCommand.h"
#include "serverexchange/commands/ServerExchangeCommand.h"

namespace NS_DM_Client
{
    using namespace NS_SyncMLCommand;

    class AlertResponseCommand : public MOTreeResponseCommand
    {
    public:
		AlertResponseCommand(ProfileComponentsHolder* prholder,
							 AlertPtr& command,
							 StatusCode getCommandStatus,
							 const String& msgID,
							 std::vector<String> &results,
							 const char *serverid);
		virtual ~AlertResponseCommand();

		virtual bool Execute();

    private:
		AlertPtr m_AlertCommand;
		std::vector<String> m_results;

		AlertResponseCommand(const AlertResponseCommand&);
		AlertResponseCommand& operator =(const AlertResponseCommand&);

		bool performOperation();
    };
}
