/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include "Errors.h"
#include "serverexchange/commands/AlertCodes.h"
#include "serverexchange/wrappers/SAlertCommand.h"
#include "serverexchange/wrappers/SCommandAdapter.h"
#include "serverexchange/wrappers/SResultsCommand.h"
#include "serverexchange/wrappers/SStatusCommand.h"

namespace NS_DM_Client
{
	namespace NS_SyncMLCommand
	{
		/// Class SCommandFactory provides general interface to create parts of
		/// SyncML message. SCommandFactory creates wrappers for commands Add, Get, Replace, Delete
		/// and for Status and Results as well.
		class SCommandFactory
		{
		public:

			/// Create Alert
			///		<Alert>
			///			<Data>@alertCode</Data>
			///		</Alert>
			static SAlertCommandPtr CreateAlert(const AlertCode alertCode);

			static SAlertCommandPtr CreateAlertOnFWDownload(int result, ExecPtr &exec, const char *alertType);

			/// Create generic alert command
			/// @param uri value inserted into the Source section
			/// @param reqtype value inserted into Meta::Type section
			/// @param data value inserted into data section
			static SAlertCommandPtr CreateGenericAlert(const char *srcuri, const char *reqtype, int data);


			/// Create Alert
			///		<Alert>
			///			<Data>@alertCode</Data>
			///			<Item>
			///				<Meta>
			///					<Type>@atype</Type>
			///                 <Format>text/plain</Format>
			///				</Meta>
			///				<Source>@itemsource</Source>
			///				<Data>![CDATA[@data]]</Data>
			///			</Item>
			///		</Alert>
			static SAlertCommandPtr CreateAlert(const AlertCode alertCode, const char *srcuri, const char *atype, int data);

			/// Create Replace section of message
			/// DevInf reference is used to fill data of Replace command.
			static SCommandPtr CreateReplaceDevInf(Funambol::DevInf &devInf);
			static SCommandPtr CreatePutDevInf(Funambol::DevInf &devInf);

			/// Create Status section of reply.
			/// @param data status code
			static SStatusCommandPtr CreateStatus(StatusCode data);
			static SStatusCommandPtr CreateStatus(StatusCode data, Funambol::AbstractCommand &cmd);
			static SStatusCommandPtr CreateStatus(StatusCode data, Funambol::ItemizedCommand &cmd);


			/// Create Results section of message.
			/// @param cmd command that was processed
			/// @param results array of Funambol::Item* which contains data processing results
			/// @param msgref id of server message which contains requested command
			static SResultsCommandPtr CreateResult(Funambol::ItemizedCommand &cmd, Funambol::ArrayList &results, const char *msgref);
			static SResultsCommandPtr CreateResult(ItemizedCommandPtr &ptrCommand, Funambol::ArrayList &results, const char *msgref);

		private:
			SCommandFactory();
			~SCommandFactory();
		};
	}
}
