/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include "serverexchange/wrappers/SCommandAdapter.h"

namespace NS_DM_Client
{
    namespace NS_SyncMLCommand
    {
    	/**
    	 * Class is able to represent one Funambol::Results message with large binary object or
    	 * multiple items as a sequence of Results objects where large object is divided into smaller chunks
    	 * and multiple items are spread in.
    	 */
        class LOResults
        {
        public:
			/**
			 * @param results Results object which should be separated into smaller parts
			 * @param resultMaxSize sets the max size of the Results message including binary
			 *        data and <MoreData/> tag, if required
			 */
			LOResults(ResultsPtr results, unsigned int resultMaxSize, unsigned int maxObjSize);
			~LOResults();

			/**
			 * Check if all parts, the initial message was devided to, have been retrived from the class.
			 */
			bool HasAllChunksCreated();

			/**
			 * Return size of the next chunk (Results command) with no Data payload inserted.
			 */
			unsigned int GetNextChunkEmptySize();

			/**
			 * Retrive next chunk of the initial Results message.
			 * If returned shared pointer contains NULL, all chunks have alrady been retrived.
			 * @param maxSize sets the max size of the data to be inserted into the Data section in the Item
			 * @return shared pointer to next Results
			 **/
			ResultsPtr GetNextChunk(const char * cmdid, int maxSize);

		private:
			bool         m_firstChunk;		// indicates whether the first chunk is being prepared
			int          m_curritemindex;	// index of item in the Results items list
			int          m_maxsize;
			const int    m_maxobjsize;		// max size of binary data to be set into the Data section
			int          m_buffersize;		// size of the data buffer allocated for the LO
			int          m_bufferpos;		// carret position within the data buffer
			const char * m_buffer;			// buffer with data to be split into the parts
			ResultsPtr   m_rescmd;			// initial Results command with LO inside it
			Funambol::ArrayList *m_items;

			Funambol::Meta * getMetaFrom(Funambol::Item &item);
			Funambol::Item * currentItem();
        };
    }
}

