/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include "executionqueue/ICommand.h"
#include "serverexchange/ICommandsSink.h"
#include "serverexchange/commands/AlertCodes.h"
#include "serverexchange/wrappers/SAlertCommand.h"
#include "NotificationListener/SessionInfo.h"

namespace NS_DM_Client
{
	class ProfileComponentsHolder;

	namespace NS_Common {
		class Event;
	}

	namespace NS_Communication {
		class ConnectionInfo;
		class IConnection : public NS_SyncMLCommand::ICommandsSink
		{
		public:
			virtual ~IConnection() {};

			virtual void Abort() = 0;

			virtual ConnectionInfo & Info() = 0;
			virtual bool IsRunning() = 0;

			virtual void RequestSessionStart(const NS_NotificationListener::SessionInfo& sessionInfo) = 0;
			virtual void RequestFWUpdate(bool userInitiated, const char *fumouri, int data) = 0;

			virtual void SetPCH(ProfileComponentsHolder &) = 0;

			virtual void Start(NS_Common::Event *e = NULL) = 0;
			virtual void StartSession(const NS_SyncMLCommand::AlertCode ac = NS_SyncMLCommand::AC_CLIENT_INITIATED_MGMT) = 0;
			virtual void StartSession(NS_SyncMLCommand::SAlertCommandPtr) = 0;
			virtual void Stop() = 0;

			virtual void Wait() = 0;
		};

		typedef boost::shared_ptr<IConnection> ConnectionPtr;
	}
}

