/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#pragma once

#include "Errors.h"
#include "treemanager/MOTreeResponseCommand.h"

namespace NS_DM_Client
{
	class FWStatusCommand : public MOTreeResponseCommand
	{
	public:
		FWStatusCommand(ProfileComponentsHolder *ph,
						ExecPtr cmd,
						StatusCode cmdStatus,
						const char *serverid,
						const char *cor);
		virtual ~FWStatusCommand();

		virtual bool Execute();

	private:
		char      *m_correlator;
		ExecPtr    m_ExecCommand;
		StatusCode m_code;
		//NS_Logging::Logger &m_logger;

		FWStatusCommand(const FWStatusCommand&);
		FWStatusCommand& operator = (const FWStatusCommand&);
	};
}
