/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include <daemon/IComponent.h>

namespace NS_DM_Client
{
	class ICommand;

	class IExecutionQueue : public IComponent
	{
	public:
		virtual ~IExecutionQueue() {};

		/// Adds command to Queue where it will be started.
		/// The command will be executed when other commands added before it will be competed.
		/// @param cmd command instance allocated on heap. Deleted by the Queue if successfully added.
		/// @return 'true' if the commnand successfully added to Queue. The command will be deleted by the Queue.
		/// 'false' if command was not added to Queue. Caller responsible for command deletion.
		virtual bool Add(ICommand& cmd) = 0;

    protected:
        IExecutionQueue() {};

    private:
		IExecutionQueue(const IExecutionQueue&);
		IExecutionQueue& operator = (const IExecutionQueue&);
	};

}
