/*
 * Decompiled with CFR 0.152.
 */
package org.kxml.wap;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.kxml.PrefixMap;
import org.kxml.io.AbstractXmlWriter;
import org.kxml.io.State;

public class WbxmlWriter
extends AbstractXmlWriter {
    private HashMap stringTable = new HashMap();
    protected OutputStream out;
    protected ByteArrayOutputStream buf = new ByteArrayOutputStream();
    private ByteArrayOutputStream stringTableBuf = new ByteArrayOutputStream();
    private String pending;
    private List attributes = new ArrayList();
    private HashMap attrStartTable = new HashMap();
    private HashMap attrValueTable = new HashMap();
    private HashMap tagTable = new HashMap();
    private int currentPage = 0;
    private HashMap otherAttrStartTables = new HashMap();
    private HashMap otherAttrValueTables = new HashMap();
    private HashMap otherTagTables = new HashMap();

    public WbxmlWriter(OutputStream out) throws IOException {
        this.out = out;
        this.buf = new ByteArrayOutputStream();
        this.stringTableBuf = new ByteArrayOutputStream();
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws IOException {
        this.writeHeader();
        WbxmlWriter.writeInt(this.out, this.stringTableBuf.size());
        this.out.write(this.stringTableBuf.toByteArray());
        this.out.write(this.buf.toByteArray());
        this.out.flush();
    }

    protected void writeHeader() throws IOException {
        this.out.write(2);
        this.out.write(1);
        this.out.write(106);
    }

    private Integer searchToken(String pending, HashMap table) {
        Integer idx = null;
        int[] pages = new int[table.size()];
        int cont = 0;
        Set keyset = table.keySet();
        for (Integer page : keyset) {
            pages[cont++] = page;
        }
        this.sort(pages);
        for (int i = 0; i < pages.length; ++i) {
            HashMap h = (HashMap)table.get(new Integer(pages[i]));
            idx = (Integer)h.get(pending);
            if (idx == null) continue;
            this.switchPage(new Integer(pages[i]));
            break;
        }
        return idx;
    }

    private void switchPage(Integer page) {
        this.currentPage = page;
        this.tagTable = (HashMap)this.otherTagTables.get(page);
        this.attrStartTable = (HashMap)this.otherAttrStartTables.get(page);
        this.attrValueTable = (HashMap)this.otherAttrValueTables.get(page);
        if (this.tagTable == null) {
            this.tagTable = new HashMap();
        }
        if (this.attrStartTable == null) {
            this.attrStartTable = new HashMap();
        }
        if (this.attrValueTable == null) {
            this.attrValueTable = new HashMap();
        }
        this.buf.write(0);
        this.buf.write(page);
    }

    public void checkPending(boolean degenerated) throws IOException {
        if (this.pending == null) {
            return;
        }
        int len = this.attributes.size();
        Integer idx = (Integer)this.tagTable.get(this.pending);
        if (idx == null) {
            idx = this.searchToken(this.pending, this.otherTagTables);
        }
        if (idx == null) {
            this.buf.write(len == 0 ? (degenerated ? 4 : 68) : (degenerated ? 132 : 196));
            this.writeStrT(this.pending);
        } else {
            this.buf.write(len == 0 ? (degenerated ? idx : idx | 0x40) : (degenerated ? idx | 0x80 : idx | 0xC0));
        }
        for (int i = 0; i < len; ++i) {
            idx = (Integer)this.attrStartTable.get(this.attributes.get(i) + "=" + this.attributes.get(i + 1));
            if (idx == null) {
                idx = this.searchToken((String)this.attributes.get(i) + "=" + (String)this.attributes.get(i + 1), this.otherAttrStartTables);
            }
            if (idx != null) {
                this.buf.write(idx);
                ++i;
                continue;
            }
            idx = (Integer)this.attrStartTable.get(this.attributes.get(i));
            if (idx == null) {
                idx = this.searchToken((String)this.attributes.get(i), this.otherAttrStartTables);
            }
            if (idx == null) {
                this.buf.write(4);
                this.writeStrT((String)this.attributes.get(i));
            } else {
                this.buf.write(idx);
            }
            idx = (Integer)this.attrValueTable.get(this.attributes.get(++i));
            if (idx == null) {
                idx = this.searchToken((String)this.attributes.get(i), this.otherAttrValueTables);
            }
            if (idx == null) {
                this.buf.write(3);
                WbxmlWriter.writeStrI(this.buf, (String)this.attributes.get(i));
                continue;
            }
            this.buf.write(idx);
        }
        if (len > 0) {
            this.buf.write(1);
        }
        this.pending = null;
        this.attributes.clear();
    }

    @Override
    public void startTag(PrefixMap prefixMap, String name) throws IOException {
        this.current = new State(this.current, prefixMap, name);
        this.checkPending(false);
        this.pending = name;
    }

    @Override
    public void attribute(String name, String value) {
        this.attributes.add(name);
        this.attributes.add(value);
    }

    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    public void write(byte[] bytes, int start, int len) throws IOException {
        this.checkPending(false);
        this.buf.write(195);
        WbxmlWriter.writeInt(this.buf, len);
        WbxmlWriter.writeOpaque((OutputStream)this.buf, bytes, start, len);
    }

    @Override
    public void write(char[] chars, int start, int len) throws IOException {
        this.write(chars, start, len, false);
    }

    public void write(char[] chars, int start, int len, boolean opaque) throws IOException {
        this.checkPending(false);
        if (opaque) {
            this.buf.write(195);
            WbxmlWriter.writeInt(this.buf, len);
            WbxmlWriter.writeOpaque((OutputStream)this.buf, chars, start, len);
        } else {
            this.buf.write(3);
            WbxmlWriter.writeStrI(this.buf, new String(chars, start, len));
        }
    }

    @Override
    public void endTag() throws IOException {
        this.current = this.current.prev;
        if (this.pending != null) {
            this.checkPending(true);
        } else {
            this.buf.write(1);
        }
    }

    @Override
    public void writeLegacy(int type, String data) {
    }

    static void writeInt(OutputStream out, int i) throws IOException {
        byte[] buf = new byte[5];
        int idx = 0;
        do {
            buf[idx++] = (byte)(i & 0x7F);
        } while ((i >>= 7) != 0);
        while (idx > 1) {
            out.write(buf[--idx] | 0x80);
        }
        out.write(buf[0]);
    }

    static void writeStrI(OutputStream out, String s) throws IOException {
        out.write(s.getBytes());
        out.write(0);
    }

    static void writeOpaque(OutputStream out, byte[] bytes, int start, int length) throws IOException {
        for (int i = start; i < length; ++i) {
            out.write(bytes[i]);
        }
    }

    static void writeOpaque(OutputStream out, char[] chars, int start, int length) throws IOException {
        String s = new String(chars, start, length);
        out.write(s.getBytes());
    }

    static void writeBytes(OutputStream out, byte[] bytes, int start, int length) throws IOException {
        for (int i = start; i < length; ++i) {
            out.write(bytes[i]);
        }
    }

    void writeStrT(String s) throws IOException {
        Integer idx = (Integer)this.stringTable.get(s);
        if (idx == null) {
            idx = new Integer(this.stringTableBuf.size());
            this.stringTable.put(s, idx);
            WbxmlWriter.writeStrI(this.stringTableBuf, s);
            this.stringTableBuf.flush();
        }
        WbxmlWriter.writeInt(this.buf, idx);
    }

    private HashMap processTable(String[] table, int offset, int page, HashMap otherTables) {
        HashMap<String, Integer> h = new HashMap<String, Integer>();
        for (int i = 0; i < table.length; ++i) {
            if (table[i] == null) continue;
            Integer idx = new Integer(i + offset);
            h.put(table[i], idx);
        }
        otherTables.put(new Integer(page), h);
        return h;
    }

    public void setTagTable(int page, String[] tagTable) {
        HashMap temp = this.processTable(tagTable, 5, page, this.otherTagTables);
        if (page == 0) {
            this.tagTable = temp;
        }
    }

    public void setAttrStartTable(int page, String[] attrStartTable) {
        HashMap temp = this.processTable(attrStartTable, 5, page, this.otherAttrStartTables);
        if (page == 0) {
            this.attrStartTable = temp;
        }
    }

    public void setAttrValueTable(int page, String[] attrValueTable) {
        HashMap temp = this.processTable(attrValueTable, 128, page, this.otherAttrValueTables);
        if (page == 0) {
            this.attrValueTable = temp;
        }
    }

    private void sort(int[] pages) {
        int num = pages.length;
        for (int out = num - 1; out > 1; --out) {
            for (int in = 0; in < out; ++in) {
                if (pages[in] <= pages[in + 1]) continue;
                int temp = pages[in];
                pages[in] = pages[in + 1];
                pages[in + 1] = temp;
            }
        }
    }
}

