/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.server.session;

import com.funambol.framework.config.Configuration;
import com.funambol.framework.config.ConfigurationConstants;
import com.funambol.framework.core.AbstractCommand;
import com.funambol.framework.core.Alert;
import com.funambol.framework.core.AlertCode;
import com.funambol.framework.core.Authentication;
import com.funambol.framework.core.Chal;
import com.funambol.framework.core.ComplexData;
import com.funambol.framework.core.Cred;
import com.funambol.framework.core.Data;
import com.funambol.framework.core.Get;
import com.funambol.framework.core.Item;
import com.funambol.framework.core.ItemizedCommand;
import com.funambol.framework.core.Map;
import com.funambol.framework.core.MapItem;
import com.funambol.framework.core.Meta;
import com.funambol.framework.core.ModificationCommand;
import com.funambol.framework.core.NextNonce;
import com.funambol.framework.core.RepresentationException;
import com.funambol.framework.core.Results;
import com.funambol.framework.core.Source;
import com.funambol.framework.core.SourceRef;
import com.funambol.framework.core.Status;
import com.funambol.framework.core.Sync;
import com.funambol.framework.core.Sync4jException;
import com.funambol.framework.core.SyncBody;
import com.funambol.framework.core.SyncHdr;
import com.funambol.framework.core.SyncML;
import com.funambol.framework.core.Target;
import com.funambol.framework.core.TargetRef;
import com.funambol.framework.core.Util;
import com.funambol.framework.database.Database;
import com.funambol.framework.engine.SyncEngine;
import com.funambol.framework.engine.SyncItem;
import com.funambol.framework.engine.SyncItemImpl;
import com.funambol.framework.engine.SyncOperation;
import com.funambol.framework.engine.source.MemorySyncSource;
import com.funambol.framework.engine.source.SyncSource;
import com.funambol.framework.protocol.ClientCompletion;
import com.funambol.framework.protocol.ClientModifications;
import com.funambol.framework.protocol.ProtocolException;
import com.funambol.framework.protocol.ProtocolUtil;
import com.funambol.framework.protocol.SyncInitialization;
import com.funambol.framework.security.Officer;
import com.funambol.framework.security.SecurityConstants;
import com.funambol.framework.security.Sync4jPrincipal;
import com.funambol.framework.server.ClientMapping;
import com.funambol.framework.server.LastTimestamp;
import com.funambol.framework.server.Sync4jDevice;
import com.funambol.framework.server.SyncTimestamp;
import com.funambol.framework.server.error.InvalidCredentialsException;
import com.funambol.framework.server.error.ServerException;
import com.funambol.framework.server.session.SessionHandler;
import com.funambol.framework.server.session.SyncState;
import com.funambol.framework.server.store.NotFoundException;
import com.funambol.framework.server.store.PersistentStore;
import com.funambol.framework.server.store.PersistentStoreException;
import com.funambol.framework.tools.ArrayUtils;
import com.funambol.framework.tools.Base64;
import com.funambol.framework.tools.CommandIdGenerator;
import com.funambol.framework.tools.SimpleIdGenerator;
import com.funambol.framework.tools.SizeCalculator;
import com.funambol.server.engine.Sync4jSyncEngine;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.jboss.logging.Logger;

public class SyncSessionHandler
implements SessionHandler,
Serializable,
ConfigurationConstants,
SecurityConstants {
    public static final int STATE_INITIALIZATION_PROCESSING = 16;
    public static final int STATE_INITIALIZATION_PROCESSED = 17;
    public static final int STATE_SYNCHRONIZATION_PROCESSING = 18;
    public static final int STATE_SYNCHRONIZATION_PROCESSED = 19;
    public static final int STATE_SYNCHRONIZATION_COMPLETION = 20;
    private int currentState = 0;
    private boolean slow = false;
    private long creationTimestamp = -1L;
    private static final transient Logger log = Logger.getLogger((String)SyncSessionHandler.class.getName());
    private SyncTimestamp nextTimestamp = null;
    private transient SyncInitialization syncInit = null;
    private transient ClientModifications modifications = null;
    private java.util.Map<String, ClientMapping> clientMappings = null;
    private String clientDeviceId = null;
    Database[] dbs = null;
    private String serverAuthType = null;
    private ArrayList addStatus = new ArrayList();
    private ArrayList addAlert = new ArrayList();
    private ArrayList<AbstractCommand> addAbsCmd = new ArrayList();
    private long maxSizeAvailable = 0L;
    private String sessionId = null;
    private CommandIdGenerator cmdIdGenerator = new CommandIdGenerator();
    private SimpleIdGenerator msgIdGenerator = new SimpleIdGenerator();
    private String lastMsgIdFromClient = null;
    private Sync4jSyncEngine syncEngine = null;
    private boolean guestEnabled = false;
    private SyncState syncState = null;
    private String mimeType = null;
    private boolean newSession = true;
    private boolean canSendAlerts = true;
    private boolean finalMsg = false;

    public int getCurrentState() {
        return this.currentState;
    }

    public long getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public Sync4jDevice getDevice() {
        return this.syncState.device;
    }

    public void setCommandIdGenerator(CommandIdGenerator cmdIdGenerator) {
        this.cmdIdGenerator = cmdIdGenerator;
    }

    public CommandIdGenerator getCommandIdGenerator() {
        return this.cmdIdGenerator;
    }

    private void resetIdGenerator() {
        this.cmdIdGenerator.reset();
        this.syncEngine.setCommandIdGenerator(this.cmdIdGenerator);
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public SyncEngine getSyncEngine() {
        return this.syncEngine;
    }

    public void setNew(boolean newSession) {
        this.newSession = newSession;
    }

    public boolean isNew() {
        return this.newSession;
    }

    public SyncSessionHandler() {
        this.creationTimestamp = System.currentTimeMillis();
        this.syncEngine = new Sync4jSyncEngine(Configuration.getConfiguration());
    }

    public SyncSessionHandler(String sessionId) {
        this();
        this.sessionId = sessionId;
    }

    public boolean isAuthenticated() {
        return this.syncState.authenticationState == 4;
    }

    public boolean isAccountExpired() {
        return this.syncEngine.getOfficer().isAccountExpired();
    }

    /*
     * Unable to fully structure code
     */
    public SyncML processMessage(SyncML message) throws ProtocolException, InvalidCredentialsException {
        syncWithInit = false;
        response = null;
        this.resetIdGenerator();
        this.msgIdGenerator.next();
        this.lastMsgIdFromClient = message.getSyncHdr().getMsgID();
        this.clientDeviceId = message.getSyncHdr().getSource().getLocURI();
        if (SyncSessionHandler.log.isEnabled(Logger.Level.TRACE)) {
            SyncSessionHandler.log.trace((Object)("current state: " + this.getStateName(this.currentState)));
        }
        chal = ProtocolUtil.getStatusChal((SyncML)message);
        try {
            block2 : switch (this.currentState) {
                case 0: 
                case 65535: {
                    this.nextTimestamp = new SyncTimestamp();
                    this.nextTimestamp.start = System.currentTimeMillis();
                    this.nextTimestamp.tagClient = String.valueOf(this.nextTimestamp.start);
                    this.syncState = new SyncState();
                    meta = message.getSyncHdr().getMeta();
                    if (meta != null) {
                        this.syncState.setMaxMsgSize(meta.getMaxMsgSize().longValue());
                    }
                    this.syncState.device = new Sync4jDevice(this.clientDeviceId);
                    this.syncEngine.readDevice(this.syncState.device);
                    this.syncState.syncMLVerProto = message.getSyncHdr().getVerProto().getVersion();
                    this.syncEngine.setSyncMLVerProto(this.syncState.syncMLVerProto);
                    this.moveTo(16);
                    cred = message.getSyncHdr().getCred();
                    if (this.checkAuthType(cred)) ** GOTO lbl34
                    this.syncState.loggedCredential = null;
                    this.syncState.authenticationState = 3;
                    if (cred == null && !this.isGuestEnabled()) {
                        this.syncState.authenticationState = 2;
                    }
                    ** GOTO lbl45
lbl34:
                    // 1 sources

                    this.login(message.getSyncHdr().getCred(), this.clientDeviceId);
                    if (this.isAuthenticated()) {
                        try {
                            this.syncEngine.readPrincipal(this.syncState.loggedPrincipal);
                        }
                        catch (NotFoundException e) {
                            if (SyncSessionHandler.log.isEnabled(Logger.Level.INFO)) {
                                SyncSessionHandler.log.info((Object)("Authenticated principal not found:" + this.syncState.loggedPrincipal));
                            }
                            this.syncState.authenticationState = 3;
                            this.syncState.loggedCredential = null;
                        }
                    }
                }
lbl45:
                // 6 sources

                case 16: {
                    response = this.processInitMessage(message);
                    if (!this.isAuthenticated()) {
                        this.moveTo(0);
                        break;
                    }
                    this.moveTo(17);
                }
                case 17: {
                    if (this.isAuthenticated() && chal != null && "syncml:auth-md5".equals(chal.getType())) {
                        this.syncState.device.setServerNonce(Base64.decode((byte[])chal.getNextNonce().getValue()));
                        this.syncEngine.storeDevice(this.syncState.device);
                    }
                    if (syncWithInit = this.checkSyncInit(message)) {
                        this.moveTo(18);
                        if (SyncSessionHandler.log.isEnabled(Logger.Level.TRACE)) {
                            SyncSessionHandler.log.trace((Object)"Sync message without separate initialization");
                        }
                    } else {
                        if (SyncSessionHandler.log.isEnabled(Logger.Level.TRACE)) {
                            SyncSessionHandler.log.trace((Object)"Sync with separate initalization");
                        }
                        if (message.getSyncBody().isFinalMsg()) {
                            this.moveTo(18);
                            break;
                        }
                        this.moveTo(16);
                        break;
                    }
                }
                case 18: {
                    syncWithInit = this.checkSyncInit(message);
                    if (syncWithInit) {
                        if (response == null) {
                            response = this.processInitMessage(message);
                        } else if (this.syncState.serverAuthenticationState == 1) {
                            credential = this.checkServerAuthentication(message);
                            response.getSyncHdr().setCred(credential);
                        }
                    }
                    this.syncState.setSyncWithInit(syncWithInit);
                    this.syncState.setResponseInit(response);
                    cmds = message.getSyncBody().getCommands().toArray(new AbstractCommand[0]);
                    list = ProtocolUtil.filterCommands((AbstractCommand[])cmds, Map.class);
                    if (list.size() > 0) {
                        this.processCompletionMessage(message);
                        this.storeClientMappings();
                        this.resetClientMappings();
                    }
                    response = this.processSyncMessage(message);
                    this.storeClientMappings();
                    this.resetClientMappings();
                    if (message.getSyncBody().isFinalMsg()) {
                        this.nextTimestamp.end = System.currentTimeMillis();
                        this.commit();
                        if (ProtocolUtil.noMoreResponse((SyncML)message)) {
                            this.moveTo(18);
                            break;
                        }
                        if (response.getSyncBody().isFinalMsg()) {
                            this.moveTo(20);
                            break;
                        }
                        this.moveTo(18);
                        this.syncState.setResponseFinal(false);
                        break;
                    }
                    if (this.syncState.getStatusCmdOut().isEmpty() && this.syncState.getAlertCmdOut().isEmpty() && this.syncState.getCmdOut().isEmpty() && response.getSyncBody().isFinalMsg()) {
                        if (!this.syncState.getMapStatusOut().isEmpty()) {
                            this.finalMsg = false;
                            response.getSyncBody().setFinalMsg(Boolean.FALSE);
                        } else {
                            this.finalMsg = true;
                            response.getSyncBody().setFinalMsg(Boolean.TRUE);
                        }
                        this.moveTo(20);
                        this.nextTimestamp.end = System.currentTimeMillis();
                        this.commit();
                        break;
                    }
                    if (this.addAbsCmd != null) {
                        for (i = 0; i < this.addAbsCmd.size(); ++i) {
                            ac = this.addAbsCmd.get(i);
                            if (ac instanceof Results || ac instanceof Get) {
                                this.finalMsg = true;
                                response.getSyncBody().setFinalMsg(Boolean.TRUE);
                                break block2;
                            }
                            this.finalMsg = false;
                            response.getSyncBody().setFinalMsg(Boolean.FALSE);
                        }
                        break;
                    }
                    this.finalMsg = false;
                    response.getSyncBody().setFinalMsg(Boolean.FALSE);
                    break;
                }
                case 20: {
                    response = this.processCompletionMessage(message);
                    this.storeClientMappings();
                    this.resetClientMappings();
                    if (message.getSyncBody().isFinalMsg()) {
                        if (response.getSyncBody().isFinalMsg()) {
                            this.finalMsg = true;
                            response.setLastMessage(true);
                            this.moveTo(1);
                        }
                        break;
                    }
                    this.finalMsg = false;
                    response.getSyncBody().setFinalMsg(Boolean.FALSE);
                    this.moveTo(20);
                    break;
                }
                default: {
                    this.logout();
                    throw new ProtocolException("Illegal state: " + this.currentState);
                }
            }
        }
        catch (ProtocolException e) {
            SyncSessionHandler.log.debug((Object)"processMessage", (Throwable)e);
            this.moveTo(65535);
            throw e;
        }
        catch (NotFoundException e) {
            SyncSessionHandler.log.debug((Object)"processMessage", (Throwable)e);
            this.moveTo(65535);
            throw new InvalidCredentialsException("Invalid credential error", (Throwable)e);
        }
        catch (PersistentStoreException e) {
            SyncSessionHandler.log.debug((Object)"processMessage", (Throwable)e);
            this.moveTo(65535);
            throw new ProtocolException("Persistent store error", (Throwable)e);
        }
        catch (Throwable t) {
            t.printStackTrace();
            SyncSessionHandler.log.debug((Object)"processMessage", t);
            this.moveTo(65535);
        }
        if (SyncSessionHandler.log.isEnabled(Logger.Level.TRACE)) {
            SyncSessionHandler.log.trace((Object)("About returning message: " + Util.toXML((SyncML)response)));
        }
        return response;
    }

    private boolean checkAuthType(Cred cred) {
        Officer officer = this.syncEngine.getOfficer();
        this.serverAuthType = officer.getAuthType();
        if (cred == null) {
            this.syncState.authenticationState = officer.isGuestEnabled() ? 4 : 2;
            return officer.isGuestEnabled();
        }
        String clientAuthType = cred.getType();
        if (this.serverAuthType.equalsIgnoreCase(clientAuthType)) {
            return true;
        }
        this.syncState.authenticationState = 4;
        return false;
    }

    private SyncML mergeResponse(SyncML init, SyncML sync) throws RepresentationException {
        int i;
        SyncHdr header = null;
        SyncBody body = null;
        TreeMap<Integer, AbstractCommand> tmOtherCmd = new TreeMap<Integer, AbstractCommand>();
        ArrayList<AbstractCommand> alStatus = new ArrayList<AbstractCommand>();
        ArrayList<Object> al = new ArrayList<Object>();
        if (init != null) {
            AbstractCommand[] initCmd = init.getSyncBody().getCommands().toArray(new AbstractCommand[0]);
            for (i = 0; i < initCmd.length; ++i) {
                if (initCmd[i] instanceof Status) {
                    alStatus.add(initCmd[i]);
                    continue;
                }
                String key = initCmd[i].getCmdID().getCmdID();
                tmOtherCmd.put(new Integer(key), initCmd[i]);
            }
        }
        if (sync != null) {
            AbstractCommand[] syncCmd = sync.getSyncBody().getCommands().toArray(new AbstractCommand[0]);
            for (i = 0; i < syncCmd.length; ++i) {
                if (syncCmd[i] instanceof Status) {
                    boolean isSyncHdr = false;
                    if ("0".equals(((Status)syncCmd[i]).getCmdRef()) && "SyncHdr".equals(((Status)syncCmd[i]).getCmd())) {
                        for (int a = 0; a < alStatus.size(); ++a) {
                            Status sc = (Status)alStatus.get(a);
                            if (!sc.getCmdRef().equals("0") || !sc.getCmd().equals("SyncHdr")) continue;
                            isSyncHdr = true;
                            break;
                        }
                        if (isSyncHdr) continue;
                        alStatus.add(syncCmd[i]);
                        continue;
                    }
                    alStatus.add(syncCmd[i]);
                    continue;
                }
                String key = syncCmd[i].getCmdID().getCmdID();
                tmOtherCmd.put(new Integer(key), syncCmd[i]);
            }
        }
        List<Object> list = Arrays.asList(ProtocolUtil.sortStatusCommand((Object[])alStatus.toArray(new AbstractCommand[0])));
        al.addAll(list);
        Set set1 = tmOtherCmd.keySet();
        for (Integer key : set1) {
            al.add(tmOtherCmd.get(key));
        }
        AbstractCommand[] cmds = al.toArray(new AbstractCommand[0]);
        if (init != null) {
            header = init.getSyncHdr();
            body = new SyncBody(cmds, init.getSyncBody().isFinalMsg());
        } else {
            header = sync.getSyncHdr();
            body = new SyncBody(cmds, sync.getSyncBody().isFinalMsg());
        }
        return new SyncML(header, body);
    }

    public SyncML processError(SyncML msg, Throwable error) throws Sync4jException {
        SyncHdr msgHeader = msg.getSyncHdr();
        Item[] items = new Item[]{};
        int status = 511;
        if (this.syncEngine.isDebug()) {
            items = new Item[]{new Item(null, null, null, new ComplexData(error.getMessage()), false)};
        }
        if (error instanceof ServerException) {
            status = ((ServerException)error).getStatusCode();
        }
        Status statusCommand = new Status(this.cmdIdGenerator.next(), msgHeader.getMsgID(), "0", "SyncHdr", new TargetRef(msgHeader.getTarget()), new SourceRef(msgHeader.getSource()), null, null, new Data((long)status), new Item[0]);
        String serverURI = this.syncEngine.getConfiguration().getStringValue("server.uri");
        SyncHdr syncHeader = new SyncHdr(msgHeader.getVerDTD(), msgHeader.getVerProto(), msgHeader.getSessionID(), msgHeader.getMsgID(), new Target(msgHeader.getSource().getLocURI()), new Source(serverURI), null, false, null, null);
        SyncBody syncBody = new SyncBody(new AbstractCommand[]{statusCommand}, true);
        this.moveTo(65535);
        return new SyncML(syncHeader, syncBody);
    }

    public void expire() {
        this.logout();
    }

    public void abort(int statusCode) {
        this.moveTo(65535);
    }

    public void commit() {
        assert (this.syncState.loggedPrincipal != null);
        LastTimestamp last = null;
        PersistentStore ps = this.syncEngine.getStore();
        Database[] dbsGen = this.syncEngine.getDbs();
        for (int i = 0; dbsGen != null && i < dbsGen.length; ++i) {
            if (dbsGen[i].getStatusCode() != 200) continue;
            last = new LastTimestamp(this.syncState.loggedPrincipal.getId(), dbsGen[i].getName(), dbsGen[i].getAnchor().getNext(), dbsGen[i].getServerAnchor().getNext(), this.nextTimestamp.start, this.nextTimestamp.end);
            if (log.isEnabled(Logger.Level.TRACE)) {
                log.trace((Object)("Commiting database " + dbsGen[i].getName() + " ( " + last + " )"));
            }
            try {
                boolean stored = ps.store((Object)last);
                log.trace((Object)("LastTimeStamp stored: " + stored));
                continue;
            }
            catch (Sync4jException e) {
                if (log.isEnabled(Logger.Level.FATAL)) {
                    log.fatal((Object)"Error in saving persistent data");
                }
                log.debug((Object)"commit", (Throwable)e);
            }
        }
    }

    private boolean isGuestEnabled() {
        return this.guestEnabled;
    }

    private SyncML processInitMessage(SyncML message) throws ProtocolException {
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)"Processing the given initialization message");
        }
        try {
            boolean credServerSend;
            this.syncInit = new SyncInitialization(message.getSyncHdr(), message.getSyncBody());
            this.syncState.addClientAlerts(this.syncInit.getClientAlerts());
            this.syncInit.setIdGenerator(this.cmdIdGenerator);
            this.syncInit.setFlag(3);
            this.syncInit.setServerAuthType(this.serverAuthType);
            if (this.serverAuthType.equalsIgnoreCase("syncml:auth-md5")) {
                NextNonce nonce = ProtocolUtil.generateNextNonce();
                this.syncInit.setNextNonce(nonce);
                this.syncState.device.setClientNonce(nonce.getValue());
                this.syncEngine.storeDevice(this.syncState.device);
            }
            if (this.isAuthenticated()) {
                this.syncInit.setAuthorizedStatusCode(212);
                this.syncInit.setClientCapabilitiesRequired(false);
                this.dbs = this.syncInit.getDatabasesToBeSynchronized();
                this.syncEngine.prepareDatabases(this.syncState.loggedPrincipal, this.dbs, this.nextTimestamp);
                if (log.isEnabled(Logger.Level.TRACE)) {
                    log.trace((Object)("Requested databases: " + Arrays.asList(this.dbs)));
                }
                boolean noDataSource = true;
                for (int i = 0; this.dbs != null && i < this.dbs.length; ++i) {
                    this.syncInit.setStatusCodeForCommand((AbstractCommand)this.dbs[i].getAlertCommand(), this.dbs[i].getStatusCode());
                    if (this.dbs[i].getStatusCode() != 200) continue;
                    noDataSource = false;
                    this.syncEngine.addClientSource((SyncSource)new MemorySyncSource(this.dbs[i].getName(), null, this.dbs[i].getSource().getLocURI()));
                }
                this.syncEngine.setDbs(this.dbs);
                this.syncInit.setDatabases(this.dbs);
                this.syncInit.setServerCapabilities(this.syncEngine.getServerCapabilities(this.syncInit.getDTDVersion()));
            } else if (this.isAccountExpired()) {
                this.syncInit.setAuthorizedStatusCode(402);
            } else if (this.syncState.authenticationState == 2) {
                this.syncInit.setAuthorizedStatusCode(407);
            } else if (this.syncState.authenticationState == 3) {
                this.syncInit.setAuthorizedStatusCode(401);
            } else {
                this.syncInit.setAuthorizedStatusCode(403);
            }
            Chal chal = this.getChal(message);
            boolean bl = credServerSend = !this.syncEngine.getOfficer().getAuthType().equals("none");
            if (chal == null) {
                if (!credServerSend) {
                    this.syncInit.setServerCredentials(null);
                    this.syncState.serverAuthenticationState = 4;
                } else {
                    Meta meta = new Meta();
                    meta.setType(this.serverAuthType);
                    meta.setNextNonce(new NextNonce(Base64.encode((byte[])this.syncState.device.getServerNonce())));
                    chal = new Chal(meta);
                    this.syncInit.setServerCredentials(this.syncEngine.getServerCredentials(chal, this.syncState.device));
                }
            } else {
                this.syncInit.setServerCredentials(this.syncEngine.getServerCredentials(chal, this.syncState.device));
                Cred cred = this.checkServerAuthentication(message);
                if (cred != null) {
                    this.syncInit.setServerCredentials(cred);
                }
            }
            SyncML response = this.syncInit.getResponse(this.msgIdGenerator.current());
            response = this.mergeResponse(response, null);
            if (!message.getSyncBody().isFinalMsg()) {
                response.getSyncBody().setFinalMsg(Boolean.FALSE);
            }
            SyncHdr syncHdr = response.getSyncHdr();
            SyncBody syncBody = response.getSyncBody();
            long sizeSyncHdr = 0L;
            long sizeSyncBody = 0L;
            if ("application/vnd.syncml+wbxml".equals(this.mimeType)) {
                sizeSyncHdr = SizeCalculator.getWBXMLSize((SyncHdr)syncHdr);
                sizeSyncBody = SizeCalculator.getWBXMLSize((SyncBody)syncBody);
            } else if ("application/vnd.syncml+xml".equals(this.mimeType)) {
                sizeSyncHdr = SizeCalculator.getXMLSize((SyncHdr)syncHdr);
                sizeSyncBody = SizeCalculator.getXMLSize((SyncBody)syncBody);
            }
            this.syncState.setOverheadHdr(sizeSyncHdr);
            this.maxSizeAvailable = this.syncState.getMaxMsgSize();
            this.checkMaxMsgSize(response);
            if ((this.maxSizeAvailable >= sizeSyncHdr + sizeSyncBody || this.maxSizeAvailable == 0L) && this.syncState.getStatusCmdOut().isEmpty() && this.syncState.getAlertCmdOut().isEmpty() && this.syncState.getCmdOut().isEmpty()) {
                return response;
            }
            this.cacheCommands(response);
            return this.createNextInitMsg(response);
        }
        catch (Sync4jException e) {
            throw new ProtocolException((Throwable)e);
        }
    }

    private SyncML createNextInitMsg(SyncML syncML) throws Sync4jException {
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)"Create Initialization Message");
        }
        this.checkSizeCapabilities(syncML);
        this.maxSizeAvailable = this.calculateSizeAvailable();
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)"How many Status can I include into the response?");
        }
        this.howManyStatus(this.syncState.getStatusCmdOut());
        this.syncState.removeStatusCmdOut((List)this.addStatus);
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)"Can I include server capabilities into the response?");
        }
        ArrayList<AbstractCommand> commandList = new ArrayList<AbstractCommand>();
        int size = this.addStatus.size();
        commandList.addAll(this.addStatus);
        if (this.canSendAlerts) {
            if (log.isEnabled(Logger.Level.TRACE)) {
                log.trace((Object)"How many Alert (if presents) can I include into the response?");
            }
            this.howManyAlert();
            this.syncState.removeAlertCmdOut((List)this.addAlert);
            if (log.isEnabled(Logger.Level.TRACE)) {
                log.trace((Object)"How many AbstractCommand can I include into the response?");
            }
            this.howManyAbstractCommand(true);
            this.syncState.removeCmdOut(this.addAbsCmd);
        }
        size = this.addAlert.size() + this.addAbsCmd.size();
        commandList.addAll(this.addAlert);
        commandList.addAll(this.addAbsCmd);
        AbstractCommand[] absCommands = commandList.toArray(new AbstractCommand[size]);
        SyncBody responseBody = new SyncBody(absCommands, true);
        if (!(syncML.getSyncBody().isFinalMsg() && this.syncState.getStatusCmdOut().isEmpty() && this.syncState.getAlertCmdOut().isEmpty() && this.syncState.getCmdOut().isEmpty())) {
            responseBody.setFinalMsg(Boolean.FALSE);
        }
        return new SyncML(syncML.getSyncHdr(), responseBody);
    }

    private void checkMaxMsgSize(SyncML response) {
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)"Check if the MaxMsgSize is larger of the minimal size of the messages of the server");
        }
        long minMsgSize = 0L;
        if (this.syncState.getMaxMsgSize() != 0L) {
            if ("application/vnd.syncml+wbxml".equals(this.mimeType)) {
                minMsgSize = Long.parseLong(this.syncEngine.getConfiguration().getStringValue("minWBXMLMaxMsgSize"));
            } else if ("application/vnd.syncml+xml".equals(this.mimeType)) {
                minMsgSize = Long.parseLong(this.syncEngine.getConfiguration().getStringValue("minXMLMaxMsgSize"));
            }
            if (this.syncState.getMaxMsgSize() < minMsgSize) {
                Status statusHdr = (Status)response.getSyncBody().getCommands().get(0);
                statusHdr.setData(new Data(512L));
                if (log.isEnabled(Logger.Level.INFO)) {
                    log.info((Object)"The MaxMsgSize is smaller than minimum size that the server response could have!");
                    log.info((Object)"The server will not answer to some message of the client.");
                }
            }
        }
    }

    private void checkSizeCapabilities(SyncML response) {
        ArrayList results;
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)"If server capabilities are required then check their size in order to establish if will be possible to send them");
        }
        long sizeFree = this.calculateSizeAvailable();
        Status statusGet = ProtocolUtil.filterStatus((AbstractCommand[])response.getSyncBody().getCommands().toArray(new AbstractCommand[0]), Status.class, (String)"Get");
        if (statusGet != null && (results = ProtocolUtil.filterCommands((AbstractCommand[])response.getSyncBody().getCommands().toArray(new AbstractCommand[0]), Results.class)).size() == 1) {
            long sizeCap = 0L;
            if ("application/vnd.syncml+wbxml".equals(this.mimeType)) {
                sizeCap = SizeCalculator.getWBXMLSize((Results)((Results)results.get(0)));
            } else if ("application/vnd.syncml+xml".equals(this.mimeType)) {
                sizeCap = SizeCalculator.getXMLSize((Results)((Results)results.get(0)));
            }
            if (sizeFree < sizeCap) {
                if (log.isEnabled(Logger.Level.INFO)) {
                    log.info((Object)"Will not be NEVER possible to send the server capabilities!");
                    log.info((Object)"This command will be removed from the list of the commands to send to the client");
                }
                statusGet.setData(new Data(413L));
                this.syncState.removeCmdOut((List)results);
                this.canSendAlerts = false;
            } else {
                this.canSendAlerts = true;
            }
        }
    }

    private long calculateSizeAvailable() {
        long overhead = 0L;
        if ("application/vnd.syncml+wbxml".equals(this.mimeType)) {
            overhead += SizeCalculator.getWBXMLOverheadSyncML() + SizeCalculator.getWBXMLOverheadSyncBody();
        } else if ("application/vnd.syncml+xml".equals(this.mimeType)) {
            overhead += SizeCalculator.getXMLOverheadSyncML() + SizeCalculator.getXMLOverheadSyncBody();
        }
        return this.syncState.getMaxMsgSize() - overhead - this.syncState.getOverheadHdr() - this.syncState.getSizeStatusSyncHdr();
    }

    private Chal getChal(SyncML msg) {
        Chal chal = ProtocolUtil.getStatusChal((SyncML)msg);
        if (chal != null && log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)("Challenged server authentication with scheme " + chal.getType()));
        }
        return chal;
    }

    private Cred checkServerAuthentication(SyncML msg) throws ProtocolException {
        int headerStatusCode = ProtocolUtil.getHeaderStatusCode((SyncML)msg);
        if (headerStatusCode == -1 || headerStatusCode == 200) {
            return null;
        }
        if (headerStatusCode == 401 || headerStatusCode != 212) {
            if (this.serverAuthType.equalsIgnoreCase("syncml:auth-md5") && this.syncState.serverAuthenticationState == 1) {
                this.syncState.serverAuthenticationState = 32;
                return this.syncEngine.getServerCredentials(this.getChal(msg), this.syncState.device);
            }
            throw new ProtocolException("Unable to authenticate to the client");
        }
        this.syncState.serverAuthenticationState = 4;
        return null;
    }

    private SyncML processSyncMessage(SyncML syncRequest) throws ProtocolException {
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)"Processing the given synchronization message");
            log.trace((Object)("client sources: " + this.syncEngine.getClientSources()));
        }
        try {
            this.modifications = new ClientModifications(syncRequest.getSyncHdr(), syncRequest.getSyncBody(), this.syncEngine.getDbs());
            Sync[] syncCommands = this.modifications.getClientSyncCommands();
            if (syncCommands == null || syncCommands.length == 0) {
                throw new ProtocolException("Sync command expected in this package but no Sync commands were found");
            }
            List responseCommands = this.processModifications(this.modifications);
            if (log.isEnabled(Logger.Level.TRACE)) {
                log.trace((Object)("responseCommands: " + responseCommands));
            }
            this.modifications.setIdGenerator(this.cmdIdGenerator);
            this.modifications.setFlag(-2);
            Object[] statusSyncs = ProtocolUtil.filterCommands((List)responseCommands, (String[])new String[]{Status.COMMAND_NAME}).toArray(new Status[0]);
            Object[] statusMaps = this.syncState.getMapStatusOut().toArray(new Status[0]);
            if (statusMaps != null && statusMaps.length > 0) {
                this.syncState.removeMapStatusOut(Arrays.asList(statusMaps));
                statusSyncs = (Status[])ArrayUtils.mergeArrays((Object[])statusSyncs, (Object[])statusMaps, Status.class);
            }
            this.modifications.setClientModificationsStatus((Status[])statusSyncs);
            Object[] serverModifications = ProtocolUtil.filterCommands((List)responseCommands, (String[])new String[]{Sync.COMMAND_NAME}).toArray(new AbstractCommand[0]);
            this.syncState.setServerModifications((AbstractCommand[])serverModifications);
            if (syncRequest.getSyncBody().isFinalMsg()) {
                this.modifications.setServerModifications(this.syncState.getServerModifications());
                this.modifications.setFlag(3);
            } else {
                List<Object> listCmd = Arrays.asList(ProtocolUtil.sortAbstractCommand((Object[])serverModifications));
                this.syncState.addCmdOut(new LinkedList<Object>(listCmd));
            }
            SyncML response = this.modifications.getResponse(this.msgIdGenerator.current());
            response = this.syncState.isSyncWithInit() ? this.mergeResponse(this.syncState.getResponseInit(), response) : this.mergeResponse(null, response);
            SyncHdr syncHdr = response.getSyncHdr();
            SyncBody syncBody = response.getSyncBody();
            long sizeSyncHdr = 0L;
            long sizeSyncBody = 0L;
            if ("application/vnd.syncml+wbxml".equals(this.mimeType)) {
                sizeSyncHdr = SizeCalculator.getWBXMLSize((SyncHdr)syncHdr);
                sizeSyncBody = SizeCalculator.getWBXMLSize((SyncBody)syncBody);
            } else if ("application/vnd.syncml+xml".equals(this.mimeType)) {
                sizeSyncHdr = SizeCalculator.getXMLSize((SyncHdr)syncHdr);
                sizeSyncBody = SizeCalculator.getXMLSize((SyncBody)syncBody);
            }
            this.syncState.setOverheadHdr(sizeSyncHdr);
            this.maxSizeAvailable = this.syncState.getMaxMsgSize();
            if ((this.maxSizeAvailable >= sizeSyncHdr + sizeSyncBody || this.maxSizeAvailable == 0L) && this.syncState.getStatusCmdOut().isEmpty() && this.syncState.getAlertCmdOut().isEmpty() && this.syncState.getCmdOut().isEmpty()) {
                return response;
            }
            this.cacheCommands(response);
            if (log.isEnabled(Logger.Level.TRACE)) {
                log.trace((Object)"Cache Status and AbstractCommand to send in the next msg");
            }
            this.maxSizeAvailable = this.calculateSizeAvailable();
            if (log.isEnabled(Logger.Level.TRACE)) {
                log.trace((Object)"How many Status can I include into the response?");
            }
            this.howManyStatus(this.syncState.getStatusCmdOut());
            this.modifications.setClientModificationsStatus(this.addStatus.toArray(new Status[0]));
            this.syncState.removeStatusCmdOut((List)this.addStatus);
            if (log.isEnabled(Logger.Level.TRACE)) {
                log.trace((Object)"How many Alert (if presents) can I include into the response?");
            }
            this.howManyAlert();
            this.modifications.setModificationsAlert(this.addAlert.toArray(new Alert[0]));
            this.syncState.removeAlertCmdOut((List)this.addAlert);
            if (log.isEnabled(Logger.Level.TRACE)) {
                log.trace((Object)"How many AbstractCommand can I include into the response?");
            }
            this.howManyAbstractCommand(false);
            this.syncState.removeCmdOut(this.addAbsCmd);
            if (log.isEnabled(Logger.Level.TRACE)) {
                log.trace((Object)"Add server modifications to response");
            }
            this.modifications.setServerModifications(this.addAbsCmd.toArray(new AbstractCommand[0]));
            if (syncRequest.getSyncBody().isFinalMsg() && this.syncState.getStatusCmdOut().isEmpty() && this.syncState.getAlertCmdOut().isEmpty()) {
                this.howManyAbstractCommand(true);
                this.modifications.setServerModifications(this.addAbsCmd.toArray(new AbstractCommand[0]));
                this.syncState.removeCmdOut(this.addAbsCmd);
                if (this.syncState.getCmdOut().isEmpty()) {
                    this.modifications.setFlag(3);
                } else {
                    this.modifications.setFlagValue(3, false);
                }
            } else if (ProtocolUtil.noMoreResponse((SyncML)syncRequest)) {
                this.howManyAbstractCommand(true);
                this.modifications.setServerModifications(this.addAbsCmd.toArray(new AbstractCommand[0]));
                this.syncState.removeCmdOut(this.addAbsCmd);
                this.modifications.setFlagValue(3, true);
            } else if (this.addAbsCmd != null) {
                for (int i = 0; i < this.addAbsCmd.size(); ++i) {
                    AbstractCommand ac = this.addAbsCmd.get(i);
                    if (ac instanceof Results || ac instanceof Get) {
                        this.modifications.setFlagValue(3, true);
                        this.syncState.removeCmdOut(this.addAbsCmd);
                        break;
                    }
                    this.modifications.setFlagValue(3, false);
                }
            } else {
                this.modifications.setFlagValue(3, false);
            }
            return this.modifications.getResponse(this.msgIdGenerator.current());
        }
        catch (Sync4jException e) {
            this.checkAlertNextMessage(syncRequest);
            try {
                return this.createNextSyncMsg(syncRequest);
            }
            catch (Sync4jException ex) {
                throw new ProtocolException((Throwable)ex);
            }
        }
    }

    private void checkAlertNextMessage(SyncML request) {
        ArrayList commands = request.getSyncBody().getCommands();
        ArrayList alerts = ProtocolUtil.filterCommands((AbstractCommand[])commands.toArray(new AbstractCommand[0]), Alert.class);
        for (int i = 0; alerts != null && i < alerts.size(); ++i) {
            Alert alert = (Alert)alerts.get(i);
            if (alert.getData() != 222) continue;
            if (log.isEnabled(Logger.Level.TRACE)) {
                log.trace((Object)"Received Alert with code NEXT_MESSAGE");
            }
            Status statusAlert = new Status(this.cmdIdGenerator.next(), request.getSyncHdr().getMsgID(), alert.getCmdID().getCmdID(), "Alert", (TargetRef[])null, (SourceRef[])null, null, null, new Data(200L), null);
            this.addStatus = new ArrayList();
            this.addStatus.add(statusAlert);
            this.syncState.addStatusCmdOut(new LinkedList(this.addStatus));
            break;
        }
    }

    private SyncML createNextSyncMsg(SyncML syncML) throws Sync4jException {
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)"Create Synchronization Message");
        }
        this.maxSizeAvailable = this.calculateSizeAvailable();
        Object[] allStatus = this.syncState.getStatusCmdOut().toArray(new Status[0]);
        Object[] statusMaps = this.syncState.getMapStatusOut().toArray(new Status[0]);
        if (statusMaps != null) {
            this.syncState.removeMapStatusOut(Arrays.asList(statusMaps));
            allStatus = (Status[])ArrayUtils.mergeArrays((Object[])allStatus, (Object[])statusMaps, Status.class);
        }
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)"How many Status can I include into the response?");
        }
        this.howManyStatus(Arrays.asList(allStatus));
        this.syncState.removeStatusCmdOut((List)this.addStatus);
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)"How many Alert (if presents) can I include into the response?");
        }
        this.howManyAlert();
        this.syncState.removeAlertCmdOut((List)this.addAlert);
        this.modifications = new ClientModifications(syncML.getSyncHdr(), syncML.getSyncBody());
        this.modifications.setIdGenerator(this.cmdIdGenerator);
        this.modifications.setFlag(-2);
        this.modifications.setClientModificationsStatus(ProtocolUtil.filterCommands((List)this.addStatus, (String[])new String[]{Status.COMMAND_NAME}).toArray(new Status[0]));
        this.modifications.setModificationsAlert(ProtocolUtil.filterCommands((List)this.addAlert, (String[])new String[]{"Alert"}).toArray(new Alert[0]));
        if (this.syncState.getStatusCmdOut().isEmpty() && this.syncState.getAlertCmdOut().isEmpty()) {
            if (log.isEnabled(Logger.Level.TRACE)) {
                log.trace((Object)"How many AbstractCommand can I include into the response?");
            }
            this.howManyAbstractCommand(true);
            if (log.isEnabled(Logger.Level.TRACE)) {
                log.trace((Object)"Add server modifications to response");
            }
            this.modifications.setServerModifications(this.addAbsCmd.toArray(new AbstractCommand[0]));
            this.syncState.removeCmdOut(this.addAbsCmd);
            if (this.syncState.getCmdOut().isEmpty()) {
                this.modifications.setFlag(3);
            }
        } else {
            this.modifications.setServerModifications(null);
            this.modifications.setFlagValue(3, false);
        }
        return this.modifications.getResponse(this.msgIdGenerator.current());
    }

    private void cacheCommands(SyncML response) {
        List statusCmdOut = ProtocolUtil.filterCommands((List)response.getSyncBody().getCommands(), (String[])new String[]{Status.COMMAND_NAME});
        List<Object> listStatus = Arrays.asList(ProtocolUtil.sortStatusCommand((Object[])statusCmdOut.toArray(new Status[0])));
        this.syncState.addStatusCmdOut(new LinkedList<Object>(listStatus));
        Status statusSyncHdr = ProtocolUtil.filterStatus((AbstractCommand[])listStatus.toArray(new Status[0]), Status.class, (String)"SyncHdr");
        if ("application/vnd.syncml+wbxml".equals(this.mimeType)) {
            this.syncState.setSizeStatusSyncHdr(SizeCalculator.getWBXMLSize((Status)statusSyncHdr));
        } else if ("application/vnd.syncml+xml".equals(this.mimeType)) {
            this.syncState.setSizeStatusSyncHdr(SizeCalculator.getXMLSize((Status)statusSyncHdr));
        }
        this.syncState.setStatusSyncHdr(statusSyncHdr);
        ArrayList<Status> removeStatus = new ArrayList<Status>();
        removeStatus.add(statusSyncHdr);
        this.syncState.removeStatusCmdOut(removeStatus);
        List cmdOut = ProtocolUtil.filterCommands((List)response.getSyncBody().getCommands(), (String[])new String[]{"Results", "Get", Sync.COMMAND_NAME});
        List<Object> listCmd = Arrays.asList(ProtocolUtil.sortAbstractCommand((Object[])cmdOut.toArray(new AbstractCommand[0])));
        this.syncState.addCmdOut(new LinkedList<Object>(listCmd));
        List listAlert = ProtocolUtil.filterCommands((List)response.getSyncBody().getCommands(), (String[])new String[]{"Alert"});
        this.syncState.addAlertCmdOut(new LinkedList(listAlert));
    }

    private void cacheMapCommands(SyncML response) {
        List mapStatusOut = ProtocolUtil.filterCommands((List)response.getSyncBody().getCommands(), (String[])new String[]{Status.COMMAND_NAME});
        List<Object> listStatus = Arrays.asList(ProtocolUtil.sortStatusCommand((Object[])mapStatusOut.toArray(new Status[0])));
        this.syncState.addMapStatusOut(new LinkedList<Object>(listStatus));
        Status statusSyncHdr = ProtocolUtil.filterStatus((AbstractCommand[])listStatus.toArray(new Status[0]), Status.class, (String)"SyncHdr");
        if ("application/vnd.syncml+wbxml".equals(this.mimeType)) {
            this.syncState.setSizeStatusSyncHdr(SizeCalculator.getWBXMLSize((Status)statusSyncHdr));
        } else if ("application/vnd.syncml+xml".equals(this.mimeType)) {
            this.syncState.setSizeStatusSyncHdr(SizeCalculator.getXMLSize((Status)statusSyncHdr));
        }
        this.syncState.setStatusSyncHdr(statusSyncHdr);
        ArrayList<Status> removeStatus = new ArrayList<Status>();
        removeStatus.add(statusSyncHdr);
        this.syncState.removeMapStatusOut(removeStatus);
    }

    private void howManyStatus(List allStatus) {
        this.addStatus = new ArrayList();
        if (this.currentState != 18) {
            this.addStatus.add(this.syncState.getStatusSyncHdr());
        }
        int x = 0;
        for (int i = 0; allStatus != null && i < allStatus.size(); ++i) {
            Status status = (Status)allStatus.get(i);
            long size = 0L;
            if ("application/vnd.syncml+wbxml".equals(this.mimeType)) {
                size = SizeCalculator.getWBXMLSize((Status)status);
            } else if ("application/vnd.syncml+xml".equals(this.mimeType)) {
                size = SizeCalculator.getXMLSize((Status)status);
            }
            if (this.maxSizeAvailable - size < 0L) break;
            this.addStatus.add((Status)allStatus.get(i));
            this.maxSizeAvailable -= size;
            ++x;
        }
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)("Number of Status inserted: " + x));
        }
    }

    private void howManyAlert() {
        this.addAlert = new ArrayList();
        int x = 0;
        LinkedList allAlert = this.syncState.getAlertCmdOut();
        if (this.maxSizeAvailable > 0L && this.syncState.getStatusCmdOut().isEmpty()) {
            for (int i = 0; allAlert != null && i < allAlert.size(); ++i) {
                Alert alert = (Alert)allAlert.get(i);
                long size = 0L;
                if ("application/vnd.syncml+wbxml".equals(this.mimeType)) {
                    size = SizeCalculator.getWBXMLSize((Alert)alert);
                } else if ("application/vnd.syncml+xml".equals(this.mimeType)) {
                    size = SizeCalculator.getXMLSize((Alert)alert);
                }
                if (this.maxSizeAvailable - size < 0L) break;
                this.addAlert.add((Alert)allAlert.get(i));
                this.maxSizeAvailable -= size;
                ++x;
            }
        }
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)("Number of Alert inserted: " + x));
        }
    }

    private void howManyAbstractCommand(boolean checkSyncCmd) {
        this.addAbsCmd = new ArrayList();
        int x = 0;
        long sizeSync = 0L;
        long size = 0L;
        Sync syncCopy = null;
        LinkedList allCmd = this.syncState.getCmdOut();
        if (this.maxSizeAvailable > 0L && this.syncState.getStatusCmdOut().isEmpty() && this.syncState.getAlertCmdOut().isEmpty()) {
            AbstractCommand cmd;
            ArrayList results = new ArrayList(ProtocolUtil.filterCommands((List)allCmd, (String[])new String[]{"Results", "Get"}));
            if (results != null && results.size() > 0) {
                for (int y = 0; y < results.size(); ++y) {
                    cmd = (AbstractCommand)results.get(y);
                    if ("application/vnd.syncml+wbxml".equals(this.mimeType)) {
                        size = SizeCalculator.getCommandWBXMLSize((AbstractCommand)cmd);
                    } else if ("application/vnd.syncml+xml".equals(this.mimeType)) {
                        size = SizeCalculator.getCommandXMLSize((AbstractCommand)cmd);
                    }
                    if (this.checkSizeCommands(cmd, size) == -1) {
                        allCmd.remove(cmd);
                        continue;
                    }
                    if (this.maxSizeAvailable - size < 0L) continue;
                    this.addAbsCmd.add(cmd);
                    this.maxSizeAvailable -= size;
                    ++x;
                    results.remove(cmd);
                }
            }
            if (results != null && results.isEmpty()) {
                for (int i = 0; allCmd != null && i < allCmd.size(); ++i) {
                    size = 0L;
                    cmd = (AbstractCommand)allCmd.get(i);
                    if (cmd instanceof Sync && checkSyncCmd) {
                        sizeSync = 0L;
                        Sync sync = (Sync)cmd;
                        syncCopy = new Sync(sync.getCmdID(), sync.isNoResp(), sync.getCred(), sync.getTarget(), sync.getSource(), sync.getMeta(), sync.getNumberOfChanges(), new AbstractCommand[0]);
                        if ("application/vnd.syncml+wbxml".equals(this.mimeType)) {
                            sizeSync = SizeCalculator.getWBXMLSize((Sync)syncCopy);
                        } else if ("application/vnd.syncml+xml".equals(this.mimeType)) {
                            sizeSync = SizeCalculator.getXMLSize((Sync)syncCopy);
                        }
                        if (this.maxSizeAvailable - sizeSync < 0L) break;
                        this.maxSizeAvailable -= sizeSync;
                        ArrayList<AbstractCommand> cmdAddCopy = new ArrayList<AbstractCommand>();
                        if (sync.getCommands() != null) {
                            AbstractCommand[] ac = sync.getCommands().toArray(new AbstractCommand[0]);
                            for (int y = 0; ac != null && y < ac.length; ++y) {
                                if ("application/vnd.syncml+wbxml".equals(this.mimeType)) {
                                    size = SizeCalculator.getCommandWBXMLSize((AbstractCommand)ac[y]);
                                } else if ("application/vnd.syncml+xml".equals(this.mimeType)) {
                                    size = SizeCalculator.getCommandXMLSize((AbstractCommand)ac[y]);
                                }
                                if (this.checkSizeCommands(ac[y], sizeSync + size) == -1) {
                                    sync.getCommands().remove(ac[y]);
                                    continue;
                                }
                                if (this.maxSizeAvailable - size < 0L) break;
                                this.maxSizeAvailable -= size;
                                ++x;
                                cmdAddCopy.add(ac[y]);
                            }
                        }
                        syncCopy.setCommands(cmdAddCopy.toArray(new AbstractCommand[0]));
                        sync.getCommands().removeAll(cmdAddCopy);
                        int index = this.syncState.getCmdOut().indexOf(cmd);
                        this.syncState.getCmdOut().remove(cmd);
                        this.addAbsCmd.add((AbstractCommand)syncCopy);
                        if (sync.getCommands().isEmpty()) break;
                        this.syncState.getCmdOut().add(index, sync);
                        break;
                    }
                    if (cmd instanceof Results || cmd instanceof Get) {
                        allCmd.remove(i);
                        break;
                    }
                    if (cmd instanceof Sync) break;
                    if ("application/vnd.syncml+wbxml".equals(this.mimeType)) {
                        size = SizeCalculator.getCommandWBXMLSize((AbstractCommand)cmd);
                    } else if ("application/vnd.syncml+xml".equals(this.mimeType)) {
                        size = SizeCalculator.getCommandXMLSize((AbstractCommand)cmd);
                    }
                    if (this.checkSizeCommands(cmd, size) == -1) {
                        allCmd.remove(i);
                        continue;
                    }
                    if (this.maxSizeAvailable - size < 0L) break;
                    this.addAbsCmd.add((AbstractCommand)allCmd.get(i));
                    this.maxSizeAvailable -= size;
                    ++x;
                }
            }
        }
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)("Number of AbstractCommand inserted: " + x));
        }
    }

    private int checkSizeCommands(AbstractCommand cmd, long size) {
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)"Check the command size");
        }
        long sizeFree = this.calculateSizeAvailable();
        if (size == 0L) {
            if ("application/vnd.syncml+wbxml".equals(this.mimeType)) {
                size = SizeCalculator.getWBXMLSize((AbstractCommand)cmd);
            } else if ("application/vnd.syncml+xml".equals(this.mimeType)) {
                size = SizeCalculator.getXMLSize((AbstractCommand)cmd);
            }
        }
        if (sizeFree < size) {
            if (log.isEnabled(Logger.Level.INFO)) {
                log.info((Object)"Will not be NEVER possible to send this command!");
                log.info((Object)("The " + cmd + " will be removed from the " + "list of the commands to send to the client"));
            }
            return -1;
        }
        return 0;
    }

    private List processModifications(ClientModifications modifications) throws Sync4jException {
        SyncHdr header = modifications.getSyncHeader();
        String msgId = header.getMsgID();
        boolean headerNoResponse = header.isNoResp();
        ArrayList<Object> responseCommands = new ArrayList<Object>();
        this.syncEngine.setCommandIdGenerator(this.cmdIdGenerator);
        Sync[] syncCommands = modifications.getClientSyncCommands();
        this.getClientMappings();
        Status[] statusCommands = ProtocolUtil.filterCommands((AbstractCommand[])modifications.getClientCommands(), Status.class).toArray(new Status[0]);
        this.prepareMemorySources(syncCommands, statusCommands);
        this.syncEngine.setClientMappings(this.clientMappings);
        try {
            this.syncEngine.sync(this.syncState.loggedPrincipal);
        }
        catch (Sync4jException e) {
            log.debug((Object)"processModifications", (Throwable)e);
        }
        if (!headerNoResponse) {
            responseCommands.addAll(this.statusForSyncs(syncCommands));
            Status[] operationStatus = this.syncEngine.getModificationsStatusCommands(msgId);
            for (int i = 0; i < operationStatus.length; ++i) {
                responseCommands.add(operationStatus[i]);
            }
        }
        Alert[] alertCommands = this.syncState.getClientAlerts();
        Item[] alertItems = null;
        ItemizedCommand[] commands = null;
        String uri = null;
        for (int k = 0; alertCommands != null && k < alertCommands.length; ++k) {
            if (AlertCode.isClientOnlyCode((int)alertCommands[k].getData())) continue;
            alertItems = alertCommands[k].getItems().toArray(new Item[0]);
            for (int i = 0; alertItems != null && i < alertItems.length; ++i) {
                uri = alertItems[i].getTarget().getLocURI();
                for (int s = 0; syncCommands != null && s < syncCommands.length; ++s) {
                    if (syncCommands[s].getTarget() != null && !uri.equals(syncCommands[s].getTarget().getLocURI())) continue;
                    for (int j = 0; this.syncEngine.getDbs() != null && j < this.syncEngine.getDbs().length; ++j) {
                        if (!this.syncEngine.getDbs()[j].getName().equals(uri)) continue;
                        SyncOperation[] operations = this.syncEngine.getSyncOperations(uri);
                        commands = this.syncEngine.operationsToCommands(this.clientMappings.get(uri), operations, uri);
                        responseCommands.add(new Sync(this.cmdIdGenerator.next(), false, null, ProtocolUtil.source2Target((Source)alertItems[i].getSource()), ProtocolUtil.target2Source((Target)alertItems[i].getTarget()), null, 0, (AbstractCommand[])commands));
                        this.syncEngine.updateClientMappings(this.clientMappings, operations, this.slow);
                        this.syncState.removeClientAlert(alertCommands[k]);
                    }
                }
            }
        }
        this.syncEngine.updateServerMappings(this.clientMappings, this.slow);
        return responseCommands;
    }

    private SyncML processCompletionMessage(SyncML message) throws ProtocolException {
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)"Processing completion message");
        }
        SyncML response = null;
        try {
            ClientCompletion clientCompletion = new ClientCompletion(message.getSyncHdr(), message.getSyncBody());
            clientCompletion.setIdGenerator(this.cmdIdGenerator);
            if (message.getSyncBody().isFinalMsg()) {
                clientCompletion.setFlag(3);
            }
            if (clientCompletion.isMapCommandFind()) {
                String uri = null;
                ClientMapping mapping = null;
                Map[] mapCommands = clientCompletion.getMapCommands();
                MapItem[] mapItems = null;
                for (int j = 0; mapCommands != null && j < mapCommands.length; ++j) {
                    uri = mapCommands[j].getTarget().getLocURI();
                    mapItems = mapCommands[j].getMapItems().toArray(new MapItem[0]);
                    mapping = this.clientMappings.get(uri);
                    if (mapping == null) {
                        mapping = new ClientMapping(this.syncState.loggedPrincipal, uri);
                        this.clientMappings.put(uri, mapping);
                    }
                    for (int i = 0; i < mapItems.length; ++i) {
                        MapItem mapItem = mapItems[i];
                        String GUID = mapItem.getTarget().getLocURI();
                        String LUID = mapItem.getSource().getLocURI();
                        mapping.updateMapping(LUID, GUID);
                    }
                }
            }
            response = clientCompletion.getResponse(this.msgIdGenerator.current());
            response = this.mergeResponse(null, response);
            if (this.currentState != 20) {
                this.cacheMapCommands(response);
                return null;
            }
            SyncHdr syncHdr = response.getSyncHdr();
            SyncBody syncBody = response.getSyncBody();
            long sizeSyncHdr = 0L;
            long sizeSyncBody = 0L;
            if ("application/vnd.syncml+wbxml".equals(this.mimeType)) {
                sizeSyncHdr = SizeCalculator.getWBXMLSize((SyncHdr)syncHdr);
                sizeSyncBody = SizeCalculator.getWBXMLSize((SyncBody)syncBody);
            } else if ("application/vnd.syncml+xml".equals(this.mimeType)) {
                sizeSyncHdr = SizeCalculator.getXMLSize((SyncHdr)syncHdr);
                sizeSyncBody = SizeCalculator.getXMLSize((SyncBody)syncBody);
            }
            this.syncState.setOverheadHdr(sizeSyncHdr);
            this.maxSizeAvailable = this.syncState.getMaxMsgSize();
            if ((this.maxSizeAvailable >= sizeSyncHdr + sizeSyncBody || this.maxSizeAvailable == 0L) && this.syncState.getMapStatusOut().isEmpty()) {
                return response;
            }
            this.cacheMapCommands(response);
            this.maxSizeAvailable = this.calculateSizeAvailable();
            if (log.isEnabled(Logger.Level.TRACE)) {
                log.trace((Object)"How many Status can I include into the response?");
            }
            this.howManyStatus(this.syncState.getMapStatusOut());
            SyncBody body = new SyncBody(this.addStatus.toArray(new AbstractCommand[0]), false);
            this.syncState.removeMapStatusOut((List)this.addStatus);
            if (message.getSyncBody().isFinalMsg() && this.syncState.getMapStatusOut().isEmpty()) {
                body.setFinalMsg(Boolean.TRUE);
            }
            return new SyncML(syncHdr, body);
        }
        catch (Sync4jException e) {
            if (log.isEnabled(Logger.Level.FATAL)) {
                log.fatal((Object)"Error in process completion");
            }
            throw new ProtocolException((Throwable)e);
        }
    }

    private void moveTo(int state) {
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)("moving to state " + this.getStateName(state)));
        }
        this.currentState = state;
    }

    private void prepareMemorySources(Sync[] syncCommands, Status[] statusCommands) {
        List<SyncSource> sources = this.syncEngine.getClientSources();
        HashMap<String, Database> dbMap = new HashMap<String, Database>();
        for (int i = 0; this.syncEngine.getDbs() != null && i < this.syncEngine.getDbs().length; ++i) {
            dbMap.put(this.syncEngine.getDbs()[i].getName(), this.syncEngine.getDbs()[i]);
        }
        this.slow = false;
        Target target = null;
        MemorySyncSource mss = null;
        AbstractCommand[] modifications = null;
        for (int i = sources.size(); i > 0; --i) {
            int method;
            if (log.isEnabled(Logger.Level.TRACE)) {
                log.trace((Object)("Preparing " + this.syncEngine.getClientSources().get(i - 1) + " with " + Arrays.asList(syncCommands)));
            }
            mss = (MemorySyncSource)sources.get(i - 1);
            String uri = mss.getSourceURI();
            modifications = new AbstractCommand[]{};
            for (int j = 0; syncCommands != null && j < syncCommands.length; ++j) {
                target = syncCommands[j].getTarget();
                if (target == null || !uri.equals(target.getLocURI())) continue;
                if (syncCommands[j].getCommands() == null) break;
                modifications = syncCommands[j].getCommands().toArray(new AbstractCommand[0]);
                break;
            }
            boolean bl = this.slow = (method = ((Database)dbMap.get(uri)).getMethod()) == 201 || method == 205;
            if (!this.slow) {
                String targetRef = null;
                String statusCode = null;
                for (int k = 0; statusCommands != null && k < statusCommands.length; ++k) {
                    targetRef = ((TargetRef)statusCommands[k].getTargetRef().get(0)).getValue();
                    if (targetRef == null || !uri.equals(targetRef)) continue;
                    statusCode = statusCommands[k].getData().getData();
                    if (!statusCode.equals("508")) break;
                    this.slow = true;
                    ((Database)dbMap.get(uri)).setStatusCode(508);
                    break;
                }
            }
            this.prepareMemorySource(mss, modifications, this.slow);
        }
    }

    private void prepareMemorySource(MemorySyncSource source, AbstractCommand[] commands, boolean slowSync) {
        ArrayList<Object> existing = new ArrayList<Object>();
        ArrayList<SyncItem> deleted = new ArrayList<SyncItem>();
        ArrayList<SyncItem> created = new ArrayList<SyncItem>();
        ArrayList<SyncItem> updated = new ArrayList<SyncItem>();
        ClientMapping guidluid = null;
        guidluid = this.clientMappings.get(source.getSourceURI());
        if (slowSync) {
            if (guidluid != null && this.finalMsg) {
                guidluid.clearMappings();
            }
        } else if (guidluid != null) {
            java.util.Map map = guidluid.getMapping();
            Iterator i = map.keySet().iterator();
            while (i.hasNext()) {
                existing.add(new SyncItemImpl((SyncSource)source, map.get(i.next()), 'S'));
            }
        }
        String name = null;
        for (int i = 0; commands != null && i < commands.length; ++i) {
            name = commands[i].getName();
            if (slowSync && !"Delete".equals(name)) {
                existing.addAll(Arrays.asList(Sync4jSyncEngine.itemsToSyncItems(this.clientMappings.get(source.getSourceURI()), (SyncSource)source, (ModificationCommand)commands[i], 'S', this.nextTimestamp.start)));
                continue;
            }
            if ("Add".equals(commands[i].getName())) {
                created.addAll(Arrays.asList(Sync4jSyncEngine.itemsToSyncItems(this.clientMappings.get(source.getSourceURI()), (SyncSource)source, (ModificationCommand)commands[i], 'N', this.nextTimestamp.start)));
                continue;
            }
            if ("Delete".equals(commands[i].getName())) {
                deleted.addAll(Arrays.asList(Sync4jSyncEngine.itemsToSyncItems(this.clientMappings.get(source.getSourceURI()), (SyncSource)source, (ModificationCommand)commands[i], 'D', this.nextTimestamp.start)));
                continue;
            }
            if (!"Replace".equals(commands[i].getName())) continue;
            updated.addAll(Arrays.asList(Sync4jSyncEngine.itemsToSyncItems(this.clientMappings.get(source.getSourceURI()), (SyncSource)source, (ModificationCommand)commands[i], 'U', this.nextTimestamp.start)));
        }
        source.initialize(existing, deleted, created, updated);
    }

    private List statusForSyncs(Sync[] syncCommands) {
        ArrayList<Status> ret = new ArrayList<Status>();
        String uri = null;
        Target target = null;
        Source source = null;
        TargetRef targetRef = null;
        SourceRef sourceRef = null;
        int statusCode = 200;
        for (int i = 0; syncCommands != null && i < syncCommands.length; ++i) {
            target = syncCommands[i].getTarget();
            source = syncCommands[i].getSource();
            uri = target == null ? null : target.getLocURI();
            statusCode = uri == null || this.syncEngine.getClientSource(uri) != null ? 200 : 404;
            targetRef = target == null ? null : new TargetRef(uri);
            sourceRef = source == null ? null : new SourceRef(syncCommands[i].getSource());
            Sync cfr_ignored_0 = syncCommands[i];
            ret.add(new Status(this.cmdIdGenerator.next(), this.lastMsgIdFromClient, syncCommands[i].getCmdID().getCmdID(), Sync.COMMAND_NAME, targetRef, sourceRef, null, null, new Data((long)statusCode), new Item[0]));
        }
        return ret;
    }

    private boolean login(Cred credential, String deviceId) {
        this.logout();
        if (credential == null) {
            if (this.syncEngine.isGuestEnabled()) {
                credential = Cred.getGuestCredential();
            } else {
                this.syncState.authenticationState = 2;
                return false;
            }
        }
        Sync4jPrincipal p = Sync4jPrincipal.fromCredential((String)credential.getData(), (String)credential.getType(), (String)deviceId);
        if (this.serverAuthType.equalsIgnoreCase("syncml:auth-md5")) {
            NextNonce nn = new NextNonce(this.syncState.device.getClientNonce());
            Authentication auth = credential.getAuthentication();
            auth.setNextNonce(nn);
            auth.setDeviceId(deviceId);
            auth.setSyncMLVerProto(this.syncState.syncMLVerProto);
        }
        if (this.syncEngine.login(credential)) {
            if (this.serverAuthType.equalsIgnoreCase("syncml:auth-md5")) {
                p.setUsername(credential.getAuthentication().getUsername());
            }
            if (this.syncEngine.authorize((Principal)p, "funambol.session")) {
                this.syncState.loggedCredential = credential;
                this.syncState.loggedPrincipal = p;
                this.syncState.authenticationState = 4;
                return true;
            }
        }
        return false;
    }

    private void logout() {
        if (this.isAuthenticated()) {
            this.syncEngine.logout(this.syncState.loggedCredential);
        }
        this.syncState.authenticationState = 3;
        this.syncState.loggedCredential = null;
        this.syncState.loggedPrincipal = null;
    }

    public void endSession() {
        this.commit();
        this.logout();
    }

    private boolean checkSyncInit(SyncML message) throws ProtocolException {
        AbstractCommand[] clientCommands = message.getSyncBody().getCommands().toArray(new AbstractCommand[0]);
        ArrayList syncs = ProtocolUtil.filterCommands((AbstractCommand[])clientCommands, Sync.class);
        ArrayList alerts = ProtocolUtil.filterCommands((AbstractCommand[])clientCommands, Alert.class);
        return !syncs.isEmpty() && !alerts.isEmpty();
    }

    private void resetClientMappings() {
        this.clientMappings = new HashMap<String, ClientMapping>();
    }

    private void getClientMappings() throws Sync4jException {
        this.resetClientMappings();
        ClientMapping clientMapping = null;
        String uri = null;
        try {
            PersistentStore ps = this.syncEngine.getStore();
            for (int i = 0; this.syncEngine.getDbs() != null && i < this.syncEngine.getDbs().length; ++i) {
                uri = this.syncEngine.getDbs()[i].getName();
                clientMapping = new ClientMapping(this.syncState.loggedPrincipal, uri);
                ps.read((Object)clientMapping);
                this.clientMappings.put(uri, clientMapping);
            }
        }
        catch (PersistentStoreException e) {
            if (log.isEnabled(Logger.Level.FATAL)) {
                log.fatal((Object)"Unable to read clientMappings from the persistent store");
            }
            throw new Sync4jException((Throwable)e);
        }
    }

    private void storeClientMappings() throws Sync4jException {
        if (this.clientMappings == null) {
            return;
        }
        try {
            PersistentStore ps = this.syncEngine.getStore();
            ClientMapping cm = null;
            Iterator<String> i = this.clientMappings.keySet().iterator();
            while (i.hasNext()) {
                cm = this.clientMappings.get(i.next());
                if (log.isEnabled(Logger.Level.TRACE)) {
                    log.trace((Object)("Saving client mapping: " + cm));
                }
                ps.store((Object)cm);
            }
        }
        catch (PersistentStoreException e) {
            if (log.isEnabled(Logger.Level.FATAL)) {
                log.fatal((Object)"Unable to save clientMappings to the persistent store");
            }
            throw new Sync4jException((Throwable)e);
        }
    }

    private void readPrincipal(Sync4jPrincipal principal) throws PersistentStoreException {
        assert (principal != null);
        assert (principal.getUsername() != null);
        assert (principal.getDeviceId() != null);
        PersistentStore ps = this.syncEngine.getStore();
        ps.read((Object)principal);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    private String getStateName(int state) {
        String stateName = "STATE_UNKNOWN";
        switch (state) {
            case 0: {
                stateName = "STATE_START";
                break;
            }
            case 1: {
                stateName = "STATE_END";
                break;
            }
            case 65535: {
                stateName = "STATE_ERROR";
                break;
            }
            case 16: {
                stateName = "STATE_INITIALIZATION_PROCESSING";
                break;
            }
            case 17: {
                stateName = "STATE_INITIALIZATION_PROCESSED";
                break;
            }
            case 18: {
                stateName = "STATE_SYNCHRONIZATION_PROCESSING";
                break;
            }
            case 19: {
                stateName = "STATE_SYNCHRONIZATION_PROCESSED";
                break;
            }
            case 20: {
                stateName = "STATE_SYNCHRONIZATION_COMPLETION";
            }
        }
        return stateName;
    }

    public SyncState getSyncState() {
        return this.syncState;
    }
}

