/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.framework.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;

public class IOTools {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileBytes(File file) throws IOException {
        FileInputStream fis = null;
        byte[] buf = new byte[(int)file.length()];
        try {
            fis = new FileInputStream(file);
            fis.read(buf);
            fis.close();
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        return buf;
    }

    public static byte[] readFileBytes(String filename) throws IOException {
        return IOTools.readFileBytes(new File(filename));
    }

    public static String readFileString(File file) throws IOException {
        return new String(IOTools.readFileBytes(file));
    }

    public static String readFileString(String filename) throws IOException {
        return IOTools.readFileString(new File(filename));
    }

    public static void writeFile(String str, File file) throws IOException {
        IOTools.writeFile(str.getBytes(), file);
    }

    public static void writeFile(String str, String filename) throws IOException {
        IOTools.writeFile(str.getBytes(), new File(filename));
    }

    public static void writeFile(byte[] buf, String filename) throws IOException {
        IOTools.writeFile(buf, new File(filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(byte[] buf, File file) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            fos.write(buf);
            fos.close();
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    public static FilenameFilter getFileTypeFilter(String type) {
        return new FileTypeFilter(type);
    }

    public static class FileTypeFilter
    implements FilenameFilter {
        private String type;

        public FileTypeFilter(String type) {
            this.type = type.toUpperCase();
        }

        @Override
        public boolean accept(File dir, String name) {
            if (this.type == null) {
                return true;
            }
            if (this.type.length() == 0) {
                return name.indexOf(46) < 0;
            }
            return name.toUpperCase().endsWith(this.type);
        }
    }
}

