/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.framework.engine.source;

import com.funambol.framework.engine.SyncItem;
import com.funambol.framework.engine.SyncItemImpl;
import com.funambol.framework.engine.SyncItemKey;
import com.funambol.framework.engine.SyncProperty;
import com.funambol.framework.engine.source.AbstractSyncSource;
import com.funambol.framework.engine.source.SyncSource;
import com.funambol.framework.engine.source.SyncSourceException;
import java.io.Serializable;
import java.security.Principal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MemorySyncSource
extends AbstractSyncSource
implements SyncSource,
Serializable {
    public static final String NAME = "MemorySyncSource";
    private ArrayList<SyncItem> unchangedSyncItems = new ArrayList();
    private ArrayList<SyncItem> newSyncItems = new ArrayList();
    private ArrayList<SyncItem> updatedSyncItems = new ArrayList();
    private ArrayList<SyncItem> deletedSyncItems = new ArrayList();

    public MemorySyncSource() {
    }

    public MemorySyncSource(String name, String type, String sourceURI) {
        super(name, type, sourceURI);
    }

    public MemorySyncSource(String name, List<SyncItem> unchangedSyncItems, List<SyncItem> deletedSyncItems, List<SyncItem> newSyncItems, List<SyncItem> updatedSyncItems) {
        super(name);
        this.initialize(unchangedSyncItems, deletedSyncItems, newSyncItems, updatedSyncItems);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public SyncItem setSyncItem(Principal principal, SyncItem syncItem) throws SyncSourceException {
        this.unchangedSyncItems.remove(syncItem);
        this.newSyncItems.remove(syncItem);
        this.deletedSyncItems.add(syncItem);
        this.updatedSyncItems.add(syncItem);
        SyncItemImpl newSyncItem = new SyncItemImpl(this, syncItem.getKey().getKeyAsString(), 'N');
        newSyncItem.setProperties(syncItem.getProperties());
        return newSyncItem;
    }

    @Override
    public SyncItem[] setSyncItems(Principal principal, SyncItem[] syncItems) throws SyncSourceException {
        SyncItem[] ret = new SyncItem[syncItems.length];
        for (int i = 0; i < syncItems.length; ++i) {
            ret[i] = this.setSyncItem(principal, syncItems[i]);
        }
        return ret;
    }

    @Override
    public SyncItem getSyncItemFromId(Principal principal, SyncItemKey syncItemKey) throws SyncSourceException {
        SyncItem[] all = this.getAllSyncItems(principal);
        for (int i = 0; all != null && i < all.length; ++i) {
            if (!syncItemKey.equals(all[i].getKey())) continue;
            return all[i];
        }
        return null;
    }

    @Override
    public SyncItem[] getSyncItemsFromIds(Principal principal, SyncItemKey[] syncItemKeys) throws SyncSourceException {
        ArrayList<SyncItem> ret = new ArrayList<SyncItem>();
        SyncItem syncItem = null;
        for (int i = 0; syncItemKeys != null && i < syncItemKeys.length; ++i) {
            syncItem = this.getSyncItemFromId(principal, syncItemKeys[i]);
            if (syncItem == null) continue;
            ret.add(syncItem);
        }
        return ret.toArray(new SyncItem[ret.size()]);
    }

    public SyncItem[] getUnchangedSyncItems(Principal principal, Timestamp since) throws SyncSourceException {
        return this.unchangedSyncItems.toArray(new SyncItem[0]);
    }

    public SyncItemKey[] getUnchangedSyncItemKeys(Principal principal, Timestamp since) throws SyncSourceException {
        return this.extractKeys(this.unchangedSyncItems);
    }

    @Override
    public SyncItemKey[] getNewSyncItemKeys(Principal principal, Timestamp since) throws SyncSourceException {
        return this.extractKeys(this.newSyncItems);
    }

    @Override
    public SyncItem[] getNewSyncItems(Principal principal, Timestamp since) throws SyncSourceException {
        return this.newSyncItems.toArray(new SyncItem[0]);
    }

    @Override
    public SyncItemKey[] getDeletedSyncItemKeys(Principal principal, Timestamp since) throws SyncSourceException {
        return this.extractKeys(this.deletedSyncItems);
    }

    @Override
    public SyncItem[] getDeletedSyncItems(Principal principal, Timestamp since) throws SyncSourceException {
        return this.deletedSyncItems.toArray(new SyncItem[0]);
    }

    @Override
    public SyncItemKey[] getUpdatedSyncItemKeys(Principal principal, Timestamp since) throws SyncSourceException {
        return this.extractKeys(this.updatedSyncItems);
    }

    @Override
    public SyncItem[] getUpdatedSyncItems(Principal principal, Timestamp since) throws SyncSourceException {
        return this.updatedSyncItems.toArray(new SyncItem[0]);
    }

    @Override
    public void removeSyncItem(Principal principal, SyncItem syncItem) throws SyncSourceException {
        this.unchangedSyncItems.remove(syncItem);
        this.newSyncItems.remove(syncItem);
        this.updatedSyncItems.remove(syncItem);
        this.deletedSyncItems.add(syncItem);
    }

    @Override
    public void removeSyncItems(Principal principal, SyncItem[] syncItems) throws SyncSourceException {
        for (int i = 0; i < syncItems.length; ++i) {
            this.removeSyncItem(principal, syncItems[i]);
        }
    }

    @Override
    public SyncItem[] getAllSyncItems(Principal principal) throws SyncSourceException {
        int i;
        SyncItem[] unchangedItems = this.getUnchangedSyncItems(principal, null);
        SyncItem[] newItems = this.getNewSyncItems(principal, null);
        SyncItem[] deletedItems = this.getDeletedSyncItems(principal, null);
        SyncItem[] updatedItems = this.getUpdatedSyncItems(principal, null);
        SyncItem[] allItems = new SyncItem[unchangedItems.length + newItems.length + deletedItems.length + updatedItems.length];
        int c = 0;
        for (i = 0; i < unchangedItems.length; ++i) {
            allItems[c++] = unchangedItems[i];
        }
        for (i = 0; i < newItems.length; ++i) {
            allItems[c++] = newItems[i];
        }
        for (i = 0; i < deletedItems.length; ++i) {
            allItems[c++] = deletedItems[i];
        }
        for (i = 0; i < updatedItems.length; ++i) {
            allItems[c++] = updatedItems[i];
        }
        return allItems;
    }

    public boolean isModified(Principal principal, Timestamp since) {
        try {
            return this.getDeletedSyncItems(principal, since).length > 0 || this.getNewSyncItems(principal, since).length > 0 || this.getUpdatedSyncItems(principal, since).length > 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void initialize(List<SyncItem> existingItems, List<SyncItem> deletedItems, List<SyncItem> newItems, List<SyncItem> updatedItems) {
        this.unchangedSyncItems.clear();
        this.deletedSyncItems.clear();
        this.newSyncItems.clear();
        this.updatedSyncItems.clear();
        this.unchangedSyncItems.addAll(existingItems);
        this.deletedSyncItems.addAll(deletedItems);
        this.newSyncItems.addAll(newItems);
        this.updatedSyncItems.addAll(updatedItems);
        SyncItem syncItem2 = null;
        for (SyncItem syncItem2 : this.deletedSyncItems) {
            this.unchangedSyncItems.remove(syncItem2);
            this.newSyncItems.remove(syncItem2);
            this.updatedSyncItems.remove(syncItem2);
        }
        for (SyncItem syncItem2 : this.updatedSyncItems) {
            this.unchangedSyncItems.remove(syncItem2);
            this.newSyncItems.remove(syncItem2);
        }
        for (SyncItem syncItem2 : this.newSyncItems) {
            this.unchangedSyncItems.remove(syncItem2);
        }
    }

    @Override
    public SyncItem getSyncItemFromTwin(Principal principal, SyncItem syncItemTwin) throws SyncSourceException {
        SyncItem[] syncItems = this.getSyncItemsFromTwins(principal, new SyncItem[]{syncItemTwin});
        if (syncItems == null || syncItems.length == 0) {
            return null;
        }
        return syncItems[0];
    }

    @Override
    public SyncItem[] getSyncItemsFromTwins(Principal principal, SyncItem[] syncItemTwins) throws SyncSourceException {
        ArrayList<SyncItem> ret = new ArrayList<SyncItem>();
        String[] contents = new String[syncItemTwins.length];
        for (int i = 0; i < syncItemTwins.length; ++i) {
            contents[i] = new String((byte[])syncItemTwins[i].getProperty("BINARY_CONTENT").getValue());
        }
        SyncItem[] all = this.getAllSyncItems(principal);
        String content = null;
        SyncProperty prop = null;
        block1: for (int i = 0; i < all.length; ++i) {
            prop = all[i].getProperty("BINARY_CONTENT");
            if (prop != null) {
                content = new String((byte[])prop.getValue());
            }
            for (int j = 0; content != null && j < contents.length; ++j) {
                if (!content.equals(contents[j])) continue;
                ret.add(all[i]);
                continue block1;
            }
        }
        return ret.toArray(new SyncItem[ret.size()]);
    }

    private SyncItemKey[] extractKeys(Collection<SyncItem> syncItems) {
        SyncItemKey[] keys = new SyncItemKey[syncItems.size()];
        SyncItem syncItem2 = null;
        int j = 0;
        for (SyncItem syncItem2 : syncItems) {
            keys[j] = syncItem2.getKey();
            ++j;
        }
        return keys;
    }
}

