/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.framework.engine.pipeline;

import com.funambol.framework.core.Sync4jException;
import com.funambol.framework.core.SyncML;
import com.funambol.framework.core.Util;
import com.funambol.framework.engine.pipeline.InputMessageProcessor;
import com.funambol.framework.engine.pipeline.MessageProcessingContext;
import com.funambol.framework.engine.pipeline.OutputMessageProcessor;
import java.io.Serializable;
import org.jboss.logging.Logger;

public class PipelineManager
implements InputMessageProcessor,
OutputMessageProcessor,
Serializable {
    private static final Logger log = Logger.getLogger((String)PipelineManager.class.getName());
    private InputMessageProcessor[] inputProcessors = null;
    private OutputMessageProcessor[] outputProcessors = null;

    public InputMessageProcessor[] getInputProcessors() {
        return this.inputProcessors;
    }

    public void setInputProcessors(InputMessageProcessor[] inputProcessors) {
        this.inputProcessors = inputProcessors;
    }

    public OutputMessageProcessor[] getOutputProcessors() {
        return this.outputProcessors;
    }

    public void setOutputProcessors(OutputMessageProcessor[] outputProcessors) {
        this.outputProcessors = outputProcessors;
    }

    @Override
    public void preProcessMessage(MessageProcessingContext processingContext, SyncML message) {
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)"Starting preprocessing");
        }
        int size = this.inputProcessors.length;
        for (int i = 0; i < size; ++i) {
            try {
                this.inputProcessors[i].preProcessMessage(processingContext, message);
                continue;
            }
            catch (Sync4jException e) {
                log.info((Object)("preProcessMessage error: " + e));
            }
        }
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)("Preprocessed message: " + Util.toXML(message)));
        }
    }

    @Override
    public void postProcessMessage(MessageProcessingContext processingContext, SyncML message) {
        if (log.isEnabled(Logger.Level.TRACE)) {
            log.trace((Object)"Starting postprocessing");
            log.trace((Object)("Returning message to process: " + Util.toXML(message)));
        }
        int size = this.outputProcessors.length;
        for (int i = 0; i < size; ++i) {
            try {
                this.outputProcessors[i].postProcessMessage(processingContext, message);
                continue;
            }
            catch (Sync4jException e) {
                log.info((Object)("postProcessMessage error: " + e.getMessage()), (Throwable)e);
            }
        }
    }
}

