' Attribute VB_Name = "DbAccess"
Option Explicit
'----------------------------------------------
'! @brief DBڑ̂߂̃V[gJbgNX
'! @require common.vbs
'! @require Configuration.cls
'! @require Logger.cls
'! @note (config.properties)database.xxx.connectionString̐ݒ肪Kv
'----------------------------------------------
Class DbAccess
	Dim mConnection
	
	Public Function GetConnection()
		Set GetConnection = mConnection
	End Function
	'-------------------------------------------------------------------
	'*	@brief ڑJ
	'*	@param dbname gpf[^x[X̐ݒ薼wB
	'*	database.hoge.connectionStringݒ肵ꍇAw肷̂"hoge"
	'-------------------------------------------------------------------
	Public Sub open(dbname)
		On Error Resume Next
		Dim connectionString
		connectionString = ScriptProperties.Item("database." & dbname & ".connectionString")

		Set mConnection = CreateObject("ADODB.Connection")
		mConnection.ConnectionString = connectionString
		mConnection.Open
		If Err.Number <> 0 Then
			HandleErrors
			Wscript.Quit 99
		End If
		Logger.Debug "Database connected " & connectionString

		
	End Sub
	'-------------------------------------------------------------------
	'* @brief ڑ
	'-------------------------------------------------------------------
	Public Sub close()
		mConnection.Close
		Set mConnection = Nothing
	End Sub
	
	'-------------------------------------------------------------------
	'* @brief wNG[烌R[hZbg쐬
	'* @remarks querySQLQuotgpăGXP[vĂׂ
	'-------------------------------------------------------------------
	Public Function openRecordset(query)
		Logger.Debug "DbAccess#openRecordset query=" & query
		On Error Resume Next
		dim rs
		Logger.Debug query
		Set rs = mConnection.Execute(query)
		If Err.Number <> 0 Then
			HandleErrors
			Wscript.Quit 99
		End If
		Set openRecordset = rs
	End Function
	'-------------------------------------------------------------------
	'* @brief wNG[s
	'* @remarks querySQLQuotgpăGXP[vĂׂ
	'-------------------------------------------------------------------
	Public Function execute(query)
		Logger.Debug "DbAccess#execute query=" & query
		On Error Resume Next
		Dim result
		 mConnection.Execute query,result
		If Err.Number <> 0 Then
			HandleErrors
			Wscript.Quit 99
		End If
		execute = result
	End Function
	'-------------------------------------------------------------------
	'* @brief wNG[DbCommand̃CX^X쐬
	'* @remarks commantType  adCmdText̏ꍇAp[^̃v[Xz_ "?"<br />
	'* commantType  adCmdStoredProc̏ꍇAp[^̃v[Xz_ XgAhvV[W̃p[^
	'-------------------------------------------------------------------
	Public Function createCommand(query,commantType)
		Dim command
		Set command = new DbCommand
		command.newCommand commantType,query,mConnection
		
		Set createCommand = command
	End Function
	
	'-------------------------------------------------------------------
	'* tran start
	'-------------------------------------------------------------------
	Public Function beginTransaction()
		mConnection.BeginTrans
	End Function
	'-------------------------------------------------------------------
	'* tran end
	'-------------------------------------------------------------------
	Public Function commitTransaction()
		mConnection.CommitTrans
	End Function
	
	Sub HandleError()
		If mConnection.Errors.Count > 0 Then
			LogErrors
		Else
			Logger.Error "Database Error " & Err.Description
		End If
	End Sub
	Sub LogErrors()
		Dim e
		For Each e In mConnection.Errors
			Logger.Error e.Description
		Next
	End Sub
	'-------------------------------------------------------------------
	'* tran end
	'-------------------------------------------------------------------
	Public Function rollbackTransaction()
		mConnection.RollbackTrans
	End Function
	
	Public Sub Class_Initialize
	End Sub
	Public Sub Class_Terminate
	End Sub

End Class
