<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Insert title here</title>
<link rel="StyleSheet" type="text/css" href="js/yui-2.8.0r4/reset-fonts-grids/reset-fonts-grids.css" />
<link rel="StyleSheet" type="text/css"  href="js/yui-2.8.0r4/datatable/assets/datatable-core.css" />
<link rel="StyleSheet" type="text/css"  href="js/yui-2.8.0r4/datatable/assets/datatable.css" />
<link rel="StyleSheet" type="text/css"  href="js/yui-2.8.0r4/assets/skins/sam/datatable.css" />
<link rel="StyleSheet" type="text/css"  href="js/yui-2.8.0r4/assets/skins/sam/container.css" />
<link rel="StyleSheet" type="text/css"  href="js/yui-2.8.0r4/assets/skins/sam/button.css" />
<style>
.yui-skin-sam tr.yui-dt-odd {
	background-color:#F5F5F5;
}
</style>
</head>
<body class="yui-skin-sam">
	<div style="text-align : left;">
	<form action="" method="post" >
		郵便番号:   <input type="text" id="zip" name="zip" value="" /><br />
		都道府県:   <input type="text" id="pref" name="pref" value="" /><br />
		市区町村郡: <input type="text" id="city" name="city" value="" /><br />
		<input type="button" id="submit1" name="submit1" value="検索" /><img src="js/yui-2.8.0r4/assets/skins/sam/loading.gif" id="loadingIcon" style="visibility:hidden" />
	</form>
		郵便番号:   <input type="text" id="result_zip" name="result_zip" value="" /><br />
		都道府県:   <input type="text" id="result_pref" name="result_pref" value="" /><br />
		市区町村郡: <input type="text" id="result_city" name="result_city" value="" /><br />
		町域: <input type="text" id="result_town" name="result_town" value="" /><br />
	
	</div>
<script type="text/javascript" src="js/yui-2.8.0r4/utilities/utilities.js"></script>
<script type="text/javascript" src="js/yui-2.8.0r4/connection/connection.js"></script>
<script type="text/javascript" src="js/yui-2.8.0r4/datasource/datasource.js"></script>
<script type="text/javascript" src="js/yui-2.8.0r4/datatable/datatable.js"></script>
<script type="text/javascript" src="js/yui-2.8.0r4/container/container.js"></script>
<script type="text/javascript" src="js/yui-2.8.0r4/button/button.js"></script>
<script>
postalSearch = {
	lastParameter : {zip : "",pref : "",city : ""},
	config: {},
	init : function(config){
		this.config = config;
    	//ダイアログ
    	this.createDialog();
    	//データソース
    	this.createDataSource();
    	//データテーブル
    	this.createDataTable();
    	this.createButtons();
    	//行を選択したイベント定義
    	this.selectedEvent = new YAHOO.util.CustomEvent("selected", this);
	}
	,createDialog : function(){
    	//郵便番号リスト表示ダイアログ作成
    	this.dialog = new YAHOO.widget.Panel("postalSearchDialog", 
    	    	{ width:"620px", visible:false, constraintoviewport:true,draggable:true,context:["zip","tl","tr"] } 
    	);
    	this.dialog.setHeader("郵便番号検索");
    	this.dataTableId = YAHOO.util.Dom.generateId();
    	this.dialog.setBody("<div id=\"" + this.dataTableId +"\"></div>");
    	
    	this.dialog.render(document.body);
	}
	,createDataSource : function(){
        this.myDataSource = new YAHOO.util.DataSource("postalSearchProxy.php?");
        this.myDataSource.responseType = YAHOO.util.DataSource.TYPE_JSON;
        this.myDataSource.connXhrMode = "queueRequests";
        this.myDataSource.responseSchema = {
            resultsList: "data",
            fields: ["zipcode7","pref","city","town"]
        };
	}
	,createDataTable : function(){
    	//データテーブル
        var myColumnDefs = [
                            {key:"zipcode7", label:"zipcode7",width:55},
                            {key:"pref",width:60},
                            {key:"city",width:120},
                            {key:"town",width:250}
                            
                        ];
        
    	this.myDataTable = new YAHOO.widget.ScrollingDataTable(this.dataTableId, 
    			myColumnDefs,
        		this.myDataSource, {height:"20em",width:"600px",selectionMode:"single",initialLoad :false }
    	);
       	this.myDataTable.subscribe("rowMouseoverEvent", this.myDataTable.onEventHighlightRow);
       	this.myDataTable.subscribe("rowMouseoutEvent", this.myDataTable.onEventUnhighlightRow);
       	this.myDataTable.subscribe("rowClickEvent", this.myDataTable.onEventSelectRow);
       	this.myDataTable.subscribe("rowDblclickEvent", this.datatable_rowdoubleclick,null,this);
       	
	}
	,createButtons : function(){
		var okButton = new YAHOO.widget.Button({
		    type: "button", 
		    label: "選択",
		    onclick :  { fn:this.selectRow_onclick,scope:this }
		}); 
		var cancelButton = new YAHOO.widget.Button({
		    type: "button", 
		    label : "閉じる",
		    onclick :  { fn:function(){this.dialog.hide();},scope:this }
		});
        var oSpan = document.createElement("span");
		okButton.appendTo(oSpan);
		cancelButton.appendTo(oSpan);
		this.dialog.setFooter(oSpan);		
		
	} 
	,doSearch : function(zip,pref,city){
		if( (this.lastParameter.zip == zip )&&(this.lastParameter.pref == pref )&&(this.lastParameter.city == city )){
			this.dialog.show();
			return;
		}
    	this.showLoadingIcon();
    	var query = "zip=" + zip + "&pref=" + pref + "&city=" + city; 
        var callback1 = {
                success : this.postalSearch_complete,
                failure : this.postalSearch_complete,
                scope : this
            };
        this.myDataSource.sendRequest(query,callback1);
        this.lastParameter.zip = zip;
        this.lastParameter.pref = pref;
        this.lastParameter.city = city;
        
	}
	,postalSearch_complete : function(){
    	this.hideLoadingIcon();
       	 this.myDataTable.set("sortedBy", null); 
    	 this.myDataTable.onDataReturnReplaceRows.apply(this.myDataTable,arguments);
    	 this.dialog.show();
	}
	,datatable_rowdoubleclick : function(event,target){
		this.selectRow();
	}
	,selectRow_onclick : function(event){
		this.selectRow();
	}
	,selectRow : function(){
		var recordId = this.myDataTable.getLastSelectedRecord();
		if(recordId == null) return ;
		var record =  this.myDataTable.getRecord(recordId);
    		
		this.selectedEvent.fire(record.getData());
		this.dialog.hide();
	}
	,showLoadingIcon : function(){
		if(typeof(this.config.loadingIcon) == "undefined") return;
    	YAHOO.util.Dom.setStyle(this.config.loadingIcon,"visibility","visible");
	}		
	,hideLoadingIcon : function(){
		if(typeof(this.config.loadingIcon) == "undefined") return;
    	YAHOO.util.Dom.setStyle(this.config.loadingIcon,"visibility","hidden");
	}		
}
test={
	init:function(){
		postalSearch.init({loadingIcon: "loadingIcon"});
       	//ボタンに反応する
    	YAHOO.util.Event.on("submit1","click",this.submit_onclick,this,true);
    	postalSearch.selectedEvent.subscribe(this.zipRecord_selected,this);
 	}
	,submit_onclick : function(event){
    	var zip = YAHOO.util.Dom.get("zip").value;
    	var pref = YAHOO.util.Dom.get("pref").value;
    	var city = YAHOO.util.Dom.get("city").value;

    	postalSearch.doSearch(zip,pref,city);
	}
	,selectRow_onclick : function(event){
		var recordId = this.myDataTable.getLastSelectedRecord();
		var record =  this.myDataTable.getRecord(recordId);
    		
		this.selectedEvent.fire(record.getData());
	}
	,zipRecord_selected : function(type, args, me){
    	YAHOO.util.Dom.get("result_zip").value = args[0].zipcode7;
    	YAHOO.util.Dom.get("result_pref").value = args[0].pref;
    	YAHOO.util.Dom.get("result_city").value = args[0].city;
    	YAHOO.util.Dom.get("result_town").value = args[0].town;
	}
	
}

YAHOO.util.Event.onDOMReady(test.init,test,true);
</script>
</body>
</html>