<?php
require_once("startup.php");
require_once 'PHPUnit/Framework.php';
require_once("CFW/Util/String.php");
require_once("CFW/FieldProperties/Abstract.php");
require_once("CFW/FieldProperties/Byte.php");
require_once("CFW/FieldProperties/Date.php");
require_once("CFW/FieldProperties/Decimal.php");
require_once("CFW/FieldProperties/Double.php");
require_once("CFW/FieldProperties/Int.php");
require_once("CFW/FieldProperties/Long.php");
require_once("CFW/FieldProperties/Short.php");
require_once("CFW/FieldProperties/String.php");

require_once("CFW/FieldValidators/Abstract.php");
require_once("CFW/FieldValidators/Byte.php");
require_once("CFW/FieldValidators/Date.php");
require_once("CFW/FieldValidators/Decimal.php");
require_once("CFW/FieldValidators/Double.php");
require_once("CFW/FieldValidators/Int.php");
require_once("CFW/FieldValidators/Long.php");
require_once("CFW/FieldValidators/Short.php");
require_once("CFW/FieldValidators/String.php");
require_once "Date.php";
require_once "Date/Calc.php";
require_once "Date/Span.php";
require_once "Date/TimeZone.php";
class validatorTest extends PHPUnit_Framework_TestCase
{
    var $byteProperty;
    var $dateProperty;
    var $decimalProperty;
    var $doubleProperty;
    var $intProperty;
    var $shortProperty;
    var $stringProperty;
    var $wstringProperty;
    var $longProperty;
    
    public function setUp(){
        $this->byteProperty =  CFW_FieldProperties_Abstract::newInstance("tinyint", "test_table", "field1","[field1]", 1, 3, 0, true, 0,false);
        $this->dateProperty =  CFW_FieldProperties_Abstract::newInstance("datetime", "test_table", "field2","[field2]", 16, 23, 0, true, null,false);
        $this->decimalProperty =  CFW_FieldProperties_Abstract::newInstance("decimal", "test_table", "field3","[field3]", 8, 10, 2, true, 0,false);
        $this->doubleProperty =  CFW_FieldProperties_Abstract::newInstance("double", "test_table", "field4","[field4]", 8, 15, 0, true, 0,false);
        $this->intProperty =  CFW_FieldProperties_Abstract::newInstance("int", "test_table", "field5","[field5]", 4, 10, 0, true,0,false);
        $this->shortProperty =  CFW_FieldProperties_Abstract::newInstance("smallint", "test_table", "field6","[field6]", 2, 5, 0, true, 0,false);
        $this->stringProperty =  CFW_FieldProperties_Abstract::newInstance("varchar", "test_table", "field7","[field7]", 10, 10, 0, true, "",false);
        $this->wstringProperty =  CFW_FieldProperties_Abstract::newInstance("nvarchar", "test_table", "field8","[field8]", 20, 10, 0, true, "",false);
        $this->longProperty =  CFW_FieldProperties_Abstract::newInstance("bigint", "test_table", "field9","[field9]", 8, 19, 0, true, 0,false);
    }
    public function tearDown(){
        
    }
    
    public function testGetInstance()
    {
        $validator = CFW_FieldValidators_Abstract::getInstance($this->byteProperty);
        $this->assertType("CFW_FieldValidators_Byte",$validator);        
        
        $validator = CFW_FieldValidators_Abstract::getInstance($this->dateProperty);
        $this->assertType("CFW_FieldValidators_Date",$validator);        
        
        $validator = CFW_FieldValidators_Abstract::getInstance($this->decimalProperty);
        $this->assertType("CFW_FieldValidators_Decimal",$validator);        
        
        $validator = CFW_FieldValidators_Abstract::getInstance($this->doubleProperty);
        $this->assertType("CFW_FieldValidators_Double",$validator);        
        
        $validator = CFW_FieldValidators_Abstract::getInstance($this->intProperty);
        $this->assertType("CFW_FieldValidators_Int",$validator);        
        
        $validator = CFW_FieldValidators_Abstract::getInstance($this->shortProperty);
        $this->assertType("CFW_FieldValidators_Short",$validator);        
        
        $validator = CFW_FieldValidators_Abstract::getInstance($this->stringProperty);
        $this->assertType("CFW_FieldValidators_String",$validator);        
        
        $validator = CFW_FieldValidators_Abstract::getInstance($this->wstringProperty);
        $this->assertType("CFW_FieldValidators_String",$validator);        

        $validator = CFW_FieldValidators_Abstract::getInstance($this->longProperty);
        $this->assertType("CFW_FieldValidators_Long",$validator);        
    }
    public function testByte(){
        $property = $this->byteProperty;
        $validator = CFW_FieldValidators_Abstract::getInstance($property);

        $value = 1;
        $valid = $validator->validate($value);
        $this->assertTrue($valid);

        $value = 255;
        $valid = $validator->validate($value);
        $this->assertTrue($valid);
        
        $value = null;
        $valid = $validator->validate($value);
        $this->assertTrue($property->nullable);
        $this->assertTrue($valid);
        
        $value = 256;
        $valid = $validator->validate($value);
        $this->assertFalse($valid);
        
        $property->nullable = false;
        $validator = CFW_FieldValidators_Abstract::getInstance($property);
        $value = null;
        $valid = $validator->validate($value);
        $this->assertFalse($valid);

        $value = 1;
        $valid = $validator->validate($value);
        $this->assertTrue($valid);

        
    }
    public function testDate(){
        $property = $this->dateProperty;
        $validator = CFW_FieldValidators_Abstract::getInstance($property);

        $value = 1;
        $valid = $validator->validate($value);
        $this->assertFalse($valid);

        $value = CFW_Util_Date::create(2010,10,11);
        $valid = $validator->validate($value);
        $this->assertTrue($valid);
        
        $value = null;
        $valid = $validator->validate($value);
        $this->assertTrue($property->nullable);
        $this->assertTrue($valid);
        
        $property->minValue = CFW_Util_Date::create(2010,10,11);
        $property->maxValue = CFW_Util_Date::create(2010,11,11);
        $value = CFW_Util_Date::create(2010,10,10);
        $valid = $validator->validate($value);
        $this->assertFalse($valid);
        
        $property->nullable = false;
        $validator = CFW_FieldValidators_Abstract::getInstance($property);
        $value = null;
        $valid = $validator->validate($value);
        $this->assertFalse($valid);

    }
    public function testDecimal(){
        $property = $this->decimalProperty;
        $validator = CFW_FieldValidators_Abstract::getInstance($property);

        $value = 1;
        $valid = $validator->validate($value);
        $this->assertTrue($valid);

        $value = 12.345;
        $valid = $validator->validate($value);
        $this->assertFalse($valid);
        
        $value = 123456789.34;
        $valid = $validator->validate($value);
        $this->assertFalse($valid);
        
        $value = null;
        $valid = $validator->validate($value);
        $this->assertTrue($property->nullable);
        $this->assertTrue($valid);
        
        $property->minValue = -100;
        $property->maxValue = 100;
        $value = -101;
        $valid = $validator->validate($value);
        $this->assertFalse($valid);
        
        $value = 101;
        $valid = $validator->validate($value);
        $this->assertFalse($valid);
        
        $property->nullable = false;
        $validator = CFW_FieldValidators_Abstract::getInstance($property);
        $value = null;
        $valid = $validator->validate($value);
        $this->assertFalse($valid);
        
    }
    public function testDouble(){
        $property = $this->doubleProperty;
        $property->precision = 5;
        $property->scale = 2;
        $validator = CFW_FieldValidators_Abstract::getInstance($property);

        $value = 1;
        $valid = $validator->validate($value);
        $this->assertTrue($valid);

        $value = 12.345;
        $valid = $validator->validate($value);
        $this->assertFalse($valid);
        
        $value = 1234.34;
        $valid = $validator->validate($value);
        $this->assertFalse($valid);
        
        $value = 1234.3;
        $valid = $validator->validate($value);
        $this->assertFalse($valid);
        
        $value = null;
        $valid = $validator->validate($value);
        $this->assertTrue($valid);
        
        $property->minValue = -100;
        $property->maxValue = 100;
        $value = -100.1;
        $valid = $validator->validate($value);
        $this->assertFalse($valid);
        
        $value = 100.1;
        $valid = $validator->validate($value);
        $this->assertFalse($valid);
        
        $property->nullable = false;
        $validator = CFW_FieldValidators_Abstract::getInstance($property);
        $value = null;
        $valid = $validator->validate($value);
        $this->assertFalse($valid);
    }
    public function testInt(){
        $property = $this->intProperty;
        $validator = CFW_FieldValidators_Abstract::getInstance($property);

        $value = 1;
        $valid = $validator->validate($value);
        $this->assertTrue($valid);

        $value = 12345678901;
        $valid = $validator->validate($value);
        $this->assertFalse($valid);
        
        $value = 1234.34;
        $valid = $validator->validate($value);
        $this->assertFalse($valid);
        
        $value = 1234.3;
        $valid = $validator->validate($value);
        $this->assertFalse($valid);
        
        $value = null;
        $valid = $validator->validate($value);
        $this->assertTrue($valid);

        $property->minValue = -100;
        $property->maxValue = 100;
        $value = -100.1;
        $valid = $validator->validate($value);
        $this->assertFalse($valid);
        
        $value = 100.1;
        $valid = $validator->validate($value);
        $this->assertFalse($valid);
        
        $property->nullable = false;
        $validator = CFW_FieldValidators_Abstract::getInstance($property);
        $value = null;
        $valid = $validator->validate($value);
        $this->assertFalse($valid);
    }
    public function testShort(){
        $property = $this->shortProperty;
        $validator = CFW_FieldValidators_Abstract::getInstance($property);

        $value = 1;
        $valid = $validator->validate($value);
        $this->assertTrue($valid);
        
        $value = 32767;
        $valid = $validator->validate($value);
        $this->assertTrue($valid);

        $value = -32767;
        $valid = $validator->validate($value);
        $this->assertTrue($valid);

        
        $value = 123456;
        $valid = $validator->validate($value);
        $this->assertFalse($valid);
        
        $value = 1234.34;
        $valid = $validator->validate($value);
        $this->assertFalse($valid);
        
        $value = 1234.3;
        $valid = $validator->validate($value);
        $this->assertFalse($valid);
        
        $value = null;
        $valid = $validator->validate($value);
        $this->assertTrue($valid);
        
        $property->minValue = -100;
        $property->maxValue = 100;
        $value = -101;
        $valid = $validator->validate($value);
        $this->assertFalse($valid);
        
        $value = 101;
        $valid = $validator->validate($value);
        $this->assertFalse($valid);
        
        $property->nullable = false;
        $validator = CFW_FieldValidators_Abstract::getInstance($property);
        $value = null;
        $valid = $validator->validate($value);
        $this->assertFalse($valid);
    }
    public function testString(){
        $property = $this->stringProperty;
        $validator = CFW_FieldValidators_Abstract::getInstance($property);

        $value = "abcdefghij";
        $valid = $validator->validate($value);
        $this->assertTrue($valid);
        
        $value = "あいうえお";
        $valid = $validator->validate($value);
        $this->assertTrue($valid);
        
        $value = 32767;
        $valid = $validator->validate($value);
        $this->assertFalse($valid);

        $value = "12345678901";
        $valid = $validator->validate($value);
        $this->assertFalse($valid);

        $value = "あいうえお1";
        $valid = $validator->validate($value);
        $this->assertFalse($valid);
        
        $value = null;
        $valid = $validator->validate($value);
        $this->assertTrue($valid);
        
        
        $property->nullable = false;
        $validator = CFW_FieldValidators_Abstract::getInstance($property);
        $value = null;
        $valid = $validator->validate($value);
        $this->assertFalse($valid);

        $property->format = "^[a-zA-Z]*$";
        $validator = CFW_FieldValidators_Abstract::getInstance($property);
        $value = "abcdefghij";
        $valid = $validator->validate($value);
        $this->assertTrue($valid);
        
        $value = "1234567";
        $valid = $validator->validate($value);
        $this->assertFalse($valid);
    }
    public function testWString(){
        $property = $this->wstringProperty;
        $validator = CFW_FieldValidators_Abstract::getInstance($property);

        $value = "abcdefghij";
        $valid = $validator->validate($value);
        $this->assertTrue($valid);
        
        $value = "あいうえおかきくけこ";
        $valid = $validator->validate($value);
        $this->assertTrue($valid);
        
        $value = 32767;
        $valid = $validator->validate($value);
        $this->assertFalse($valid);

        $value = "12345678901";
        $valid = $validator->validate($value);
        $this->assertFalse($valid);

        $value = "あいうえおかきくけこ1";
        $valid = $validator->validate($value);
        $this->assertFalse($valid);
        
        $value = null;
        $valid = $validator->validate($value);
        $this->assertTrue($valid);
        
        
        $property->nullable = false;
        $validator = CFW_FieldValidators_Abstract::getInstance($property);
        $value = null;
        $valid = $validator->validate($value);
        $this->assertFalse($valid);

        $property->format = "^[a-zA-Z]*$";
        $validator = CFW_FieldValidators_Abstract::getInstance($property);
        $value = "abcdefghij";
        $valid = $validator->validate($value);
        $this->assertTrue($valid);
        
        $value = "1234567";
        $valid = $validator->validate($value);
        $this->assertFalse($valid);
    }
    public function testLong(){
        $property = $this->longProperty;
        $validator = CFW_FieldValidators_Abstract::getInstance($property);

        $value = 1;
        $valid = $validator->validate($value);
        $this->assertTrue($valid);

        $value = 12345678901234;
        $valid = $validator->validate($value);
        echo mb_strwidth($value) . PHP_EOL;
        echo mb_convert_encoding( $validator->message,"Shift_JIS") . PHP_EOL;
        $this->assertTrue($valid);

        $value = 99999999999999;
        $valid = $validator->validate($value);
        $this->assertTrue($valid);
        
        $value = -12345678901234;
        $valid = $validator->validate($value);
        $this->assertTrue($valid);
        
        $value = 1234.34;
        $valid = $validator->validate($value);
        $this->assertFalse($valid);
        
        $value = 1234.3;
        $valid = $validator->validate($value);
        $this->assertFalse($valid);
        
        $value = null;
        $valid = $validator->validate($value);
        $this->assertTrue($valid);

        $property->minValue = -100;
        $property->maxValue = 100;
        $value = -100.1;
        $valid = $validator->validate($value);
        $this->assertFalse($valid);
        
        $value = 100.1;
        $valid = $validator->validate($value);
        $this->assertFalse($valid);
        
        $property->nullable = false;
        $validator = CFW_FieldValidators_Abstract::getInstance($property);
        $value = null;
        $valid = $validator->validate($value);
        $this->assertFalse($valid);
    }
    
}

