<?php
Zend_Loader::loadClass("CFW_Config_Configuration");
Zend_Loader::loadClass("CFW_IO_FileSystem");
Zend_Loader::loadClass("CFW_IO_FileReader");
Zend_Loader::loadClass("CFW_Util_String");

/**
 * 連想配列を使用するメッセージリソース
 *
 * 対応する名称を配列で設定すると "(element1).(element2)....txt"というファイルを探して使用する。
 * 名称に合致するものが無ければcommon.txtを使用する
 * @author okada
 * @package CFW_MessageResource
 */
class CFW_MessageResource_Default{
    var $resourceText;
    public function __construct(){
        $this->resourceText = array();
    }
    /**
     * リソースファイル読み込み
     * @param String $filename
     * @return none
     */
    public function load($filename){
        $reader = new CFW_IO_FileReader($filename);
        $reader->open();

        while(!$reader->isEOF()){
            $buffer = CFW_Util_String::trim( $reader->readLine() );
            if(substr($buffer,0,1) == "") continue;
            if(substr($buffer,0,1) == ";") continue;
            if(substr($buffer,0,1) == "#") continue;

            $keyValue = CFW_Util_String::splitKeyValue($buffer);
            //var_dump($keyValue);
            //echo PHP_EOL;
            $this->resourceText[ $keyValue["key"]] = $keyValue["value"];
        }
        $reader->close();

    }
    /**
     * 指定キーのメッセージを取得
     * @param String $key
     * @return String
     */
    public function getString($key){
        $value = $this->resourceText[$key];
        return $value;
    }
    /**
     * 指定キーのメッセージをBooleanとして取得
     * @param String $key
     * @return Boolean
     */
    public function getBoolean($key){
        $value = CFW_Util_Number::boolValue($this->resourceText[$key]);
        return $value;
    }
    /**
     * 指定キーのメッセージをIntegerとして取得
     * @param String $key
     * @return Integer
     */
    public function getInteger($key){
        $value = CFW_Util_Number::intValue($this->resourceText[$key]);
        return $value;
    }
}