<?php
/**
 * 文字列を逐次処理するためのReader
 * @author okada
 * @package CFW_IO
 */
class CFW_IO_StringReader extends CFW_IO_Reader{
    var $str;
    var $len;
    var $ptr;

    public function __construct($s){
        $this->str = $s;
        $this->len = mb_strlen($s);
        $this->ptr = 0;

    }
    /* (non-PHPdoc)
     * @see library/CFW/IO/CFW_IO_Reader#read()
     */
    public function read(){
        if($this->ptr >= $this->len  ){
            return CFW_IO_Reader::EOF;
        }

        $c = mb_substr($this->str,$this->ptr,1);
        $this->ptr++;
        return $c;
    }
    /* (non-PHPdoc)
     * @see library/CFW/IO/CFW_IO_Reader#readLine()
     */
    public function readLine(){
        if($this->ptr >= $this->len  ){
            return CFW_IO_Reader::EOF;
        }
        $buffer = "";

        $pos = mb_strpos($this->str,"\r\n",$this->ptr);
        if($pos !== false){
            $buffer = mb_substr($this->str,$this->ptr,$pos - $this->ptr);
            $this->ptr = $pos + 2;
            return $buffer;
        }
        $pos = mb_strpos($this->str,"\n",$this->ptr);
        if($pos !== false){
            $buffer = mb_substr($this->str,$this->ptr,$pos - $this->ptr);
            $this->ptr = $pos + 1;
            return $buffer;
        }
        $pos = mb_strpos($this->str,"\r",$this->ptr);
        if($pos !== false){
            $buffer = mb_substr($this->str,$this->ptr,$pos - $this->ptr);
            $this->ptr = $pos + 1;
            return $buffer;
        }
        $buffer = mb_substr($this->str,$this->ptr);
        $this->ptr = $this->len;
        return $buffer;

    }
    /* (non-PHPdoc)
     * @see library/CFW/IO/CFW_IO_Reader#isEOF()
     */
    public function isEOF(){
        if($this->ptr >= $this->len  ){
            return true;
        }
        return false;

    }

}
?>