<?php
class PostalSearchModel{
    /**
     * 指定条件で郵便番号データを検索する。
     * 
     * @param string $zip
     * @param string $pref
     * @param string $city
     */
    public function search($zip,$pref,$city){
        if($zip == "" && $pref == "" && $city == ""){
            return array("data" => array(),"count" => 0);
        }
        try{
            $connection = CFW_Data_ConnectionFactory::getConnection("default");
            $connection->connect();
            
            $command = $this->createSearchCommand($zip, $pref, $city);
            $command->setConnection($connection);
            $queryResult = $command->executeQuery();
            
            $connection->disconnect();
        }
        catch(Exception $ex){
            $connection->disconnect();
            throw $ex;     
        }
       $result = array("data" => $queryResult,"count" => count($queryResult));
       return $result;
    }
    /**
     * @param unknown_type $zip
     * @param unknown_type $pref
     * @param unknown_type $city
     */
    private function createSearchCommand($zip,$pref,$city){
        $query = "select * from postaldata";
        $criteria = new CFW_Data_Criteria();
        if($zip != "" ){
            if(strlen($zip) == 7){
                $criteria->addWhereAnd(new CFW_Data_Criteria_ColumnValueCondition("zipcode7",$zip,CFW_Data_Criteria::OPERATOR_EQ));
            }
            else{
                $criteria->addWhereAnd(new CFW_Data_Criteria_ColumnValueCondition("zipcode7",$zip."%" ,CFW_Data_Criteria::OPERATOR_LIKE));
            }
        }
        if($pref != ""){
            $criteria->addWhereAnd(new CFW_Data_Criteria_ColumnValueCondition("pref",$pref."%" ,CFW_Data_Criteria::OPERATOR_LIKE));
        }    
        if($city != ""){
            $criteria->addWhereAnd(new CFW_Data_Criteria_ColumnValueCondition("city",$city."%" ,CFW_Data_Criteria::OPERATOR_LIKE));
        }
        $criteria->addOrderBy("id",CFW_Data_Criteria::DIRECTION_ASC);
        $criteria->setLimit(100); // 件数限定
        $criteria->assemble();    
        
        if ($criteria->getWhereExpression() != ""){
            $query .= " WHERE " . $criteria->getWhereExpression();
        }
        if ($criteria->getOrderByExpression() != ""){
            $query .= " ORDER BY " . $criteria->getOrderByExpression();
        }
        if ($criteria->getLimit() != 0){
            $query .= " LIMIT " . $criteria->getLimit();
        }
        
        $command = new CFW_Data_Command($query,$criteria->getParameters());
        return $command;        
    }
    
}