<?php
Zend_Loader::loadClass("CFW_Auth_ProviderFactory");
Zend_Loader::loadClass("CFW_Log_Level");

/**
 * ログ出力
 * @author okada
 * @package CFW_Log
 */
class CFW_Log_Logger{


	/**
	 * モジュール名称
	 * @var string
	 */
	public $moduleName;
	/**
	 * ログレベル
	 * @var integer
	 */
	public $logLevel;
	/**
	 * writer本体
	 * @var unknown_type
	 */
	public $writer;

	public function __construct(){
		$this->moduleName = "";
		$this->logLevel = CFW_Log_Level::CRITICAL;
		$this->writer = null;
	}
	/**
	 * 緊急事態
	 * @param string $methodName 呼び出し側のメソッド名
	 * @param string $message 出力するメッセージ
	 * @param object $user 今使っているであろうユーザー
	 * @return unknown_type
	 */
	public function emergency($methodName, $message, $user = null) {
		if($this->writer == null) return;
		$userId = $this->getUserId($user);
		if ($this->logLevel >= CFW_Log_Level::EMERGENCY) {
			$this->writer->write(CFW_Log_Level::EMERGENCY, $userId, $this->moduleName, $methodName, $message);
		}
	}
	/**
	 * 警報
	 * @param string $methodName 呼び出し側のメソッド名
	 * @param string $message 出力するメッセージ
	 * @param object $user 今使っているであろうユーザー
	 * @return unknown_type
	 */
	public function alert($methodName, $message, $user = null) {
		if($this->writer == null) return;
		$userId = $this->getUserId($user);
		if ($this->logLevel >= CFW_Log_Level::ALERT) {
			$this->writer->write(CFW_Log_Level::ALERT, $userId, $this->moduleName, $methodName, $message);
		}
	}
	/**
	 * 危機
	 * @param string $methodName 呼び出し側のメソッド名
	 * @param string $message 出力するメッセージ
	 * @param object $user 今使っているであろうユーザー
	 * @return unknown_type
	 */
	public function critical($methodName, $message, $user = null) {
		if($this->writer == null) return;
		$userId = $this->getUserId($user);
		if ($this->logLevel >= CFW_Log_Level::CRITICAL) {
			$this->writer->write(CFW_Log_Level::CRITICAL, $userId, $this->moduleName, $methodName, $message);
		}
	}
	/**
	 * エラー
	 * @param string $methodName 呼び出し側のメソッド名
	 * @param string $message 出力するメッセージ
	 * @param object $user 今使っているであろうユーザー
	 * @return unknown_type
	 */
	public function error($methodName, $message, $user = null) {
		if($this->writer == null) return;
		$userId = $this->getUserId($user);
		if ($this->logLevel >= CFW_Log_Level::ERROR) {
			$this->writer->write(CFW_Log_Level::ERROR, $userId, $this->moduleName, $methodName, $message);
		}
	}
	/**
	 * 警告
	 * @param string $methodName 呼び出し側のメソッド名
	 * @param string $message 出力するメッセージ
	 * @param object $user 今使っているであろうユーザー
	 * @return unknown_type
	 */
	public function warning($methodName, $message, $user = null) {
		if($this->writer == null) return;
		$userId = $this->getUserId($user);
		if ($this->logLevel >= CFW_Log_Level::WARNING) {
			$this->writer->write(CFW_Log_Level::WARNING, $userId, $this->moduleName, $methodName, $message);
		}
	}
	/**
	 * 注意
	 * @param string $methodName 呼び出し側のメソッド名
	 * @param string $message 出力するメッセージ
	 * @param object $user 今使っているであろうユーザー
	 * @return unknown_type
	 */
	public function notice($methodName, $message, $user = null) {
		if($this->writer == null) return;
		$userId = $this->getUserId($user);
		if ($this->logLevel >= CFW_Log_Level::NOTICE) {
			$this->writer->write(CFW_Log_Level::NOTICE, $userId, $this->moduleName, $methodName, $message);
		}
	}
	/**
	 * 情報
	 * @param string $methodName 呼び出し側のメソッド名
	 * @param string $message 出力するメッセージ
	 * @param object $user 今使っているであろうユーザー
	 * @return unknown_type
	 */
	public function info($methodName, $message, $user = null) {
		if($this->writer == null) return;
		$userId = $this->getUserId($user);
		if ($this->logLevel >= CFW_Log_Level::INFO) {
			$this->writer->write(CFW_Log_Level::INFO, $userId, $this->moduleName, $methodName, $message);
		}
	}
	/**
	 * デバック
	 * @param string $methodName 呼び出し側のメソッド名
	 * @param string $message 出力するメッセージ
	 * @param object $user 今使っているであろうユーザー
	 * @return unknown_type
	 */
	public function debug($methodName, $message, $user = null) {
		if($this->writer == null) return;
		$userId = $this->getUserId($user);
		if ($this->logLevel >= CFW_Log_Level::DEBUG) {
			$this->writer->write(CFW_Log_Level::DEBUG, $userId, $this->moduleName, $methodName, $message);
		}
	}
	/**
	 * 一般的なログ出力

	 * @param int $level 出力レベル
	 * @param string $methodName 呼び出し側のメソッド名
	 * @param unknown $object 出力するメッセージオブジェクト
	 * @param object $user 今使っているであろうユーザー
	 * @return unknown_type
	 */
	public function log($level, $methodName, $object, $user = null) {
		if($this->writer == null) return;
		$userId = $this->getUserId($user);
		if ($this->logLevel >= $level) {
			$message = "";
			if(is_string($object)){
				$message = $object;
			}
			else if(method_exists($object,"__toString")){
				$message = strval($object);
			}
			else{
				Zend_Loader::loadClass("CFW_Util_Dump");
				$message = CFW_Util_Dump::dump($object);
			}
			$this->writer->write($level, $userId, $this->moduleName, $methodName, $message);
		}
	}
	/**
	 * 現在のユーザーID
	 * @param $user
	 * @return unknown_type
	 */
	function getUserId($user) {
		if($user == null){
		    $provider = CFW_Auth_ProviderFactory::getProvider();
		    if($provider->isAuthenticated()){
		      $id = $provider->getIdentity();
		      return $id->name;
		    }
			return "";
		}
		if(is_string($user)) return $user;
		if($user instanceof CFW_Auth_IUser){	
			return $user->getId();
		}
		return "";
	}
}