<?php
/**
 * Date用
 * @author okada
 * @package CFW_FieldValidators
 */
class CFW_FieldValidators_Date extends CFW_FieldValidators_Abstract{
    /* (non-PHPdoc)
     * @see library/CFW/FieldValidators/CFW_FieldValidators_Abstract#validateRange($value)
     */
    public function validateRange( $value)
        {
        $this->message = "";
        $property = $this->property;

        $isInRange = CFW_Util_Date::isInRange($value,$property->minValue , $property->maxValue);
        if (!$isInRange)
        {
            $this->message = CFW_Template_SimpleFormatter::format2($this->messageResource->getString("ERROR_INVALID_RANGE"),$this->property->displayName,CFW_Util_Date::format( $this->property->minValue,$this->property->format ) ,CFW_Util_Date::format( $this->property->maxValue,$this->property->format ));
            return false;
        }
        return true;
    }
    public function validateType($value){
        if($value == null) return true;
        if($value instanceof DateTime){
            return true;
        }
        $dateValue = CFW_Util_Date::parse(strval( $value ));
        if($dateValue == null){
            $this->message = CFW_Template_SimpleFormatter::format2($this->messageResource->getString("ERROR_INVALID_FORMAT"),$this->property->displayName);
            return false;
        }
        return true;
    }
}