<?php
Zend_Loader::loadClass("CFW_FieldValidators_Int");
Zend_Loader::loadClass("CFW_FieldValidators_Short");
Zend_Loader::loadClass("CFW_FieldValidators_Byte");
Zend_Loader::loadClass("CFW_FieldValidators_Long");
Zend_Loader::loadClass("CFW_FieldValidators_Decimal");
Zend_Loader::loadClass("CFW_FieldValidators_Date");
Zend_Loader::loadClass("CFW_FieldValidators_String");
Zend_Loader::loadClass("CFW_FieldProperties_Abstract");
Zend_Loader::loadClass("CFW_MessageResource_Factory");
Zend_Loader::loadClass("CFW_Util_String");
Zend_Loader::loadClass("CFW_Util_Date");
Zend_Loader::loadClass("CFW_Util_Number");
Zend_Loader::loadClass("CFW_Template_SimpleFormatter");

/**
 * フィールド検証基本
 * @author okada
 * @package CFW_FieldValidators
 */
class CFW_FieldValidators_Abstract{
    /**
     * 検証結果が不正のとき表示するメッセージの元を格納するリソース
     * @var unknown_type
     */
    var $messageResource;
    /**
     * 対象フィールドのプロパティ
     * @var unknown_type
     */
    var $property;
    /**
     * 検証エラー時のメッセージ
     * @var unknown_type
     */
    var $message;

    /**
     * プロパティ指定構築
     * @param unknown_type $property
     * @return unknown_type
     */
    public function __construct($property)
    {
        $this->messageResource = CFW_MessageResource_Factory::getResource(array("common"));
        $this->property = $property;
        $this->message = "";

    }
    /**
     * インスタンス取得
     * @param unknown_type $property 検証するフィールドに対応するプロパティのタイプ
     * @return CFW_FieldValidators_Abstract 指定タイプに対応する適切な型のFieldProperty実装
     */
    public static function getInstance($property)
    {
        $propertyType = get_class($property);

        $validatorType = "CFW_FieldValidators_". self::buildSubclassName($propertyType);
        //ハンドラーインスタンス生成
        $validator = new $validatorType($property);
        //ハンドラーが処理する例外を設定
        $validator->property = $property;
        $validator->message = "";
        return $validator;
    }

    /// <summary>
    ///
    /// </summary>
    /// <param name="TargetClassName"></param>
    /// <returns>組み立てたFieldValidator実装のタイプ名</returns>
    /// <remarks>
    /// 以下のルールで名称生成<br />
    /// HogeProperty
    /// ->Propertyを切り取る
    /// ->Validatorを足す
    /// ->結果 = HogeValidator
    /// </remarks>
    /**
     * (helper)プロパティのタイプ名称からFieldValidator実装のタイプ名を組み立てる.
     * HogeProperty
     * ->Propertyを切り取る
     * ->Validatorを足す
     * ->結果 = HogeValidator
     *
     * @param unknown_type $targetClassName プロパティのタイプ名
     * @return Ambigous <>
     */
    private static function buildSubclassName($targetClassName){
        $subclassName = "";
        $elements = split("_",$targetClassName);
        return $elements[count($elements) - 1];
    }
    /// <summary>
    ///
    /// </summary>
    /// <param name="aValue"></param>
    /// <returns></returns>
    /// <remarks>
    /// </remarks>
    /**
     * 検証ロジックの定義.
     * 以下のロジックを実行する。<br />
     *  1) 必須チェック<br />
     *  2) 型チェック<br />
     *  3) 長さチェック<br />
     *  4) 範囲チェック<br />
     *  5) フォーマットチェック<br />
     *  個々の具象クラスがそれぞれの内容を定義すること。
     *
     * @param $value 検証対象
     * @return unknown_type 検証に成功したときtrue
     */
    public function validate($value)
    {
        $this->message = "";
        if ($this->property->ignoreValidation) return true;
        if (!$this->property->nullable)
        {
            if (!$this->validateRequired($value))
            {
                return false;
            }
        }
        //null、空文字なら以下を検査しても意味がない。
        //nullable=falseで値がnullならValidateRequiredでひっかかる
        if ($value == null) return true;
        if(is_string($value)){
            if (CFW_Util_String::NormalizeString(strval( $value ),CFW_Util_String::NORMALIZE_TRIM_ALL) == "") return true;
        }
        if (!$this->validateType($value))
        {
            return false;
        }

        if (!$this->validateLength($value))
        {
            return false;
        }
        if (!$this->validateRange($value))
        {
            return false;
        }
        if (!$this->validateFormat($value))
        {
            return false;
        }
        return true;

    }
    /**
     * 必須チェック
     * @param unknown_type $value 対象値
     * @return boolean validならtrue
     */
    public function validateRequired($value)
    {
        $this->message = "";
        if ($value == null)
        {
            $this->message = CFW_Template_SimpleFormatter::format2($this->messageResource->getString("ERROR_REQUIRED_MISSING"),$this->property->displayName);
            return false;
        }
        if (CFW_Util_String::NormalizeString(strval( $value ),CFW_Util_String::NORMALIZE_TRIM_ALL) == "")
        {
            $this->message = CFW_Template_SimpleFormatter::format2($this->messageResource->getString("ERROR_REQUIRED_MISSING"),$this->property->displayName);
            return false;
        }

        //数値型0はinvalid
        if (($this->property->fieldType == "byte")
            || ($this->property->fieldType == "short")
            || ($this->property->fieldType == "int")
            || ($this->property->fieldType == "long")
            || ($this->property->fieldType == "float")
            || ($this->property->fieldType == "double")
            || ($this->property->fieldType == "decimal")
            )
        {
            if (!$this->property->allowZero)
            {
                $d = CFW_Util_Number::toNumber($value);
                if ($d == 0)
                {
                    $this->message = CFW_Template_SimpleFormatter::format2($this->messageResource->getString("ERROR_REQUIRED_MISSING"),$this->property->displayName);
                    return false;
                }
            }
        }
        return true;
    }
    /**
     * タイプチェック
     * @param unknown_type $value 対象値
     * @return bool
     */
    public function validateType($value)
    {
        $this->message = "";
        return true;
    }
    /**
     * 範囲チェック
     * @param unknown_type $value 対象値
     * @return bool validならtrue
     */
    public function validateRange($value)
    {
        $this->message = "";
        return true;
    }
    /**
     * 長さチェック
     * @param unknown_type $value 対象値
     * @return string validならtrue
     */
    public function validateLength($value)
    {
        $this->message = "";
        return true;
    }
    /**
     * フォーマットチェック
     * @param unknown_type $value 対象値
     * @return string validならtrue
     */
    public function validateFormat($value)
    {
        $this->message = "";
        return true;
    }

}
