<?php
include( "../core.php" );

/**
 * 再帰下降型
 * Tokenizerを使う
 * @author okada
 *
 */

class Parser{
    var $result;
    var $tokenizer;
    var $currentToken ;
    function __construct(){
    }
    public function parse($s){
        $this->tokenizer = new CFW_Common_Tokenizer(new CFW_IO_StringReader( $s ));
        $this->currentToken = $this->tokenizer->nextToken();
        $this->result = $this->equation();
        
    }
    
    function equation() {
        $result = $this->factor(); //最初のfactor
        
      while ($this->currentToken == '+') {
        $this->currentToken = $this->tokenizer->nextToken();
          
        $r_ = $this->factor();
        $result += $r_;
      }
      return $result;
    }
    
    function factor() {
        $result = $this->term(); //最初のterm
        while ($this->currentToken == '*') {
            $this->currentToken = $this->tokenizer->nextToken();

            $r_ = $this->term();
            $result *= $r_;
            
        }
        return $result;
    }
    function term() {
        if ($this->currentToken  == '(') {
            $this->currentToken = $this->tokenizer->nextToken();
            $r = $this->equation();
            $this->currentToken = $this->tokenizer->nextToken(); //skip last ")"
            return $r;
        }
        else{
            $value = 0;
            $n = intval($this->currentToken);
            $value = $n;
            $this->currentToken = $this->tokenizer->nextToken(); //skip last ")"
            
            return $value;
        }
    }
    
}

$parser = new Parser();
$parser->parse("1 + 2 * 3 + 4 * 5");
echo "-----<br />";
echo "result = " . $parser->result. "<br />";
echo "-----<br />";
$parser->parse("2 * (3 + 4) + 11"); // = 25
echo "-----<br />";
echo "result = " . $parser->result. "<br />";

?>