<?php 
Zend_Loader::loadClass("CFW_Models_Entity");

/**
* table MAST_SITE Field定義
*/
class CFW_Sample_Models_Base_MastSiteTableRow extends CFW_Models_Entity
{
    /** 
    * @var String siteCode [SITE_CODE]
    */
    public $siteCode;
    /** 
    * @var String openDate [OPEN_DATE]
    */
    public $openDate;
    /** 
    * @var String closeDate [CLOSE_DATE]
    */
    public $closeDate;
    /** 
    * @var Number sortSeq [SORT_SEQ]
    */
    public $sortSeq;
    /** 
    * @var String name [NAME]
    */
    public $name;
    /** 
    * @var String ankName [ANK_NAME]
    */
    public $ankName;
    /** 
    * @var String companyCode [COMPANY_CODE]
    */
    public $companyCode;
    /** 
    * @var String siteUrl [SITE_URL]
    */
    public $siteUrl;
    /** 
    * @var String siteUrlOther [SITE_URL_OTHER]
    */
    public $siteUrlOther;
    /** 
    * @var Number siteCategory1 [SITE_CATEGORY1]
    */
    public $siteCategory1;
    /** 
    * @var Number siteCategory2 [SITE_CATEGORY2]
    */
    public $siteCategory2;
    /** 
    * @var Number deviceCode [DEVICE_CODE]
    */
    public $deviceCode;
    /** 
    * @var Number menuDeviceCode [MENU_DEVICE_CODE]
    */
    public $menuDeviceCode;
    /** 
    * @var Number menuAdtypeCode [MENU_ADTYPE_CODE]
    */
    public $menuAdtypeCode;
    /** 
    * @var Number goodsCategoryCode [GOODS_CATEGORY_CODE]
    */
    public $goodsCategoryCode;
    /** 
    * @var Number carrierCode1 [CARRIER_CODE1]
    */
    public $carrierCode1;
    /** 
    * @var Number carrierCode2 [CARRIER_CODE2]
    */
    public $carrierCode2;
    /** 
    * @var Number carrierCode3 [CARRIER_CODE3]
    */
    public $carrierCode3;
    /** 
    * @var Number carrierCode4 [CARRIER_CODE4]
    */
    public $carrierCode4;
    /** 
    * @var Number mediaCostRate [MEDIA_COST_RATE]
    */
    public $mediaCostRate;
    /** 
    * @var Number agencyMarginRate [AGENCY_MARGIN_RATE]
    */
    public $agencyMarginRate;
    /** 
    * @var Number spOpenFlag [SP_OPEN_FLAG]
    */
    public $spOpenFlag;
    /** 
    * @var Number pmOpenFlag [PM_OPEN_FLAG]
    */
    public $pmOpenFlag;
    /** 
    * @var Number ioOpenFlag [IO_OPEN_FLAG]
    */
    public $ioOpenFlag;
    /** 
    * @var Number adGuideOpenFlag [AD_GUIDE_OPEN_FLAG]
    */
    public $adGuideOpenFlag;
    /** 
    * @var Number impression [IMPRESSION]
    */
    public $impression;
    /** 
    * @var Number impressionTerm [IMPRESSION_TERM]
    */
    public $impressionTerm;
    /** 
    * @var Number impressionToppage [IMPRESSION_TOPPAGE]
    */
    public $impressionToppage;
    /** 
    * @var Number impressionToppageTerm [IMPRESSION_TOPPAGE_TERM]
    */
    public $impressionToppageTerm;
    /** 
    * @var Number uniqueUser [UNIQUE_USER]
    */
    public $uniqueUser;
    /** 
    * @var Number uniqueUserTerm [UNIQUE_USER_TERM]
    */
    public $uniqueUserTerm;
    /** 
    * @var Number uniqueUserToppage [UNIQUE_USER_TOPPAGE]
    */
    public $uniqueUserToppage;
    /** 
    * @var Number uniqueUserToppageTerm [UNIQUE_USER_TOPPAGE_TERM]
    */
    public $uniqueUserToppageTerm;
    /** 
    * @var Number maleRate [MALE_RATE]
    */
    public $maleRate;
    /** 
    * @var Number femaleRate [FEMALE_RATE]
    */
    public $femaleRate;
    /** 
    * @var Number publishedYear [PUBLISHED_YEAR]
    */
    public $publishedYear;
    /** 
    * @var Number publishedMonth [PUBLISHED_MONTH]
    */
    public $publishedMonth;
    /** 
    * @var Number publishedDay [PUBLISHED_DAY]
    */
    public $publishedDay;
    /** 
    * @var Number publishedDataKind [PUBLISHED_DATA_KIND]
    */
    public $publishedDataKind;
    /** 
    * @var String upperSiteCode [UPPER_SITE_CODE]
    */
    public $upperSiteCode;
    /** 
    * @var String paymentCompany [PAYMENT_COMPANY]
    */
    public $paymentCompany;
    /** 
    * @var Number businessDirectFlag [BUSINESS_DIRECT_FLAG]
    */
    public $businessDirectFlag;
    /** 
    * @var Number adserverFlag [ADSERVER_FLAG]
    */
    public $adserverFlag;
    /** 
    * @var Number specialmenuFlag [SPECIALMENU_FLAG]
    */
    public $specialmenuFlag;
    /** 
    * @var Number topOpenFlag [TOP_OPEN_FLAG]
    */
    public $topOpenFlag;
    /** 
    * @var Number openMenuCount [OPEN_MENU_COUNT]
    */
    public $openMenuCount;
    /** 
    * @var String makeDate [MAKE_DATE]
    */
    public $makeDate;
    /** 
    * @var String documentAddress [DOCUMENT_ADDRESS]
    */
    public $documentAddress;
    /** 
    * @var String agCompanyCode [AG_COMPANY_CODE]
    */
    public $agCompanyCode;
    /** 
    * @var Number insideOpenLevel [INSIDE_OPEN_LEVEL]
    */
    public $insideOpenLevel;
    /** 
    * @var Number outsideOpenLevel [OUTSIDE_OPEN_LEVEL]
    */
    public $outsideOpenLevel;
    /** 
    * @var Number homeRate [HOME_RATE]
    */
    public $homeRate;
    /** 
    * @var Number workRate [WORK_RATE]
    */
    public $workRate;
    /** 
    * @var Number overlapRate [OVERLAP_RATE]
    */
    public $overlapRate;
    /** 
    * @var Number businessRepDirectFlag [BUSINESS_REP_DIRECT_FLAG]
    */
    public $businessRepDirectFlag;
    /** 
    * @var Number clientSiteFlag [CLIENT_SITE_FLAG]
    */
    public $clientSiteFlag;
    /** 
    * @var String printUpperSiteCode [PRINT_UPPER_SITE_CODE]
    */
    public $printUpperSiteCode;
    /** 
    * @var Number teamCode [TEAM_CODE]
    */
    public $teamCode;
    /** 
    * @var String checkName [CHECK_NAME]
    */
    public $checkName;
    /** 
    * @var String priceCostFromDate [PRICE_COST_FROM_DATE]
    */
    public $priceCostFromDate;
    /** 
    * @var Number validFlag [VALID_FLAG]
    */
    public $validFlag;
    /** 
    * @var Date insertDateTime [INSERT_DATE_TIME]
    */
    public $insertDateTime;
    /** 
    * @var String insertOperatorCode [INSERT_OPERATOR_CODE]
    */
    public $insertOperatorCode;
    /** 
    * @var Date updateDateTime [UPDATE_DATE_TIME]
    */
    public $updateDateTime;
    /** 
    * @var String operatorCode [OPERATOR_CODE]
    */
    public $operatorCode;
    
    /**
    * default construct 
    */
    public function __construct()
    {
        parent::__construct();
        $this->siteCode = "";
        $this->openDate = "";
        $this->closeDate = "";
        $this->sortSeq = null;
        $this->name = "";
        $this->ankName = "";
        $this->companyCode = "";
        $this->siteUrl = "";
        $this->siteUrlOther = "";
        $this->siteCategory1 = null;
        $this->siteCategory2 = null;
        $this->deviceCode = 0;
        $this->menuDeviceCode = null;
        $this->menuAdtypeCode = null;
        $this->goodsCategoryCode = null;
        $this->carrierCode1 = null;
        $this->carrierCode2 = null;
        $this->carrierCode3 = null;
        $this->carrierCode4 = null;
        $this->mediaCostRate = null;
        $this->agencyMarginRate = null;
        $this->spOpenFlag = null;
        $this->pmOpenFlag = null;
        $this->ioOpenFlag = null;
        $this->adGuideOpenFlag = null;
        $this->impression = null;
        $this->impressionTerm = null;
        $this->impressionToppage = null;
        $this->impressionToppageTerm = null;
        $this->uniqueUser = null;
        $this->uniqueUserTerm = null;
        $this->uniqueUserToppage = null;
        $this->uniqueUserToppageTerm = null;
        $this->maleRate = null;
        $this->femaleRate = null;
        $this->publishedYear = null;
        $this->publishedMonth = null;
        $this->publishedDay = null;
        $this->publishedDataKind = null;
        $this->upperSiteCode = "";
        $this->paymentCompany = "";
        $this->businessDirectFlag = null;
        $this->adserverFlag = null;
        $this->specialmenuFlag = null;
        $this->topOpenFlag = null;
        $this->openMenuCount = null;
        $this->makeDate = "";
        $this->documentAddress = "";
        $this->agCompanyCode = "";
        $this->insideOpenLevel = null;
        $this->outsideOpenLevel = null;
        $this->homeRate = null;
        $this->workRate = null;
        $this->overlapRate = null;
        $this->businessRepDirectFlag = null;
        $this->clientSiteFlag = null;
        $this->printUpperSiteCode = "";
        $this->teamCode = null;
        $this->checkName = "";
        $this->priceCostFromDate = "";
        $this->validFlag = null;
        $this->insertDateTime = null;
        $this->insertOperatorCode = "";
        $this->updateDateTime = null;
        $this->operatorCode = "";
        
    }
    
    /**
    * 列名を指定して値を設定
    *
    * @param string name 列名
    * @param object value 値
    */
    public function setValue($name,$value)
    {
        if($name ==  "SITE_CODE") $this->siteCode = CFW_Util_String::stringValue( $value );
        if($name ==  "OPEN_DATE") $this->openDate = CFW_Util_String::stringValue( $value );
        if($name ==  "CLOSE_DATE") $this->closeDate = CFW_Util_String::stringValue( $value );
        if($name ==  "SORT_SEQ") $this->sortSeq = CFW_Util_Number::numberValue( $value );
        if($name ==  "NAME") $this->name = CFW_Util_String::stringValue( $value );
        if($name ==  "ANK_NAME") $this->ankName = CFW_Util_String::stringValue( $value );
        if($name ==  "COMPANY_CODE") $this->companyCode = CFW_Util_String::stringValue( $value );
        if($name ==  "SITE_URL") $this->siteUrl = CFW_Util_String::stringValue( $value );
        if($name ==  "SITE_URL_OTHER") $this->siteUrlOther = CFW_Util_String::stringValue( $value );
        if($name ==  "SITE_CATEGORY1") $this->siteCategory1 = CFW_Util_Number::numberValue( $value );
        if($name ==  "SITE_CATEGORY2") $this->siteCategory2 = CFW_Util_Number::numberValue( $value );
        if($name ==  "DEVICE_CODE") $this->deviceCode = CFW_Util_Number::numberValue( $value );
        if($name ==  "MENU_DEVICE_CODE") $this->menuDeviceCode = CFW_Util_Number::numberValue( $value );
        if($name ==  "MENU_ADTYPE_CODE") $this->menuAdtypeCode = CFW_Util_Number::numberValue( $value );
        if($name ==  "GOODS_CATEGORY_CODE") $this->goodsCategoryCode = CFW_Util_Number::numberValue( $value );
        if($name ==  "CARRIER_CODE1") $this->carrierCode1 = CFW_Util_Number::numberValue( $value );
        if($name ==  "CARRIER_CODE2") $this->carrierCode2 = CFW_Util_Number::numberValue( $value );
        if($name ==  "CARRIER_CODE3") $this->carrierCode3 = CFW_Util_Number::numberValue( $value );
        if($name ==  "CARRIER_CODE4") $this->carrierCode4 = CFW_Util_Number::numberValue( $value );
        if($name ==  "MEDIA_COST_RATE") $this->mediaCostRate = CFW_Util_Number::numberValue( $value );
        if($name ==  "AGENCY_MARGIN_RATE") $this->agencyMarginRate = CFW_Util_Number::numberValue( $value );
        if($name ==  "SP_OPEN_FLAG") $this->spOpenFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "PM_OPEN_FLAG") $this->pmOpenFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "IO_OPEN_FLAG") $this->ioOpenFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "AD_GUIDE_OPEN_FLAG") $this->adGuideOpenFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "IMPRESSION") $this->impression = CFW_Util_Number::numberValue( $value );
        if($name ==  "IMPRESSION_TERM") $this->impressionTerm = CFW_Util_Number::numberValue( $value );
        if($name ==  "IMPRESSION_TOPPAGE") $this->impressionToppage = CFW_Util_Number::numberValue( $value );
        if($name ==  "IMPRESSION_TOPPAGE_TERM") $this->impressionToppageTerm = CFW_Util_Number::numberValue( $value );
        if($name ==  "UNIQUE_USER") $this->uniqueUser = CFW_Util_Number::numberValue( $value );
        if($name ==  "UNIQUE_USER_TERM") $this->uniqueUserTerm = CFW_Util_Number::numberValue( $value );
        if($name ==  "UNIQUE_USER_TOPPAGE") $this->uniqueUserToppage = CFW_Util_Number::numberValue( $value );
        if($name ==  "UNIQUE_USER_TOPPAGE_TERM") $this->uniqueUserToppageTerm = CFW_Util_Number::numberValue( $value );
        if($name ==  "MALE_RATE") $this->maleRate = CFW_Util_Number::numberValue( $value );
        if($name ==  "FEMALE_RATE") $this->femaleRate = CFW_Util_Number::numberValue( $value );
        if($name ==  "PUBLISHED_YEAR") $this->publishedYear = CFW_Util_Number::numberValue( $value );
        if($name ==  "PUBLISHED_MONTH") $this->publishedMonth = CFW_Util_Number::numberValue( $value );
        if($name ==  "PUBLISHED_DAY") $this->publishedDay = CFW_Util_Number::numberValue( $value );
        if($name ==  "PUBLISHED_DATA_KIND") $this->publishedDataKind = CFW_Util_Number::numberValue( $value );
        if($name ==  "UPPER_SITE_CODE") $this->upperSiteCode = CFW_Util_String::stringValue( $value );
        if($name ==  "PAYMENT_COMPANY") $this->paymentCompany = CFW_Util_String::stringValue( $value );
        if($name ==  "BUSINESS_DIRECT_FLAG") $this->businessDirectFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "ADSERVER_FLAG") $this->adserverFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "SPECIALMENU_FLAG") $this->specialmenuFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "TOP_OPEN_FLAG") $this->topOpenFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "OPEN_MENU_COUNT") $this->openMenuCount = CFW_Util_Number::numberValue( $value );
        if($name ==  "MAKE_DATE") $this->makeDate = CFW_Util_String::stringValue( $value );
        if($name ==  "DOCUMENT_ADDRESS") $this->documentAddress = CFW_Util_String::stringValue( $value );
        if($name ==  "AG_COMPANY_CODE") $this->agCompanyCode = CFW_Util_String::stringValue( $value );
        if($name ==  "INSIDE_OPEN_LEVEL") $this->insideOpenLevel = CFW_Util_Number::numberValue( $value );
        if($name ==  "OUTSIDE_OPEN_LEVEL") $this->outsideOpenLevel = CFW_Util_Number::numberValue( $value );
        if($name ==  "HOME_RATE") $this->homeRate = CFW_Util_Number::numberValue( $value );
        if($name ==  "WORK_RATE") $this->workRate = CFW_Util_Number::numberValue( $value );
        if($name ==  "OVERLAP_RATE") $this->overlapRate = CFW_Util_Number::numberValue( $value );
        if($name ==  "BUSINESS_REP_DIRECT_FLAG") $this->businessRepDirectFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "CLIENT_SITE_FLAG") $this->clientSiteFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "PRINT_UPPER_SITE_CODE") $this->printUpperSiteCode = CFW_Util_String::stringValue( $value );
        if($name ==  "TEAM_CODE") $this->teamCode = CFW_Util_Number::numberValue( $value );
        if($name ==  "CHECK_NAME") $this->checkName = CFW_Util_String::stringValue( $value );
        if($name ==  "PRICE_COST_FROM_DATE") $this->priceCostFromDate = CFW_Util_String::stringValue( $value );
        if($name ==  "VALID_FLAG") $this->validFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "INSERT_DATE_TIME") $this->insertDateTime = CFW_Util_Date::dateValue( $value );
        if($name ==  "INSERT_OPERATOR_CODE") $this->insertOperatorCode = CFW_Util_String::stringValue( $value );
        if($name ==  "UPDATE_DATE_TIME") $this->updateDateTime = CFW_Util_Date::dateValue( $value );
        if($name ==  "OPERATOR_CODE") $this->operatorCode = CFW_Util_String::stringValue( $value );
        
    }
    /// <summary>
    /// 列名を指定して値を取得
    /// </summary>
    /// <param name="name">列名</param>
    /**
    * 列名を指定して値を取得
    *
    * @param string name 列名
    * @return object 値
    */
    public function getValue($name)
    {
        if($name ==  "SITE_CODE") return $this->siteCode;
        if($name ==  "OPEN_DATE") return $this->openDate;
        if($name ==  "CLOSE_DATE") return $this->closeDate;
        if($name ==  "SORT_SEQ") return $this->sortSeq;
        if($name ==  "NAME") return $this->name;
        if($name ==  "ANK_NAME") return $this->ankName;
        if($name ==  "COMPANY_CODE") return $this->companyCode;
        if($name ==  "SITE_URL") return $this->siteUrl;
        if($name ==  "SITE_URL_OTHER") return $this->siteUrlOther;
        if($name ==  "SITE_CATEGORY1") return $this->siteCategory1;
        if($name ==  "SITE_CATEGORY2") return $this->siteCategory2;
        if($name ==  "DEVICE_CODE") return $this->deviceCode;
        if($name ==  "MENU_DEVICE_CODE") return $this->menuDeviceCode;
        if($name ==  "MENU_ADTYPE_CODE") return $this->menuAdtypeCode;
        if($name ==  "GOODS_CATEGORY_CODE") return $this->goodsCategoryCode;
        if($name ==  "CARRIER_CODE1") return $this->carrierCode1;
        if($name ==  "CARRIER_CODE2") return $this->carrierCode2;
        if($name ==  "CARRIER_CODE3") return $this->carrierCode3;
        if($name ==  "CARRIER_CODE4") return $this->carrierCode4;
        if($name ==  "MEDIA_COST_RATE") return $this->mediaCostRate;
        if($name ==  "AGENCY_MARGIN_RATE") return $this->agencyMarginRate;
        if($name ==  "SP_OPEN_FLAG") return $this->spOpenFlag;
        if($name ==  "PM_OPEN_FLAG") return $this->pmOpenFlag;
        if($name ==  "IO_OPEN_FLAG") return $this->ioOpenFlag;
        if($name ==  "AD_GUIDE_OPEN_FLAG") return $this->adGuideOpenFlag;
        if($name ==  "IMPRESSION") return $this->impression;
        if($name ==  "IMPRESSION_TERM") return $this->impressionTerm;
        if($name ==  "IMPRESSION_TOPPAGE") return $this->impressionToppage;
        if($name ==  "IMPRESSION_TOPPAGE_TERM") return $this->impressionToppageTerm;
        if($name ==  "UNIQUE_USER") return $this->uniqueUser;
        if($name ==  "UNIQUE_USER_TERM") return $this->uniqueUserTerm;
        if($name ==  "UNIQUE_USER_TOPPAGE") return $this->uniqueUserToppage;
        if($name ==  "UNIQUE_USER_TOPPAGE_TERM") return $this->uniqueUserToppageTerm;
        if($name ==  "MALE_RATE") return $this->maleRate;
        if($name ==  "FEMALE_RATE") return $this->femaleRate;
        if($name ==  "PUBLISHED_YEAR") return $this->publishedYear;
        if($name ==  "PUBLISHED_MONTH") return $this->publishedMonth;
        if($name ==  "PUBLISHED_DAY") return $this->publishedDay;
        if($name ==  "PUBLISHED_DATA_KIND") return $this->publishedDataKind;
        if($name ==  "UPPER_SITE_CODE") return $this->upperSiteCode;
        if($name ==  "PAYMENT_COMPANY") return $this->paymentCompany;
        if($name ==  "BUSINESS_DIRECT_FLAG") return $this->businessDirectFlag;
        if($name ==  "ADSERVER_FLAG") return $this->adserverFlag;
        if($name ==  "SPECIALMENU_FLAG") return $this->specialmenuFlag;
        if($name ==  "TOP_OPEN_FLAG") return $this->topOpenFlag;
        if($name ==  "OPEN_MENU_COUNT") return $this->openMenuCount;
        if($name ==  "MAKE_DATE") return $this->makeDate;
        if($name ==  "DOCUMENT_ADDRESS") return $this->documentAddress;
        if($name ==  "AG_COMPANY_CODE") return $this->agCompanyCode;
        if($name ==  "INSIDE_OPEN_LEVEL") return $this->insideOpenLevel;
        if($name ==  "OUTSIDE_OPEN_LEVEL") return $this->outsideOpenLevel;
        if($name ==  "HOME_RATE") return $this->homeRate;
        if($name ==  "WORK_RATE") return $this->workRate;
        if($name ==  "OVERLAP_RATE") return $this->overlapRate;
        if($name ==  "BUSINESS_REP_DIRECT_FLAG") return $this->businessRepDirectFlag;
        if($name ==  "CLIENT_SITE_FLAG") return $this->clientSiteFlag;
        if($name ==  "PRINT_UPPER_SITE_CODE") return $this->printUpperSiteCode;
        if($name ==  "TEAM_CODE") return $this->teamCode;
        if($name ==  "CHECK_NAME") return $this->checkName;
        if($name ==  "PRICE_COST_FROM_DATE") return $this->priceCostFromDate;
        if($name ==  "VALID_FLAG") return $this->validFlag;
        if($name ==  "INSERT_DATE_TIME") return $this->insertDateTime;
        if($name ==  "INSERT_OPERATOR_CODE") return $this->insertOperatorCode;
        if($name ==  "UPDATE_DATE_TIME") return $this->updateDateTime;
        if($name ==  "OPERATOR_CODE") return $this->operatorCode;
        
        return null;
    }
    
    /**
    * 指定データからのコピー
    * @param MastSiteTableRow コピー元
    * @return none
    */
    public function copyFrom($source)
    {
        $this->siteCode = $source->siteCode;
        $this->openDate = $source->openDate;
        $this->closeDate = $source->closeDate;
        $this->sortSeq = $source->sortSeq;
        $this->name = $source->name;
        $this->ankName = $source->ankName;
        $this->companyCode = $source->companyCode;
        $this->siteUrl = $source->siteUrl;
        $this->siteUrlOther = $source->siteUrlOther;
        $this->siteCategory1 = $source->siteCategory1;
        $this->siteCategory2 = $source->siteCategory2;
        $this->deviceCode = $source->deviceCode;
        $this->menuDeviceCode = $source->menuDeviceCode;
        $this->menuAdtypeCode = $source->menuAdtypeCode;
        $this->goodsCategoryCode = $source->goodsCategoryCode;
        $this->carrierCode1 = $source->carrierCode1;
        $this->carrierCode2 = $source->carrierCode2;
        $this->carrierCode3 = $source->carrierCode3;
        $this->carrierCode4 = $source->carrierCode4;
        $this->mediaCostRate = $source->mediaCostRate;
        $this->agencyMarginRate = $source->agencyMarginRate;
        $this->spOpenFlag = $source->spOpenFlag;
        $this->pmOpenFlag = $source->pmOpenFlag;
        $this->ioOpenFlag = $source->ioOpenFlag;
        $this->adGuideOpenFlag = $source->adGuideOpenFlag;
        $this->impression = $source->impression;
        $this->impressionTerm = $source->impressionTerm;
        $this->impressionToppage = $source->impressionToppage;
        $this->impressionToppageTerm = $source->impressionToppageTerm;
        $this->uniqueUser = $source->uniqueUser;
        $this->uniqueUserTerm = $source->uniqueUserTerm;
        $this->uniqueUserToppage = $source->uniqueUserToppage;
        $this->uniqueUserToppageTerm = $source->uniqueUserToppageTerm;
        $this->maleRate = $source->maleRate;
        $this->femaleRate = $source->femaleRate;
        $this->publishedYear = $source->publishedYear;
        $this->publishedMonth = $source->publishedMonth;
        $this->publishedDay = $source->publishedDay;
        $this->publishedDataKind = $source->publishedDataKind;
        $this->upperSiteCode = $source->upperSiteCode;
        $this->paymentCompany = $source->paymentCompany;
        $this->businessDirectFlag = $source->businessDirectFlag;
        $this->adserverFlag = $source->adserverFlag;
        $this->specialmenuFlag = $source->specialmenuFlag;
        $this->topOpenFlag = $source->topOpenFlag;
        $this->openMenuCount = $source->openMenuCount;
        $this->makeDate = $source->makeDate;
        $this->documentAddress = $source->documentAddress;
        $this->agCompanyCode = $source->agCompanyCode;
        $this->insideOpenLevel = $source->insideOpenLevel;
        $this->outsideOpenLevel = $source->outsideOpenLevel;
        $this->homeRate = $source->homeRate;
        $this->workRate = $source->workRate;
        $this->overlapRate = $source->overlapRate;
        $this->businessRepDirectFlag = $source->businessRepDirectFlag;
        $this->clientSiteFlag = $source->clientSiteFlag;
        $this->printUpperSiteCode = $source->printUpperSiteCode;
        $this->teamCode = $source->teamCode;
        $this->checkName = $source->checkName;
        $this->priceCostFromDate = $source->priceCostFromDate;
        $this->validFlag = $source->validFlag;
        $this->insertDateTime = $source->insertDateTime;
        $this->insertOperatorCode = $source->insertOperatorCode;
        $this->updateDateTime = $source->updateDateTime;
        $this->operatorCode = $source->operatorCode;
        
    }
}
