<?php 
Zend_Loader::loadClass("CFW_Models_Entity");

/**
* table auth_users Field定義
*/
class CFW_Sample_Models_Base_AuthUsersTableRow extends CFW_Models_Entity
{
    /** 
    * @var String loginId [login_id]
    */
    public $loginId;
    /** 
    * @var String name [name]
    */
    public $name;
    /** 
    * @var String password [password]
    */
    public $password;
    /** 
    * @var String description [description]
    */
    public $description;
    
    /**
    * default construct 
    */
    public function __construct()
    {
    	parent::__construct();
        $this->loginId = "";
        $this->name = "";
        $this->password = "";
        $this->description = "";
        
    }
    
    /**
    * 列名を指定して値を設宁E
    *
    * @param string name 列名
    * @param object value 値
    */
    public function setValue($name,$value)
    {
        if($name ==  "login_id") $this->loginId = CFW_Util_String::stringValue( $value );
        if($name ==  "name") $this->name = CFW_Util_String::stringValue( $value );
        if($name ==  "password") $this->password = CFW_Util_String::stringValue( $value );
        if($name ==  "description") $this->description = CFW_Util_String::stringValue( $value );
        
    }
    /// <summary>
    /// 列名を指定して値を取征E
    /// </summary>
    /// <param name="name">列名</param>
    /**
    * 列名を指定して値を取征E
    *
    * @param string name 列名
    * @return object 値
    */
    public function getValue($name)
    {
        if($name ==  "login_id") return $this->loginId;
        if($name ==  "name") return $this->name;
        if($name ==  "password") return $this->password;
        if($name ==  "description") return $this->description;
        
        return null;
    }
    
    /**
    * 持EデータからのコピE
    * @param AuthUsersTableRow コピE允E
    * @return none
    */
    public function copyFrom($source)
    {
        $this->loginId = $source->loginId;
        $this->name = $source->name;
        $this->password = $source->password;
        $this->description = $source->description;
        
    }
}
