<?php
/**
 * メールメッセージクラス
 *
 * メール送信、受信のためのメッセージ
 * @author okada
 * @package CFW_Mail
 */
class CFW_Mail_Message{
	/**
	 * 差出人
	 * @var array $from
	 */
	var $from;
	/**
	 * 宛先
	 * @var array $to
	 */
	var $to;
	/**
	 * カーボンコピー
	 * @var array $cc
	 */
	var $cc;
	/**
	 * ブラインドカーボンコピー
	 * @var array  $bcc
	 */
	var $bcc;
	/**
	 * 返信先
	 * @var array $replyTo
	 */
	var $replyTo;
	/**
	 * 送信者
	 * @var array $sender
	 */
	var $sender;
	/**
	 * 件名
	 * @var String $subject
	 */
	var $subject;
	/**
	 * 本文
	 * @var String $body
	 */
	var $body;
	/**
	 * 添付ファイル
	 * @var array $files
	 */
	var $files;
	/**
	 *
	 * @return unknown_type
	 */
	public function __construct(){
		$this->from = array();
		$this->to = array();
		$this->cc = array();
		$this->bcc = array();
		$this->replyTo = array();
		$this->sender = array();
		$this->subject = "";
		$this->body = "";
		$this->files = array();
	}
	/**
	 * アドレスを追加する
	 * @param Common_Mail_Address $addr 追加するアドレス表現
	 * @return unknown_type
	 */
	public function addFrom($addr){
		$this->from[] = $addr;
	}
	/**
	 * アドレスを追加する
	 * @param Common_Mail_Address $addr 追加するアドレス表現
	 * @return unknown_type
	 */
	public function addTo($addr){
		$this->to[] = $addr;
	}
	/**
	 * アドレスを追加する
	 * @param Common_Mail_Address $addr 追加するアドレス表現
	 * @return unknown_type
	 */
	public function addCc($addr){
		$this->cc[] = $addr;
	}
	/**
	 * アドレスを追加する
	 * @param Common_Mail_Address $addr 追加するアドレス表現
	 * @return unknown_type
	 */
	public function addBcc($addr){
		$this->bcc[] = $addr;
	}
	/**
	 * アドレスを追加する
	 * @param Common_Mail_Address $addr 追加するアドレス表現
	 * @return unknown_type
	 */
	public function addReplyTo($addr){
		$this->replyTo[] = $addr;
	}
	/**
	 * アドレスを追加する
	 * @param Common_Mail_Address $addr 追加するアドレス表現
	 * @return unknown_type
	 */
	public function addSender($addr){
		$this->sender[] = $addr;
	}
	/**
	 * 件名を設定する
	 * @param String $subj 設定する件名
	 * @return unknown_type
	 */
	public function setSubject($subj){
		$this->subject = $subj;
	}
	/**
	 * 本文を設定する
	 * @param String $body 設定する本文
	 * @return unknown_type
	 */
	public function setBody($body){
		$this->body = $body;
	}
	/**
	 * 添付ファイルを追加する
	 *
	 * @param String $file 追加するファイル名
	 * @return unknown_type
	 */
	public function addFile($file){
		$this->files[] = $file;
	}

}
?>