<?php
Zend_Loader::loadClass("CFW_Error_Handler");

/**
 * ErrorHandler1を生成する
 * <p>発生した例外の型により、対応するErrorHandlerを作る。</p>
 * @author okada
 * @package CFW_Error
 */
class CFW_Error_HandlerFactory{
    var $ex;
    var $depth;
    var $errorId = "";
    var $file = "";
    var $class = "";
    var $function = "";
	var $user;
	var $backtrace = array();
    /**
     * 構築
     * @param unknown_type $ex
     * @param unknown_type $depth 呼び出しの深さ。
     * @param unknown_type $user = null 使用しているユーザー。通常は使用しない。
     * @return unknown_type
     */
    public function __construct($ex, $depth = 0,$user = null){
        $this->exception = $ex;
        $this->depth = $depth;
        $this->user = $user;
    }
    /**
     * ErrorHandlerを生成する。
     * @return CFW_Error_Handler
     */
    public function createHandler(){
        //trace情報から<del>エラーが起こった</del>エラーを拾った場所を得る
        $trace = $this->exception->getTrace();
        $trace0 = $trace[count($trace) - 1];
        if(array_key_exists("file",$trace0)){
        	$this->file = basename( $trace0["file"] );
        }
        if(array_key_exists("class",$trace0)){
            $this->class = $trace0["class"];
        }
        $this->function= $trace0["function"];
        $this->errorId = $this->generateId();
        $handler = new CFW_Error_Handler($this->exception,$this->file,$this->class,$this->function,$this->errorId);
        $handler->exception = $this->exception;
		$handler->user = $this->user;
        return $handler;
    }
    /**
     * 発生時のエラー追跡IDを生成する。
     * @return number
     */
    private function generateId(){
        $id = 1;

        $filename = 'error_id.txt';
        $lockfilename = 'lock';

        //＊＊ロック用ファイルのオープン＊＊
        $lockfp = fopen($lockfilename,'wb+');
        //＊＊ロック用ファイルのロック＊＊
        flock($lockfp, LOCK_EX);

        //ファイルのオープン
        if(file_exists($filename)){
            $fp = fopen($filename,'rb+');
            //バッファを0に指定（排他制御の保証）
            stream_set_write_buffer($fp, 0);
            //ファイルのロック
            flock($fp, LOCK_EX);
            //ファイルポインタを先頭に移動
            rewind($fp);
            $id =  intval(fgets($fp)) ;
            if(!$id) $id = 1;
        }
        else{
            $fp = fopen($filename,'wb+');
            //バッファを0に指定（排他制御の保証）
            stream_set_write_buffer($fp, 0);
            //ファイルのロック
            flock($fp, LOCK_EX);
            $id = 1;
        }

        rewind($fp);
        //ファイルに書きこみ
        fwrite($fp,strval($id + 1));
        fwrite($fp,"\r\n");
        //ロックの開放
        flock($fp, LOCK_UN);
        //ファイルのクローズ
        fclose($fp);

        //＊＊ロック用ファイルのロックの開放＊＊
        flock($lockfp, LOCK_UN);
        //＊＊ロック用ファイルのクローズ＊＊
        fclose($lockfp);

        return $id;
    }

}