<?php
Zend_Loader::loadClass("CFW_Data_DataSource");
Zend_Loader::loadClass("CFW_Data_ConnectionFactory");
/**
 * データソース生成
 * @author okada
 *  @package CFW_Data
 */
class CFW_Data_DataSourceFactory{
    static $configSection;

    /**
     * 指定データソース名のデータソースを取得
     * @param unknown_type $names
     * @return unknown
     */
    public static function getDataSource($names = array()){
        self::$configSection = CFW_Config_Configuration::getInstance("core")->datasource;
        if( is_string($names)){
            $names = split("/",$names);
        }
        $config = self::getConfig($names);
        $connection = CFW_Data_ConnectionFactory::getConnection($config->connection);
        $class = $config->class;
        Zend_Loader::loadClass($class);
        return new $class($connection);
    }
    /**
     * 指定名称の設定を取得する。
     * 見つからなければdefault(iniファイル上ではconnection.default.*)
     * @param unknown_type $names
     * @return unknown_type
     */
    static function getConfig($names){
        $config = null;
        $nameLength = count($names);

        for($depth = $nameLength;$depth> 0;$depth--){
            $key = self::buildConfigKey($names,$depth);
            $config = self::$configSection->get($key);
            if( $config != null){
                break;
            }
        }
        if($config == null){
            $config =  self::$configSection->default;
        }
        return $config;
    }
    static function buildConfigKey($name,$depth){
        $key = "";
        for($i = 0;$i < $depth;$i++){
            if($i > 0) $key .= "_";
            $key .= $name[$i];
        }
        return $key;
    }

}