<?php
include_once("../public/startup.php");
require_once 'PHPUnit/Framework.php';
require_once("CFW/Util/Number.php");

class NumberUtilTest extends PHPUnit_Framework_TestCase {

	public function testtoInteger() {
		$result = CFW_Util_Number::toInteger("1");
		$this->assertEquals(1, $result);

		$result = CFW_Util_Number::toInteger(null);
		$this->assertEquals(0, $result);
	}
	public function testtoByte() {
		$result = CFW_Util_Number::toByte(null);
		$this->assertEquals(0, $result);

		$result = CFW_Util_Number::toByte(255);
		$this->assertEquals(255, $result);

		$result = CFW_Util_Number::toByte(300);
		$this->assertEquals(0, $result);
	}
	public function testtoNumber() {
		$result = CFW_Util_Number::toNumber(123456789);
		$this->assertEquals(123456789, $result);

		$result = CFW_Util_Number::toNumber(123456789, 5);
		$this->assertEquals(0, $result);

		$result = CFW_Util_Number::toNumber(1.2345, 5, 4);
		$this->assertEquals(1.2345, $result);

		$result = CFW_Util_Number::toNumber(1.2345, 5, 3);
		$this->assertEquals(0, $result);

		$result = CFW_Util_Number::toNumber(123456789, 10);
		$this->assertEquals(123456789, $result);
	}
	public function testboolValue() {
		$result = CFW_Util_Number::boolValue("");
		$this->assertEquals(false, $result);

		$result = CFW_Util_Number::boolValue(null);
		$this->assertEquals(false, $result);

		$result = CFW_Util_Number::boolValue(0);
		$this->assertEquals(false, $result);

		$result = CFW_Util_Number::boolValue("false");
		$this->assertEquals(false, $result);

		$result = CFW_Util_Number::boolValue("FALSE");
		$this->assertEquals(false, $result);

		$result = CFW_Util_Number::boolValue("true");
		$this->assertEquals(true, $result);

		$result = CFW_Util_Number::boolValue(1);
		$this->assertEquals(true, $result);

		$result = CFW_Util_Number::boolValue("off");
		$this->assertEquals(false, $result);

		$result = CFW_Util_Number::boolValue("on");
		$this->assertEquals(true, $result);

		$result = CFW_Util_Number::boolValue("no");
		$this->assertEquals(false, $result);

		$result = CFW_Util_Number::boolValue("yes");
		$this->assertEquals(true, $result);
	}
	public function testboolToInt() {
		$result = CFW_Util_Number::boolToInt(true);
		$this->assertEquals(1, $result);

		$result = CFW_Util_Number::boolToInt(false);
		$this->assertEquals(0, $result);

		$result = CFW_Util_Number::boolToInt("");
		$this->assertEquals(0, $result);
	}
	public function testformat() {
		$result = CFW_Util_Number::format(null);
		$this->assertEquals("", $result);

		$result = CFW_Util_Number::format(1234567890);
		$this->assertEquals("1234567890", $result);

		$result = CFW_Util_Number::format(new Date("20091126123456"));
		$this->assertEquals("2009/11/26 12:34:56", $result);
	}
	public function testformatBool() {
		$result = CFW_Util_Number::formatBool("",1,2);
		$this->assertEquals("", $result);

		$result = CFW_Util_Number::formatBool(true,1,2);
		$this->assertEquals(1, $result);

		$result = CFW_Util_Number::formatBool(false,1,2);
		$this->assertEquals(2, $result);
	}
	public function testformatBoolYN() {
		$result = CFW_Util_Number::formatBoolYN("");
		$this->assertEquals("", $result);

		$result = CFW_Util_Number::formatBoolYN(true);
		$this->assertEquals("Y", $result);

		$result = CFW_Util_Number::formatBoolYN(false);
		$this->assertEquals("N", $result);
	}
	public function testformatBoolYesNo() {
		$result = CFW_Util_Number::formatBoolYesNo("");
		$this->assertEquals("", $result);

		$result = CFW_Util_Number::formatBoolYesNo(true);
		$this->assertEquals("Yes", $result);

		$result = CFW_Util_Number::formatBoolYesNo(false);
		$this->assertEquals("No", $result);
	}

	public function testformatNumber() {
		$result = CFW_Util_Number::formatNumber("");
		$this->assertEquals(0, $result);

		$result = CFW_Util_Number::formatNumber(12345);
		$this->assertEquals("12,345", $result);

		$result = CFW_Util_Number::formatNumber("12345");
		$this->assertEquals("12,345", $result);
	}
	public function testformatCurrency() {
		$result = CFW_Util_Number::formatCurrency("");
		$this->assertEquals("//0", $result);

		$result = CFW_Util_Number::formatCurrency(12345);
		$this->assertEquals("//12,345", $result);

		$result = CFW_Util_Number::formatCurrency("12345");
		$this->assertEquals("//12,345", $result);
	}

	public function testparseBool() {
		$result = CFW_Util_Number::parseBool("");
		$this->assertEquals(false, $result);

		$result = CFW_Util_Number::parseBool(1);
		$this->assertEquals(true, $result);

		$result = CFW_Util_Number::parseBool("y");
		$this->assertEquals(true, $result);

		$result = CFW_Util_Number::parseBool("yes");
		$this->assertEquals(true, $result);

		$result = CFW_Util_Number::parseBool("YES");
		$this->assertEquals(true, $result);

		$result = CFW_Util_Number::parseBool("true");
		$this->assertEquals(true, $result);

		$result = CFW_Util_Number::parseBool(true);
		$this->assertEquals(true, $result);
	}

	public function testdistance() {
		$result = CFW_Util_Number::distance(0, 2);
		$this->assertEquals(2, $result);

		$result = CFW_Util_Number::distance("0", "2");
		$this->assertEquals(2, $result);

		$result = CFW_Util_Number::distance(2, 0);
		$this->assertEquals(-2, $result);

		$result = CFW_Util_Number::distance("2", "0");
		$this->assertEquals(-2, $result);
	}
	public function testisInRange() {
		$result = CFW_Util_Number::isInRange(5, 2, 10);
		$this->assertEquals(true, $result);

		$result = CFW_Util_Number::isInRange(2, 5, 10);
		$this->assertEquals(false, $result);
	}

	public function testformatZero() {
		$result = CFW_Util_Number::formatZero("", 5);
		$this->assertEquals(00000, $result);

		$result = CFW_Util_Number::formatZero("12345", 5);
		$this->assertEquals("12345", $result);

		$result = CFW_Util_Number::formatZero(12345, 10);
		$this->assertEquals("0000012345", $result);

		$result = CFW_Util_Number::formatZero("abcd", 10);
		$this->assertEquals("000000abcd", $result);
	}

	public function testpower() {
		$result = CFW_Util_Number::power(2,2);
		$this->assertEquals(4, $result);

		$result = CFW_Util_Number::power(2,-2);
		$this->assertEquals(0.25, $result);

		$result = CFW_Util_Number::power(2,4);
		$this->assertEquals(16, $result);

		$result = CFW_Util_Number::power(100,-2);
		$this->assertEquals(0.0001, $result);
	}

	public function testround() {
		$result = CFW_Util_Number::round(123.499, 0);
		$this->assertEquals(123, $result);

		$result = CFW_Util_Number::round(123.5, 0);
		$this->assertEquals(124, $result);

		$result = CFW_Util_Number::round(123.9999, 2);
		$this->assertEquals(124.00, $result);

		$result = CFW_Util_Number::round(123.4449999, 2);
		$this->assertEquals(123.44, $result);

		$result = CFW_Util_Number::round(123.445111, 2);
		$this->assertEquals(123.45, $result);

		$result = CFW_Util_Number::round(1234567499.4455111, -3);
		$this->assertEquals(1234567000, $result);

		$result = CFW_Util_Number::round(1234567500.445111, -3);
		$this->assertEquals(1234568000, $result);
	}
	public function testround2() {
		$result = CFW_Util_Number::round(123.05, 1);
		$this->assertEquals(123.1, $result);

		$result = CFW_Util_Number::round(123.15, 1);
		$this->assertEquals(123.2, $result);
	}

	public function testroundUp() {
		$result = CFW_Util_Number::roundUp(123.499, 0);
		$this->assertEquals(124, $result);

		$result = CFW_Util_Number::roundUp(123.5, 0);
		$this->assertEquals(124, $result);

		$result = CFW_Util_Number::roundUp(123.9999, 2);
		$this->assertEquals(124.00, $result);

		$result = CFW_Util_Number::roundUp(123.444999, 2);
		$this->assertEquals(123.45, $result);

		$result = CFW_Util_Number::roundUp(1234567499.445111, -3);
		$this->assertEquals(1234568000, $result);

		$result = CFW_Util_Number::roundUp(1234567500.445111, -3);
		$this->assertEquals(1234568000, $result);
	}

	public function testroundDown() {
		$result = CFW_Util_Number::roundDown(123.499, 0);
		$this->assertEquals(123, $result);

		$result = CFW_Util_Number::roundDown(123.5, 0);
		$this->assertEquals(123, $result);

		$result = CFW_Util_Number::roundDown(123.9999, 2);
		$this->assertEquals(123.99, $result);

		$result = CFW_Util_Number::roundDown(123.4444, 2);
		$this->assertEquals(123.44, $result);

		$result = CFW_Util_Number::roundDown(1234567499, -3);
		$this->assertEquals(1234567000, $result);

		$result = CFW_Util_Number::roundDown(1234567500, -3);
		$this->assertEquals(1234567000, $result);
	}
}