<?php
include( "../core.php" );

/**
 * テンプレート解析
 * @author okada
 */


/**
 * document
 * @author okada
 *
 */
class Document{
    
    var $elements;

    public function __construct(){
        $this->elements = array();
    } 
    public function parse(&$tokenizer){
        
        while($tokenizer->hasMoreTokens() ){
            if($tokenizer->token == "<%"){
                //タグ
                $tokenizer->nextToken();
                $tag = TagElement::factory($tokenizer);
                $tag->parse($tokenizer);
                
                $this->elements[] = $tag;
            }
            else{
                $textContent = new TextContent();
                $textContent->parse($tokenizer);
                $this->elements[] = $textContent;
            }
            
        }
        return $this;
        
    }
    function dump(){
        $s = "";
        foreach($this->elements as $element){
            $s .= $element->dump();
        }
        return  " ( " . $s  . " ) ";
    }
}
class TagElement{
    var $name;
    var $attributes;
    public static function factory(&$tokenizer){
        $id =  $tokenizer->token;
        if($id == "repeat"){
            $tokenizer->nextToken();
            return new RepeatElement();
        }
        if($id == "if"){
            $tokenizer->nextToken();
            return new IfElement();
        }
        if($id == "function"){
            $tokenizer->nextToken();
            return new FunctionElement();
        }
        if($id == "var"){
            $tokenizer->nextToken();
            return new VariableElement();
        }
        
        return new VariableElement();
        
    }
    
    function dump(){
        return $content;
    }
}
class Attribute{
    var $name;
    var $value;
    public function parse(&$tokenizer){
        
    }   
    
}
class VariableElement extends TagElement{
    public function parse(&$tokenizer){
        $this->name = $tokenizer->token;
        $this->attributes = array();
        $tokenizer->nextToken();
        while($tokenizer->token !== false &&  $tokenizer->token != "%>"){
            $attrName = $tokenizer->token;
            $tokenizer->nextToken(); // "="読み捨て
            $value = $tokenizer->nextToken();
            $attr = new Attribute();
            $attr->name = $attrName;
            $attr->value = $value;
            $this->attributes[] = $attr;
            
            $this->content .=  " " . $tokenizer->token; 
            $tokenizer->nextToken();
        }        
    }
    function evaluate($values){
        
    }   
    function dump(){
        $s = "";
        foreach($this->attributes as $attr){
            $s .= " {$attr->name}={$attr->value}";
        }
        return "[var name=" . $this->name . " attr " . $s. "]";
    }
}
class RepeatElement extends TagElement{
    public function parse(&$tokenizer){
        
    }   
    function dump(){
        return $content;
    }
    
}
class IfElement extends TagElement{
    public function parse(&$tokenizer){
        
    }   
    function dump(){
        return $content;
    }
    
}
class BlockElement extends TagElement{
    public function parse(&$tokenizer){
        
    }   
    function dump(){
        return $content;
    }
    
}
class FunctionElement extends TagElement{
    public function parse(&$tokenizer){
        
    }   
    function dump(){
        return $content;
    }
    
}
class SystemDateFunctionElement extends FunctionElement{
    public function parse(&$tokenizer){
        
    }   
    
    function dump(){
        return $content;
    }
}
class TextContent{
    var $content;
    public function parse(&$tokenizer){
        while($tokenizer->token !== false &&  $tokenizer->token != "<%"){
            $this->content .=  $tokenizer->token; 
            $tokenizer->nextToken();
        }        
    }   
    function dump(){
        return $this->content;
    }
    
}

class TemplateTokenizer extends CFW_Common_Tokenizer{
    public function __construct($reader){
        parent::__construct($reader);
        $this->operator = array("<%",">","=");
        $this->ignore = array(" ","\t");
        $this->delimiter = array(" ","\t");
        $this->quotes = array("\"");
        
    }
    /**
     * 指定文字が演算子かチェック
     * @param $c
     * @return unknown_type
     */
    function isOperator($c){
        if($c == "<"){
            $c2 = $this->reader->read();
            
            if($c2 == "%"){
                $this->c = "<%";
                return true;
            }
        }
        if($c == "%"){
            $c2 = $this->reader->read();
            
            if($c2 == ">"){
                $this->c = "%>";
                return true;
            }
        }
        if($c == "="){
                return true;
        }
        
        if(in_array($c,$this->operator)){
            return true;
        }   
        return false;
    }
    
}


class Parser{
    var $result;
    var $tokenizer;
    var $currentToken ;
    function __construct(){
    }
    public function parse($s){
        $this->tokenizer = new TemplateTokenizer(new CFW_IO_StringReader( $s ));
        $this->currentToken = $this->tokenizer->nextToken();
        $expr = new Document();
        $this->result = $expr->parse($this->tokenizer);
        
    }
    
    
    
}

$parser = new Parser();
$parser->parse("1 + 2 * 3 + 4 * 5 + 5 + 6 + 7");
echo "-----<br />";
echo "result = " . $parser->result->dump(). "<br />";
echo "-----<br />";
$parser->parse("2 * (3 + 4) + 11\r\n<%test format=\"yyyy/MM/dd HH:mm:ss\"%>"); // = 25
echo "result = " . htmlspecialchars( $parser->result->dump() ). "<br />";
echo "-----<br />";
$parser->parse("2 * ((3 + 4) * 5) + 11"); // = 25
echo "result = " . htmlspecialchars( $parser->result->dump() ). "<br />";

echo "-----<br />";
$parser->parse("2 * 3 + 4 * 5"); // = 25
echo "result = " . htmlspecialchars( $parser->result->dump() ). "<br />";

?>