<?php
Zend_Loader::loadClass("CFW_Data_ConnectionFactory");
Zend_Loader::loadClass("CFW_Data_Connection");
Zend_Loader::loadClass("CFW_Models_IEntity");
Zend_Loader::loadClass("CFW_Models_IEntityProperty");

/**
 * 全てのモデルの基本クラス.
 * load,save,validateのみのシグネーチャを定義しておくので実装クラスで実装する事。
 * @author okada
 * @package CFW_Models
 */
abstract class CFW_Models_Base{
    var $connection;
    var $messages;

    /**
     * @return none
     */
    public function __construct(){
    }
    /**
     * @param unknown_type $name
     * @return none
     */
    public function connect($name = "default"){
        $this->connection = CFW_Data_ConnectionFactory::getConnection($name);
        $this->connection->connect();
    }
    /**
     * @return none_type
     */
    public function disconnect(){
        $this->connection->disconnect();

    }
    /**
     * @param CFW_Data_Connection $connection
     * @return none
     */
    public function setConnection($connection){
        $this->connection = $connection;
    }
    /**
     * @param CFW_Models_IEntity $property
     * @return none
     */
    public function setProperty($property){
        $this->property= $property;
    }
    /**
     * @param unknown_type $entity
     * @return unknown_type
     */
    abstract  function save($entity);
    /**
     * @param CFW_Models_IEntity $entity
     * @return CFW_Models_IEntity
     */
    abstract function load($key);
    /**
     * @param CFW_Models_IEntity $entity
     * @return Boolean
     */
    abstract function validate($entity);

}