﻿<?php 
Zend_Loader::loadClass("CFW_Data_TableRow");
Zend_Loader::loadClass("CFW_Data_TableProperty");

/**
* table MAST_MATERIAL Field定義
*/
class CFW_Sample_Model_Base_MastMaterialTableRow extends CFW_Data_TableRow
{
    /** 
    * @var String siteCode [SITE_CODE]
    */
    public $siteCode;
    /** 
    * @var String menuCode [MENU_CODE]
    */
    public $menuCode;
    /** 
    * @var Number manuscriptSeq [MANUSCRIPT_SEQ]
    */
    public $manuscriptSeq;
    /** 
    * @var Number seq [SEQ]
    */
    public $seq;
    /** 
    * @var Number materialCode [MATERIAL_CODE]
    */
    public $materialCode;
    /** 
    * @var String materialAliasName [MATERIAL_ALIAS_NAME]
    */
    public $materialAliasName;
    /** 
    * @var Number materialInputKindDiv [MATERIAL_INPUT_KIND_DIV]
    */
    public $materialInputKindDiv;
    /** 
    * @var Number materialInputKindSeq [MATERIAL_INPUT_KIND_SEQ]
    */
    public $materialInputKindSeq;
    /** 
    * @var String fileVersion [FILE_VERSION]
    */
    public $fileVersion;
    /** 
    * @var String fileExtention [FILE_EXTENTION]
    */
    public $fileExtention;
    /** 
    * @var Number wholePixcelX [WHOLE_PIXCEL_X]
    */
    public $wholePixcelX;
    /** 
    * @var Number wholePixcelY [WHOLE_PIXCEL_Y]
    */
    public $wholePixcelY;
    /** 
    * @var String wholePixcelLimit [WHOLE_PIXCEL_LIMIT]
    */
    public $wholePixcelLimit;
    /** 
    * @var Number wholePixcelLimitDiv [WHOLE_PIXCEL_LIMIT_DIV]
    */
    public $wholePixcelLimitDiv;
    /** 
    * @var Number wholePixcelLimitSeq [WHOLE_PIXCEL_LIMIT_SEQ]
    */
    public $wholePixcelLimitSeq;
    /** 
    * @var Number adPixcelX [AD_PIXCEL_X]
    */
    public $adPixcelX;
    /** 
    * @var Number adPixcelY [AD_PIXCEL_Y]
    */
    public $adPixcelY;
    /** 
    * @var String adPixcelLimit [AD_PIXCEL_LIMIT]
    */
    public $adPixcelLimit;
    /** 
    * @var Number adPixcelLimitDiv [AD_PIXCEL_LIMIT_DIV]
    */
    public $adPixcelLimitDiv;
    /** 
    * @var Number adPixcelLimitSeq [AD_PIXCEL_LIMIT_SEQ]
    */
    public $adPixcelLimitSeq;
    /** 
    * @var Number rfPixcelX [RF_PIXCEL_X]
    */
    public $rfPixcelX;
    /** 
    * @var Number rfPixcelY [RF_PIXCEL_Y]
    */
    public $rfPixcelY;
    /** 
    * @var String rfPixcelLimit [RF_PIXCEL_LIMIT]
    */
    public $rfPixcelLimit;
    /** 
    * @var Number rfPixcelLimitDiv [RF_PIXCEL_LIMIT_DIV]
    */
    public $rfPixcelLimitDiv;
    /** 
    * @var Number rfPixcelLimitSeq [RF_PIXCEL_LIMIT_SEQ]
    */
    public $rfPixcelLimitSeq;
    /** 
    * @var Number colorCapacity [COLOR_CAPACITY]
    */
    public $colorCapacity;
    /** 
    * @var String colorCapacityLimit [COLOR_CAPACITY_LIMIT]
    */
    public $colorCapacityLimit;
    /** 
    * @var Number colorCapacityLimitDiv [COLOR_CAPACITY_LIMIT_DIV]
    */
    public $colorCapacityLimitDiv;
    /** 
    * @var Number colorCapacityLimitSeq [COLOR_CAPACITY_LIMIT_SEQ]
    */
    public $colorCapacityLimitSeq;
    /** 
    * @var Number monoCapacity [MONO_CAPACITY]
    */
    public $monoCapacity;
    /** 
    * @var String monoCapacityLimit [MONO_CAPACITY_LIMIT]
    */
    public $monoCapacityLimit;
    /** 
    * @var Number monoCapacityLimitDiv [MONO_CAPACITY_LIMIT_DIV]
    */
    public $monoCapacityLimitDiv;
    /** 
    * @var Number monoCapacityLimitSeq [MONO_CAPACITY_LIMIT_SEQ]
    */
    public $monoCapacityLimitSeq;
    /** 
    * @var Number mainLetterFlag [MAIN_LETTER_FLAG]
    */
    public $mainLetterFlag;
    /** 
    * @var Number mainLetter [MAIN_LETTER]
    */
    public $mainLetter;
    /** 
    * @var String MLetterLimit [M_LETTER_LIMIT]
    */
    public $MLetterLimit;
    /** 
    * @var Number MLetterLimitDiv [M_LETTER_LIMIT_DIV]
    */
    public $MLetterLimitDiv;
    /** 
    * @var Number MLetterLimitSeq [M_LETTER_LIMIT_SEQ]
    */
    public $MLetterLimitSeq;
    /** 
    * @var Number mainLine [MAIN_LINE]
    */
    public $mainLine;
    /** 
    * @var String MLineLimit [M_LINE_LIMIT]
    */
    public $MLineLimit;
    /** 
    * @var Number MLineLimitDiv [M_LINE_LIMIT_DIV]
    */
    public $MLineLimitDiv;
    /** 
    * @var Number MLineLimitSeq [M_LINE_LIMIT_SEQ]
    */
    public $MLineLimitSeq;
    /** 
    * @var Number M2bytecharFlag [M_2BYTECHAR_FLAG]
    */
    public $M2bytecharFlag;
    /** 
    * @var Number M1bytecharFlag [M_1BYTECHAR_FLAG]
    */
    public $M1bytecharFlag;
    /** 
    * @var Number MKanaFlag [M_KANA_FLAG]
    */
    public $MKanaFlag;
    /** 
    * @var Number MRfFlag [M_RF_FLAG]
    */
    public $MRfFlag;
    /** 
    * @var String MRfRemarks [M_RF_REMARKS]
    */
    public $MRfRemarks;
    /** 
    * @var Number MPictureCharFlag [M_PICTURE_CHAR_FLAG]
    */
    public $MPictureCharFlag;
    /** 
    * @var Number MPictureCharExtendFlag [M_PICTURE_CHAR_EXTEND_FLAG]
    */
    public $MPictureCharExtendFlag;
    /** 
    * @var Number titleLetterFlag [TITLE_LETTER_FLAG]
    */
    public $titleLetterFlag;
    /** 
    * @var Number titelLetter [TITEL_LETTER]
    */
    public $titelLetter;
    /** 
    * @var String TLetterLimit [T_LETTER_LIMIT]
    */
    public $TLetterLimit;
    /** 
    * @var Number TLetterLimitDiv [T_LETTER_LIMIT_DIV]
    */
    public $TLetterLimitDiv;
    /** 
    * @var Number TLetterLimitSeq [T_LETTER_LIMIT_SEQ]
    */
    public $TLetterLimitSeq;
    /** 
    * @var Number TLine [T_LINE]
    */
    public $TLine;
    /** 
    * @var String TLineLimit [T_LINE_LIMIT]
    */
    public $TLineLimit;
    /** 
    * @var Number TLineLimitDiv [T_LINE_LIMIT_DIV]
    */
    public $TLineLimitDiv;
    /** 
    * @var Number TLineLimitSeq [T_LINE_LIMIT_SEQ]
    */
    public $TLineLimitSeq;
    /** 
    * @var Number T2bytecharFlag [T_2BYTECHAR_FLAG]
    */
    public $T2bytecharFlag;
    /** 
    * @var Number T1bytecharFlag [T_1BYTECHAR_FLAG]
    */
    public $T1bytecharFlag;
    /** 
    * @var Number TKanaFlag [T_KANA_FLAG]
    */
    public $TKanaFlag;
    /** 
    * @var Number TRfFlag [T_RF_FLAG]
    */
    public $TRfFlag;
    /** 
    * @var String TRfRemarks [T_RF_REMARKS]
    */
    public $TRfRemarks;
    /** 
    * @var Number TPictureCharFlag [T_PICTURE_CHAR_FLAG]
    */
    public $TPictureCharFlag;
    /** 
    * @var Number TPictureCharExtendFlag [T_PICTURE_CHAR_EXTEND_FLAG]
    */
    public $TPictureCharExtendFlag;
    /** 
    * @var Number urlFlag [URL_FLAG]
    */
    public $urlFlag;
    /** 
    * @var Number urlLetter [URL_LETTER]
    */
    public $urlLetter;
    /** 
    * @var String ULetterLimit [U_LETTER_LIMIT]
    */
    public $ULetterLimit;
    /** 
    * @var Number ULetterLimitDiv [U_LETTER_LIMIT_DIV]
    */
    public $ULetterLimitDiv;
    /** 
    * @var Number ULetterLimitSeq [U_LETTER_LIMIT_SEQ]
    */
    public $ULetterLimitSeq;
    /** 
    * @var Number altFlag [ALT_FLAG]
    */
    public $altFlag;
    /** 
    * @var Number altLetter [ALT_LETTER]
    */
    public $altLetter;
    /** 
    * @var String ALetterLimit [A_LETTER_LIMIT]
    */
    public $ALetterLimit;
    /** 
    * @var Number ALetterLimitDiv [A_LETTER_LIMIT_DIV]
    */
    public $ALetterLimitDiv;
    /** 
    * @var Number ALetterLimitSeq [A_LETTER_LIMIT_SEQ]
    */
    public $ALetterLimitSeq;
    /** 
    * @var Number A2bytecharFlag [A_2BYTECHAR_FLAG]
    */
    public $A2bytecharFlag;
    /** 
    * @var Number A1bytecharFlag [A_1BYTECHAR_FLAG]
    */
    public $A1bytecharFlag;
    /** 
    * @var Number AKanaFlag [A_KANA_FLAG]
    */
    public $AKanaFlag;
    /** 
    * @var Number loopLimitFlag [LOOP_LIMIT_FLAG]
    */
    public $loopLimitFlag;
    /** 
    * @var Number LCount [L_COUNT]
    */
    public $LCount;
    /** 
    * @var Number LCountOpenFlag [L_COUNT_OPEN_FLAG]
    */
    public $LCountOpenFlag;
    /** 
    * @var Number LRoundLimitFlag [L_ROUND_LIMIT_FLAG]
    */
    public $LRoundLimitFlag;
    /** 
    * @var Number LRoundSecond [L_ROUND_SECOND]
    */
    public $LRoundSecond;
    /** 
    * @var String LRoundLimit [L_ROUND_LIMIT]
    */
    public $LRoundLimit;
    /** 
    * @var Number LRoundLimitDiv [L_ROUND_LIMIT_DIV]
    */
    public $LRoundLimitDiv;
    /** 
    * @var Number LRoundLimitSeq [L_ROUND_LIMIT_SEQ]
    */
    public $LRoundLimitSeq;
    /** 
    * @var Number animationFlag [ANIMATION_FLAG]
    */
    public $animationFlag;
    /** 
    * @var Number animationCount [ANIMATION_COUNT]
    */
    public $animationCount;
    /** 
    * @var Number colorFlag [COLOR_FLAG]
    */
    public $colorFlag;
    /** 
    * @var Number withMonoFlag [WITH_MONO_FLAG]
    */
    public $withMonoFlag;
    /** 
    * @var Number dhtmlFlag [DHTML_FLAG]
    */
    public $dhtmlFlag;
    /** 
    * @var String linkTarget [LINK_TARGET]
    */
    public $linkTarget;
    /** 
    * @var Number pcCharFlag [PC_CHAR_FLAG]
    */
    public $pcCharFlag;
    /** 
    * @var Number soundFlag [SOUND_FLAG]
    */
    public $soundFlag;
    /** 
    * @var Number soundDefaultFlag [SOUND_DEFAULT_FLAG]
    */
    public $soundDefaultFlag;
    /** 
    * @var Number mutebuttonFlag [MUTEBUTTON_FLAG]
    */
    public $mutebuttonFlag;
    /** 
    * @var Number closebuttonFlag [CLOSEBUTTON_FLAG]
    */
    public $closebuttonFlag;
    /** 
    * @var String encode [ENCODE]
    */
    public $encode;
    /** 
    * @var Number encodeDiv [ENCODE_DIV]
    */
    public $encodeDiv;
    /** 
    * @var Number encodeSeq [ENCODE_SEQ]
    */
    public $encodeSeq;
    /** 
    * @var Number bitRateMin [BIT_RATE_MIN]
    */
    public $bitRateMin;
    /** 
    * @var Number bitRateMax [BIT_RATE_MAX]
    */
    public $bitRateMax;
    /** 
    * @var String soundEncode [SOUND_ENCODE]
    */
    public $soundEncode;
    /** 
    * @var Number soundEncodeDiv [SOUND_ENCODE_DIV]
    */
    public $soundEncodeDiv;
    /** 
    * @var Number soundEncodeSeq [SOUND_ENCODE_SEQ]
    */
    public $soundEncodeSeq;
    /** 
    * @var Number soundBitRateMin [SOUND_BIT_RATE_MIN]
    */
    public $soundBitRateMin;
    /** 
    * @var Number soundBitRateMax [SOUND_BIT_RATE_MAX]
    */
    public $soundBitRateMax;
    /** 
    * @var String soundEncodeVersion [SOUND_ENCODE_VERSION]
    */
    public $soundEncodeVersion;
    /** 
    * @var String startAreaRemarks [START_AREA_REMARKS]
    */
    public $startAreaRemarks;
    /** 
    * @var String flaFileVersion [FLA_FILE_VERSION]
    */
    public $flaFileVersion;
    /** 
    * @var Number flaFileMustFlag [FLA_FILE_MUST_FLAG]
    */
    public $flaFileMustFlag;
    /** 
    * @var Number flaFilePublishFlag [FLA_FILE_PUBLISH_FLAG]
    */
    public $flaFilePublishFlag;
    /** 
    * @var Number mustFlag [MUST_FLAG]
    */
    public $mustFlag;
    /** 
    * @var String remarks [REMARKS]
    */
    public $remarks;
    /** 
    * @var Number regPtnNo [REG_PTN_NO]
    */
    public $regPtnNo;
    /** 
    * @var Number useMenuCarrierFlag [USE_MENU_CARRIER_FLAG]
    */
    public $useMenuCarrierFlag;
    /** 
    * @var String admissionAdCode [ADMISSION_AD_CODE]
    */
    public $admissionAdCode;
    /** 
    * @var Number materialPatternSeq [MATERIAL_PATTERN_SEQ]
    */
    public $materialPatternSeq;
    /** 
    * @var Number specialFlag [SPECIAL_FLAG]
    */
    public $specialFlag;
    /** 
    * @var Number validFlag [VALID_FLAG]
    */
    public $validFlag;
    /** 
    * @var Date insertDateTime [INSERT_DATE_TIME]
    */
    public $insertDateTime;
    /** 
    * @var String insertOperatorCode [INSERT_OPERATOR_CODE]
    */
    public $insertOperatorCode;
    /** 
    * @var Date updateDateTime [UPDATE_DATE_TIME]
    */
    public $updateDateTime;
    /** 
    * @var String operatorCode [OPERATOR_CODE]
    */
    public $operatorCode;
    
    /**
    * default construct 
    */
    public function __construct()
    {
    	parent::__construct();
        $this->siteCode = "";
        $this->menuCode = "";
        $this->manuscriptSeq = 0;
        $this->seq = 0;
        $this->materialCode = null;
        $this->materialAliasName = "";
        $this->materialInputKindDiv = null;
        $this->materialInputKindSeq = null;
        $this->fileVersion = "";
        $this->fileExtention = "";
        $this->wholePixcelX = null;
        $this->wholePixcelY = null;
        $this->wholePixcelLimit = "";
        $this->wholePixcelLimitDiv = null;
        $this->wholePixcelLimitSeq = null;
        $this->adPixcelX = null;
        $this->adPixcelY = null;
        $this->adPixcelLimit = "";
        $this->adPixcelLimitDiv = null;
        $this->adPixcelLimitSeq = null;
        $this->rfPixcelX = null;
        $this->rfPixcelY = null;
        $this->rfPixcelLimit = "";
        $this->rfPixcelLimitDiv = null;
        $this->rfPixcelLimitSeq = null;
        $this->colorCapacity = null;
        $this->colorCapacityLimit = "";
        $this->colorCapacityLimitDiv = null;
        $this->colorCapacityLimitSeq = null;
        $this->monoCapacity = null;
        $this->monoCapacityLimit = "";
        $this->monoCapacityLimitDiv = null;
        $this->monoCapacityLimitSeq = null;
        $this->mainLetterFlag = null;
        $this->mainLetter = null;
        $this->MLetterLimit = "";
        $this->MLetterLimitDiv = null;
        $this->MLetterLimitSeq = null;
        $this->mainLine = null;
        $this->MLineLimit = "";
        $this->MLineLimitDiv = null;
        $this->MLineLimitSeq = null;
        $this->M2bytecharFlag = null;
        $this->M1bytecharFlag = null;
        $this->MKanaFlag = null;
        $this->MRfFlag = null;
        $this->MRfRemarks = "";
        $this->MPictureCharFlag = null;
        $this->MPictureCharExtendFlag = null;
        $this->titleLetterFlag = null;
        $this->titelLetter = null;
        $this->TLetterLimit = "";
        $this->TLetterLimitDiv = null;
        $this->TLetterLimitSeq = null;
        $this->TLine = null;
        $this->TLineLimit = "";
        $this->TLineLimitDiv = null;
        $this->TLineLimitSeq = null;
        $this->T2bytecharFlag = null;
        $this->T1bytecharFlag = null;
        $this->TKanaFlag = null;
        $this->TRfFlag = null;
        $this->TRfRemarks = "";
        $this->TPictureCharFlag = null;
        $this->TPictureCharExtendFlag = null;
        $this->urlFlag = null;
        $this->urlLetter = null;
        $this->ULetterLimit = "";
        $this->ULetterLimitDiv = null;
        $this->ULetterLimitSeq = null;
        $this->altFlag = null;
        $this->altLetter = null;
        $this->ALetterLimit = "";
        $this->ALetterLimitDiv = null;
        $this->ALetterLimitSeq = null;
        $this->A2bytecharFlag = null;
        $this->A1bytecharFlag = null;
        $this->AKanaFlag = null;
        $this->loopLimitFlag = null;
        $this->LCount = null;
        $this->LCountOpenFlag = null;
        $this->LRoundLimitFlag = null;
        $this->LRoundSecond = null;
        $this->LRoundLimit = "";
        $this->LRoundLimitDiv = null;
        $this->LRoundLimitSeq = null;
        $this->animationFlag = null;
        $this->animationCount = null;
        $this->colorFlag = null;
        $this->withMonoFlag = null;
        $this->dhtmlFlag = null;
        $this->linkTarget = "";
        $this->pcCharFlag = null;
        $this->soundFlag = null;
        $this->soundDefaultFlag = null;
        $this->mutebuttonFlag = null;
        $this->closebuttonFlag = null;
        $this->encode = "";
        $this->encodeDiv = null;
        $this->encodeSeq = null;
        $this->bitRateMin = null;
        $this->bitRateMax = null;
        $this->soundEncode = "";
        $this->soundEncodeDiv = null;
        $this->soundEncodeSeq = null;
        $this->soundBitRateMin = null;
        $this->soundBitRateMax = null;
        $this->soundEncodeVersion = "";
        $this->startAreaRemarks = "";
        $this->flaFileVersion = "";
        $this->flaFileMustFlag = null;
        $this->flaFilePublishFlag = null;
        $this->mustFlag = null;
        $this->remarks = "";
        $this->regPtnNo = null;
        $this->useMenuCarrierFlag = null;
        $this->admissionAdCode = "";
        $this->materialPatternSeq = null;
        $this->specialFlag = null;
        $this->validFlag = null;
        $this->insertDateTime = null;
        $this->insertOperatorCode = "";
        $this->updateDateTime = null;
        $this->operatorCode = "";
        
    }
    
    /**
    * 列名を指定して値を設定
    *
    * @param string name 列名
    * @param object value 値
    */
    public function setValue($name,$value)
    {
        if($name ==  "SITE_CODE") $this->siteCode = CFW_Util_String::stringValue( $value );
        if($name ==  "MENU_CODE") $this->menuCode = CFW_Util_String::stringValue( $value );
        if($name ==  "MANUSCRIPT_SEQ") $this->manuscriptSeq = CFW_Util_Number::numberValue( $value );
        if($name ==  "SEQ") $this->seq = CFW_Util_Number::numberValue( $value );
        if($name ==  "MATERIAL_CODE") $this->materialCode = CFW_Util_Number::numberValue( $value );
        if($name ==  "MATERIAL_ALIAS_NAME") $this->materialAliasName = CFW_Util_String::stringValue( $value );
        if($name ==  "MATERIAL_INPUT_KIND_DIV") $this->materialInputKindDiv = CFW_Util_Number::numberValue( $value );
        if($name ==  "MATERIAL_INPUT_KIND_SEQ") $this->materialInputKindSeq = CFW_Util_Number::numberValue( $value );
        if($name ==  "FILE_VERSION") $this->fileVersion = CFW_Util_String::stringValue( $value );
        if($name ==  "FILE_EXTENTION") $this->fileExtention = CFW_Util_String::stringValue( $value );
        if($name ==  "WHOLE_PIXCEL_X") $this->wholePixcelX = CFW_Util_Number::numberValue( $value );
        if($name ==  "WHOLE_PIXCEL_Y") $this->wholePixcelY = CFW_Util_Number::numberValue( $value );
        if($name ==  "WHOLE_PIXCEL_LIMIT") $this->wholePixcelLimit = CFW_Util_String::stringValue( $value );
        if($name ==  "WHOLE_PIXCEL_LIMIT_DIV") $this->wholePixcelLimitDiv = CFW_Util_Number::numberValue( $value );
        if($name ==  "WHOLE_PIXCEL_LIMIT_SEQ") $this->wholePixcelLimitSeq = CFW_Util_Number::numberValue( $value );
        if($name ==  "AD_PIXCEL_X") $this->adPixcelX = CFW_Util_Number::numberValue( $value );
        if($name ==  "AD_PIXCEL_Y") $this->adPixcelY = CFW_Util_Number::numberValue( $value );
        if($name ==  "AD_PIXCEL_LIMIT") $this->adPixcelLimit = CFW_Util_String::stringValue( $value );
        if($name ==  "AD_PIXCEL_LIMIT_DIV") $this->adPixcelLimitDiv = CFW_Util_Number::numberValue( $value );
        if($name ==  "AD_PIXCEL_LIMIT_SEQ") $this->adPixcelLimitSeq = CFW_Util_Number::numberValue( $value );
        if($name ==  "RF_PIXCEL_X") $this->rfPixcelX = CFW_Util_Number::numberValue( $value );
        if($name ==  "RF_PIXCEL_Y") $this->rfPixcelY = CFW_Util_Number::numberValue( $value );
        if($name ==  "RF_PIXCEL_LIMIT") $this->rfPixcelLimit = CFW_Util_String::stringValue( $value );
        if($name ==  "RF_PIXCEL_LIMIT_DIV") $this->rfPixcelLimitDiv = CFW_Util_Number::numberValue( $value );
        if($name ==  "RF_PIXCEL_LIMIT_SEQ") $this->rfPixcelLimitSeq = CFW_Util_Number::numberValue( $value );
        if($name ==  "COLOR_CAPACITY") $this->colorCapacity = CFW_Util_Number::numberValue( $value );
        if($name ==  "COLOR_CAPACITY_LIMIT") $this->colorCapacityLimit = CFW_Util_String::stringValue( $value );
        if($name ==  "COLOR_CAPACITY_LIMIT_DIV") $this->colorCapacityLimitDiv = CFW_Util_Number::numberValue( $value );
        if($name ==  "COLOR_CAPACITY_LIMIT_SEQ") $this->colorCapacityLimitSeq = CFW_Util_Number::numberValue( $value );
        if($name ==  "MONO_CAPACITY") $this->monoCapacity = CFW_Util_Number::numberValue( $value );
        if($name ==  "MONO_CAPACITY_LIMIT") $this->monoCapacityLimit = CFW_Util_String::stringValue( $value );
        if($name ==  "MONO_CAPACITY_LIMIT_DIV") $this->monoCapacityLimitDiv = CFW_Util_Number::numberValue( $value );
        if($name ==  "MONO_CAPACITY_LIMIT_SEQ") $this->monoCapacityLimitSeq = CFW_Util_Number::numberValue( $value );
        if($name ==  "MAIN_LETTER_FLAG") $this->mainLetterFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "MAIN_LETTER") $this->mainLetter = CFW_Util_Number::numberValue( $value );
        if($name ==  "M_LETTER_LIMIT") $this->MLetterLimit = CFW_Util_String::stringValue( $value );
        if($name ==  "M_LETTER_LIMIT_DIV") $this->MLetterLimitDiv = CFW_Util_Number::numberValue( $value );
        if($name ==  "M_LETTER_LIMIT_SEQ") $this->MLetterLimitSeq = CFW_Util_Number::numberValue( $value );
        if($name ==  "MAIN_LINE") $this->mainLine = CFW_Util_Number::numberValue( $value );
        if($name ==  "M_LINE_LIMIT") $this->MLineLimit = CFW_Util_String::stringValue( $value );
        if($name ==  "M_LINE_LIMIT_DIV") $this->MLineLimitDiv = CFW_Util_Number::numberValue( $value );
        if($name ==  "M_LINE_LIMIT_SEQ") $this->MLineLimitSeq = CFW_Util_Number::numberValue( $value );
        if($name ==  "M_2BYTECHAR_FLAG") $this->M2bytecharFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "M_1BYTECHAR_FLAG") $this->M1bytecharFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "M_KANA_FLAG") $this->MKanaFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "M_RF_FLAG") $this->MRfFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "M_RF_REMARKS") $this->MRfRemarks = CFW_Util_String::stringValue( $value );
        if($name ==  "M_PICTURE_CHAR_FLAG") $this->MPictureCharFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "M_PICTURE_CHAR_EXTEND_FLAG") $this->MPictureCharExtendFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "TITLE_LETTER_FLAG") $this->titleLetterFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "TITEL_LETTER") $this->titelLetter = CFW_Util_Number::numberValue( $value );
        if($name ==  "T_LETTER_LIMIT") $this->TLetterLimit = CFW_Util_String::stringValue( $value );
        if($name ==  "T_LETTER_LIMIT_DIV") $this->TLetterLimitDiv = CFW_Util_Number::numberValue( $value );
        if($name ==  "T_LETTER_LIMIT_SEQ") $this->TLetterLimitSeq = CFW_Util_Number::numberValue( $value );
        if($name ==  "T_LINE") $this->TLine = CFW_Util_Number::numberValue( $value );
        if($name ==  "T_LINE_LIMIT") $this->TLineLimit = CFW_Util_String::stringValue( $value );
        if($name ==  "T_LINE_LIMIT_DIV") $this->TLineLimitDiv = CFW_Util_Number::numberValue( $value );
        if($name ==  "T_LINE_LIMIT_SEQ") $this->TLineLimitSeq = CFW_Util_Number::numberValue( $value );
        if($name ==  "T_2BYTECHAR_FLAG") $this->T2bytecharFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "T_1BYTECHAR_FLAG") $this->T1bytecharFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "T_KANA_FLAG") $this->TKanaFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "T_RF_FLAG") $this->TRfFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "T_RF_REMARKS") $this->TRfRemarks = CFW_Util_String::stringValue( $value );
        if($name ==  "T_PICTURE_CHAR_FLAG") $this->TPictureCharFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "T_PICTURE_CHAR_EXTEND_FLAG") $this->TPictureCharExtendFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "URL_FLAG") $this->urlFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "URL_LETTER") $this->urlLetter = CFW_Util_Number::numberValue( $value );
        if($name ==  "U_LETTER_LIMIT") $this->ULetterLimit = CFW_Util_String::stringValue( $value );
        if($name ==  "U_LETTER_LIMIT_DIV") $this->ULetterLimitDiv = CFW_Util_Number::numberValue( $value );
        if($name ==  "U_LETTER_LIMIT_SEQ") $this->ULetterLimitSeq = CFW_Util_Number::numberValue( $value );
        if($name ==  "ALT_FLAG") $this->altFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "ALT_LETTER") $this->altLetter = CFW_Util_Number::numberValue( $value );
        if($name ==  "A_LETTER_LIMIT") $this->ALetterLimit = CFW_Util_String::stringValue( $value );
        if($name ==  "A_LETTER_LIMIT_DIV") $this->ALetterLimitDiv = CFW_Util_Number::numberValue( $value );
        if($name ==  "A_LETTER_LIMIT_SEQ") $this->ALetterLimitSeq = CFW_Util_Number::numberValue( $value );
        if($name ==  "A_2BYTECHAR_FLAG") $this->A2bytecharFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "A_1BYTECHAR_FLAG") $this->A1bytecharFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "A_KANA_FLAG") $this->AKanaFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "LOOP_LIMIT_FLAG") $this->loopLimitFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "L_COUNT") $this->LCount = CFW_Util_Number::numberValue( $value );
        if($name ==  "L_COUNT_OPEN_FLAG") $this->LCountOpenFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "L_ROUND_LIMIT_FLAG") $this->LRoundLimitFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "L_ROUND_SECOND") $this->LRoundSecond = CFW_Util_Number::numberValue( $value );
        if($name ==  "L_ROUND_LIMIT") $this->LRoundLimit = CFW_Util_String::stringValue( $value );
        if($name ==  "L_ROUND_LIMIT_DIV") $this->LRoundLimitDiv = CFW_Util_Number::numberValue( $value );
        if($name ==  "L_ROUND_LIMIT_SEQ") $this->LRoundLimitSeq = CFW_Util_Number::numberValue( $value );
        if($name ==  "ANIMATION_FLAG") $this->animationFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "ANIMATION_COUNT") $this->animationCount = CFW_Util_Number::numberValue( $value );
        if($name ==  "COLOR_FLAG") $this->colorFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "WITH_MONO_FLAG") $this->withMonoFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "DHTML_FLAG") $this->dhtmlFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "LINK_TARGET") $this->linkTarget = CFW_Util_String::stringValue( $value );
        if($name ==  "PC_CHAR_FLAG") $this->pcCharFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "SOUND_FLAG") $this->soundFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "SOUND_DEFAULT_FLAG") $this->soundDefaultFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "MUTEBUTTON_FLAG") $this->mutebuttonFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "CLOSEBUTTON_FLAG") $this->closebuttonFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "ENCODE") $this->encode = CFW_Util_String::stringValue( $value );
        if($name ==  "ENCODE_DIV") $this->encodeDiv = CFW_Util_Number::numberValue( $value );
        if($name ==  "ENCODE_SEQ") $this->encodeSeq = CFW_Util_Number::numberValue( $value );
        if($name ==  "BIT_RATE_MIN") $this->bitRateMin = CFW_Util_Number::numberValue( $value );
        if($name ==  "BIT_RATE_MAX") $this->bitRateMax = CFW_Util_Number::numberValue( $value );
        if($name ==  "SOUND_ENCODE") $this->soundEncode = CFW_Util_String::stringValue( $value );
        if($name ==  "SOUND_ENCODE_DIV") $this->soundEncodeDiv = CFW_Util_Number::numberValue( $value );
        if($name ==  "SOUND_ENCODE_SEQ") $this->soundEncodeSeq = CFW_Util_Number::numberValue( $value );
        if($name ==  "SOUND_BIT_RATE_MIN") $this->soundBitRateMin = CFW_Util_Number::numberValue( $value );
        if($name ==  "SOUND_BIT_RATE_MAX") $this->soundBitRateMax = CFW_Util_Number::numberValue( $value );
        if($name ==  "SOUND_ENCODE_VERSION") $this->soundEncodeVersion = CFW_Util_String::stringValue( $value );
        if($name ==  "START_AREA_REMARKS") $this->startAreaRemarks = CFW_Util_String::stringValue( $value );
        if($name ==  "FLA_FILE_VERSION") $this->flaFileVersion = CFW_Util_String::stringValue( $value );
        if($name ==  "FLA_FILE_MUST_FLAG") $this->flaFileMustFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "FLA_FILE_PUBLISH_FLAG") $this->flaFilePublishFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "MUST_FLAG") $this->mustFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "REMARKS") $this->remarks = CFW_Util_String::stringValue( $value );
        if($name ==  "REG_PTN_NO") $this->regPtnNo = CFW_Util_Number::numberValue( $value );
        if($name ==  "USE_MENU_CARRIER_FLAG") $this->useMenuCarrierFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "ADMISSION_AD_CODE") $this->admissionAdCode = CFW_Util_String::stringValue( $value );
        if($name ==  "MATERIAL_PATTERN_SEQ") $this->materialPatternSeq = CFW_Util_Number::numberValue( $value );
        if($name ==  "SPECIAL_FLAG") $this->specialFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "VALID_FLAG") $this->validFlag = CFW_Util_Number::numberValue( $value );
        if($name ==  "INSERT_DATE_TIME") $this->insertDateTime = CFW_Util_Date::dateValue( $value );
        if($name ==  "INSERT_OPERATOR_CODE") $this->insertOperatorCode = CFW_Util_String::stringValue( $value );
        if($name ==  "UPDATE_DATE_TIME") $this->updateDateTime = CFW_Util_Date::dateValue( $value );
        if($name ==  "OPERATOR_CODE") $this->operatorCode = CFW_Util_String::stringValue( $value );
        
    }
    /// <summary>
    /// 列名を指定して値を取得
    /// </summary>
    /// <param name="name">列名</param>
    /**
    * 列名を指定して値を取得
    *
    * @param string name 列名
    * @return object 値
    */
    public function getValue($name)
    {
        if($name ==  "SITE_CODE") return $this->siteCode;
        if($name ==  "MENU_CODE") return $this->menuCode;
        if($name ==  "MANUSCRIPT_SEQ") return $this->manuscriptSeq;
        if($name ==  "SEQ") return $this->seq;
        if($name ==  "MATERIAL_CODE") return $this->materialCode;
        if($name ==  "MATERIAL_ALIAS_NAME") return $this->materialAliasName;
        if($name ==  "MATERIAL_INPUT_KIND_DIV") return $this->materialInputKindDiv;
        if($name ==  "MATERIAL_INPUT_KIND_SEQ") return $this->materialInputKindSeq;
        if($name ==  "FILE_VERSION") return $this->fileVersion;
        if($name ==  "FILE_EXTENTION") return $this->fileExtention;
        if($name ==  "WHOLE_PIXCEL_X") return $this->wholePixcelX;
        if($name ==  "WHOLE_PIXCEL_Y") return $this->wholePixcelY;
        if($name ==  "WHOLE_PIXCEL_LIMIT") return $this->wholePixcelLimit;
        if($name ==  "WHOLE_PIXCEL_LIMIT_DIV") return $this->wholePixcelLimitDiv;
        if($name ==  "WHOLE_PIXCEL_LIMIT_SEQ") return $this->wholePixcelLimitSeq;
        if($name ==  "AD_PIXCEL_X") return $this->adPixcelX;
        if($name ==  "AD_PIXCEL_Y") return $this->adPixcelY;
        if($name ==  "AD_PIXCEL_LIMIT") return $this->adPixcelLimit;
        if($name ==  "AD_PIXCEL_LIMIT_DIV") return $this->adPixcelLimitDiv;
        if($name ==  "AD_PIXCEL_LIMIT_SEQ") return $this->adPixcelLimitSeq;
        if($name ==  "RF_PIXCEL_X") return $this->rfPixcelX;
        if($name ==  "RF_PIXCEL_Y") return $this->rfPixcelY;
        if($name ==  "RF_PIXCEL_LIMIT") return $this->rfPixcelLimit;
        if($name ==  "RF_PIXCEL_LIMIT_DIV") return $this->rfPixcelLimitDiv;
        if($name ==  "RF_PIXCEL_LIMIT_SEQ") return $this->rfPixcelLimitSeq;
        if($name ==  "COLOR_CAPACITY") return $this->colorCapacity;
        if($name ==  "COLOR_CAPACITY_LIMIT") return $this->colorCapacityLimit;
        if($name ==  "COLOR_CAPACITY_LIMIT_DIV") return $this->colorCapacityLimitDiv;
        if($name ==  "COLOR_CAPACITY_LIMIT_SEQ") return $this->colorCapacityLimitSeq;
        if($name ==  "MONO_CAPACITY") return $this->monoCapacity;
        if($name ==  "MONO_CAPACITY_LIMIT") return $this->monoCapacityLimit;
        if($name ==  "MONO_CAPACITY_LIMIT_DIV") return $this->monoCapacityLimitDiv;
        if($name ==  "MONO_CAPACITY_LIMIT_SEQ") return $this->monoCapacityLimitSeq;
        if($name ==  "MAIN_LETTER_FLAG") return $this->mainLetterFlag;
        if($name ==  "MAIN_LETTER") return $this->mainLetter;
        if($name ==  "M_LETTER_LIMIT") return $this->MLetterLimit;
        if($name ==  "M_LETTER_LIMIT_DIV") return $this->MLetterLimitDiv;
        if($name ==  "M_LETTER_LIMIT_SEQ") return $this->MLetterLimitSeq;
        if($name ==  "MAIN_LINE") return $this->mainLine;
        if($name ==  "M_LINE_LIMIT") return $this->MLineLimit;
        if($name ==  "M_LINE_LIMIT_DIV") return $this->MLineLimitDiv;
        if($name ==  "M_LINE_LIMIT_SEQ") return $this->MLineLimitSeq;
        if($name ==  "M_2BYTECHAR_FLAG") return $this->M2bytecharFlag;
        if($name ==  "M_1BYTECHAR_FLAG") return $this->M1bytecharFlag;
        if($name ==  "M_KANA_FLAG") return $this->MKanaFlag;
        if($name ==  "M_RF_FLAG") return $this->MRfFlag;
        if($name ==  "M_RF_REMARKS") return $this->MRfRemarks;
        if($name ==  "M_PICTURE_CHAR_FLAG") return $this->MPictureCharFlag;
        if($name ==  "M_PICTURE_CHAR_EXTEND_FLAG") return $this->MPictureCharExtendFlag;
        if($name ==  "TITLE_LETTER_FLAG") return $this->titleLetterFlag;
        if($name ==  "TITEL_LETTER") return $this->titelLetter;
        if($name ==  "T_LETTER_LIMIT") return $this->TLetterLimit;
        if($name ==  "T_LETTER_LIMIT_DIV") return $this->TLetterLimitDiv;
        if($name ==  "T_LETTER_LIMIT_SEQ") return $this->TLetterLimitSeq;
        if($name ==  "T_LINE") return $this->TLine;
        if($name ==  "T_LINE_LIMIT") return $this->TLineLimit;
        if($name ==  "T_LINE_LIMIT_DIV") return $this->TLineLimitDiv;
        if($name ==  "T_LINE_LIMIT_SEQ") return $this->TLineLimitSeq;
        if($name ==  "T_2BYTECHAR_FLAG") return $this->T2bytecharFlag;
        if($name ==  "T_1BYTECHAR_FLAG") return $this->T1bytecharFlag;
        if($name ==  "T_KANA_FLAG") return $this->TKanaFlag;
        if($name ==  "T_RF_FLAG") return $this->TRfFlag;
        if($name ==  "T_RF_REMARKS") return $this->TRfRemarks;
        if($name ==  "T_PICTURE_CHAR_FLAG") return $this->TPictureCharFlag;
        if($name ==  "T_PICTURE_CHAR_EXTEND_FLAG") return $this->TPictureCharExtendFlag;
        if($name ==  "URL_FLAG") return $this->urlFlag;
        if($name ==  "URL_LETTER") return $this->urlLetter;
        if($name ==  "U_LETTER_LIMIT") return $this->ULetterLimit;
        if($name ==  "U_LETTER_LIMIT_DIV") return $this->ULetterLimitDiv;
        if($name ==  "U_LETTER_LIMIT_SEQ") return $this->ULetterLimitSeq;
        if($name ==  "ALT_FLAG") return $this->altFlag;
        if($name ==  "ALT_LETTER") return $this->altLetter;
        if($name ==  "A_LETTER_LIMIT") return $this->ALetterLimit;
        if($name ==  "A_LETTER_LIMIT_DIV") return $this->ALetterLimitDiv;
        if($name ==  "A_LETTER_LIMIT_SEQ") return $this->ALetterLimitSeq;
        if($name ==  "A_2BYTECHAR_FLAG") return $this->A2bytecharFlag;
        if($name ==  "A_1BYTECHAR_FLAG") return $this->A1bytecharFlag;
        if($name ==  "A_KANA_FLAG") return $this->AKanaFlag;
        if($name ==  "LOOP_LIMIT_FLAG") return $this->loopLimitFlag;
        if($name ==  "L_COUNT") return $this->LCount;
        if($name ==  "L_COUNT_OPEN_FLAG") return $this->LCountOpenFlag;
        if($name ==  "L_ROUND_LIMIT_FLAG") return $this->LRoundLimitFlag;
        if($name ==  "L_ROUND_SECOND") return $this->LRoundSecond;
        if($name ==  "L_ROUND_LIMIT") return $this->LRoundLimit;
        if($name ==  "L_ROUND_LIMIT_DIV") return $this->LRoundLimitDiv;
        if($name ==  "L_ROUND_LIMIT_SEQ") return $this->LRoundLimitSeq;
        if($name ==  "ANIMATION_FLAG") return $this->animationFlag;
        if($name ==  "ANIMATION_COUNT") return $this->animationCount;
        if($name ==  "COLOR_FLAG") return $this->colorFlag;
        if($name ==  "WITH_MONO_FLAG") return $this->withMonoFlag;
        if($name ==  "DHTML_FLAG") return $this->dhtmlFlag;
        if($name ==  "LINK_TARGET") return $this->linkTarget;
        if($name ==  "PC_CHAR_FLAG") return $this->pcCharFlag;
        if($name ==  "SOUND_FLAG") return $this->soundFlag;
        if($name ==  "SOUND_DEFAULT_FLAG") return $this->soundDefaultFlag;
        if($name ==  "MUTEBUTTON_FLAG") return $this->mutebuttonFlag;
        if($name ==  "CLOSEBUTTON_FLAG") return $this->closebuttonFlag;
        if($name ==  "ENCODE") return $this->encode;
        if($name ==  "ENCODE_DIV") return $this->encodeDiv;
        if($name ==  "ENCODE_SEQ") return $this->encodeSeq;
        if($name ==  "BIT_RATE_MIN") return $this->bitRateMin;
        if($name ==  "BIT_RATE_MAX") return $this->bitRateMax;
        if($name ==  "SOUND_ENCODE") return $this->soundEncode;
        if($name ==  "SOUND_ENCODE_DIV") return $this->soundEncodeDiv;
        if($name ==  "SOUND_ENCODE_SEQ") return $this->soundEncodeSeq;
        if($name ==  "SOUND_BIT_RATE_MIN") return $this->soundBitRateMin;
        if($name ==  "SOUND_BIT_RATE_MAX") return $this->soundBitRateMax;
        if($name ==  "SOUND_ENCODE_VERSION") return $this->soundEncodeVersion;
        if($name ==  "START_AREA_REMARKS") return $this->startAreaRemarks;
        if($name ==  "FLA_FILE_VERSION") return $this->flaFileVersion;
        if($name ==  "FLA_FILE_MUST_FLAG") return $this->flaFileMustFlag;
        if($name ==  "FLA_FILE_PUBLISH_FLAG") return $this->flaFilePublishFlag;
        if($name ==  "MUST_FLAG") return $this->mustFlag;
        if($name ==  "REMARKS") return $this->remarks;
        if($name ==  "REG_PTN_NO") return $this->regPtnNo;
        if($name ==  "USE_MENU_CARRIER_FLAG") return $this->useMenuCarrierFlag;
        if($name ==  "ADMISSION_AD_CODE") return $this->admissionAdCode;
        if($name ==  "MATERIAL_PATTERN_SEQ") return $this->materialPatternSeq;
        if($name ==  "SPECIAL_FLAG") return $this->specialFlag;
        if($name ==  "VALID_FLAG") return $this->validFlag;
        if($name ==  "INSERT_DATE_TIME") return $this->insertDateTime;
        if($name ==  "INSERT_OPERATOR_CODE") return $this->insertOperatorCode;
        if($name ==  "UPDATE_DATE_TIME") return $this->updateDateTime;
        if($name ==  "OPERATOR_CODE") return $this->operatorCode;
        
        return null;
    }
    
    /**
    * 指定データからのコピー
    * @param MastMaterialTableRow コピー元
    * @return none
    */
    public function copyFrom($source)
    {
        $this->siteCode = $source->siteCode;
        $this->menuCode = $source->menuCode;
        $this->manuscriptSeq = $source->manuscriptSeq;
        $this->seq = $source->seq;
        $this->materialCode = $source->materialCode;
        $this->materialAliasName = $source->materialAliasName;
        $this->materialInputKindDiv = $source->materialInputKindDiv;
        $this->materialInputKindSeq = $source->materialInputKindSeq;
        $this->fileVersion = $source->fileVersion;
        $this->fileExtention = $source->fileExtention;
        $this->wholePixcelX = $source->wholePixcelX;
        $this->wholePixcelY = $source->wholePixcelY;
        $this->wholePixcelLimit = $source->wholePixcelLimit;
        $this->wholePixcelLimitDiv = $source->wholePixcelLimitDiv;
        $this->wholePixcelLimitSeq = $source->wholePixcelLimitSeq;
        $this->adPixcelX = $source->adPixcelX;
        $this->adPixcelY = $source->adPixcelY;
        $this->adPixcelLimit = $source->adPixcelLimit;
        $this->adPixcelLimitDiv = $source->adPixcelLimitDiv;
        $this->adPixcelLimitSeq = $source->adPixcelLimitSeq;
        $this->rfPixcelX = $source->rfPixcelX;
        $this->rfPixcelY = $source->rfPixcelY;
        $this->rfPixcelLimit = $source->rfPixcelLimit;
        $this->rfPixcelLimitDiv = $source->rfPixcelLimitDiv;
        $this->rfPixcelLimitSeq = $source->rfPixcelLimitSeq;
        $this->colorCapacity = $source->colorCapacity;
        $this->colorCapacityLimit = $source->colorCapacityLimit;
        $this->colorCapacityLimitDiv = $source->colorCapacityLimitDiv;
        $this->colorCapacityLimitSeq = $source->colorCapacityLimitSeq;
        $this->monoCapacity = $source->monoCapacity;
        $this->monoCapacityLimit = $source->monoCapacityLimit;
        $this->monoCapacityLimitDiv = $source->monoCapacityLimitDiv;
        $this->monoCapacityLimitSeq = $source->monoCapacityLimitSeq;
        $this->mainLetterFlag = $source->mainLetterFlag;
        $this->mainLetter = $source->mainLetter;
        $this->MLetterLimit = $source->MLetterLimit;
        $this->MLetterLimitDiv = $source->MLetterLimitDiv;
        $this->MLetterLimitSeq = $source->MLetterLimitSeq;
        $this->mainLine = $source->mainLine;
        $this->MLineLimit = $source->MLineLimit;
        $this->MLineLimitDiv = $source->MLineLimitDiv;
        $this->MLineLimitSeq = $source->MLineLimitSeq;
        $this->M2bytecharFlag = $source->M2bytecharFlag;
        $this->M1bytecharFlag = $source->M1bytecharFlag;
        $this->MKanaFlag = $source->MKanaFlag;
        $this->MRfFlag = $source->MRfFlag;
        $this->MRfRemarks = $source->MRfRemarks;
        $this->MPictureCharFlag = $source->MPictureCharFlag;
        $this->MPictureCharExtendFlag = $source->MPictureCharExtendFlag;
        $this->titleLetterFlag = $source->titleLetterFlag;
        $this->titelLetter = $source->titelLetter;
        $this->TLetterLimit = $source->TLetterLimit;
        $this->TLetterLimitDiv = $source->TLetterLimitDiv;
        $this->TLetterLimitSeq = $source->TLetterLimitSeq;
        $this->TLine = $source->TLine;
        $this->TLineLimit = $source->TLineLimit;
        $this->TLineLimitDiv = $source->TLineLimitDiv;
        $this->TLineLimitSeq = $source->TLineLimitSeq;
        $this->T2bytecharFlag = $source->T2bytecharFlag;
        $this->T1bytecharFlag = $source->T1bytecharFlag;
        $this->TKanaFlag = $source->TKanaFlag;
        $this->TRfFlag = $source->TRfFlag;
        $this->TRfRemarks = $source->TRfRemarks;
        $this->TPictureCharFlag = $source->TPictureCharFlag;
        $this->TPictureCharExtendFlag = $source->TPictureCharExtendFlag;
        $this->urlFlag = $source->urlFlag;
        $this->urlLetter = $source->urlLetter;
        $this->ULetterLimit = $source->ULetterLimit;
        $this->ULetterLimitDiv = $source->ULetterLimitDiv;
        $this->ULetterLimitSeq = $source->ULetterLimitSeq;
        $this->altFlag = $source->altFlag;
        $this->altLetter = $source->altLetter;
        $this->ALetterLimit = $source->ALetterLimit;
        $this->ALetterLimitDiv = $source->ALetterLimitDiv;
        $this->ALetterLimitSeq = $source->ALetterLimitSeq;
        $this->A2bytecharFlag = $source->A2bytecharFlag;
        $this->A1bytecharFlag = $source->A1bytecharFlag;
        $this->AKanaFlag = $source->AKanaFlag;
        $this->loopLimitFlag = $source->loopLimitFlag;
        $this->LCount = $source->LCount;
        $this->LCountOpenFlag = $source->LCountOpenFlag;
        $this->LRoundLimitFlag = $source->LRoundLimitFlag;
        $this->LRoundSecond = $source->LRoundSecond;
        $this->LRoundLimit = $source->LRoundLimit;
        $this->LRoundLimitDiv = $source->LRoundLimitDiv;
        $this->LRoundLimitSeq = $source->LRoundLimitSeq;
        $this->animationFlag = $source->animationFlag;
        $this->animationCount = $source->animationCount;
        $this->colorFlag = $source->colorFlag;
        $this->withMonoFlag = $source->withMonoFlag;
        $this->dhtmlFlag = $source->dhtmlFlag;
        $this->linkTarget = $source->linkTarget;
        $this->pcCharFlag = $source->pcCharFlag;
        $this->soundFlag = $source->soundFlag;
        $this->soundDefaultFlag = $source->soundDefaultFlag;
        $this->mutebuttonFlag = $source->mutebuttonFlag;
        $this->closebuttonFlag = $source->closebuttonFlag;
        $this->encode = $source->encode;
        $this->encodeDiv = $source->encodeDiv;
        $this->encodeSeq = $source->encodeSeq;
        $this->bitRateMin = $source->bitRateMin;
        $this->bitRateMax = $source->bitRateMax;
        $this->soundEncode = $source->soundEncode;
        $this->soundEncodeDiv = $source->soundEncodeDiv;
        $this->soundEncodeSeq = $source->soundEncodeSeq;
        $this->soundBitRateMin = $source->soundBitRateMin;
        $this->soundBitRateMax = $source->soundBitRateMax;
        $this->soundEncodeVersion = $source->soundEncodeVersion;
        $this->startAreaRemarks = $source->startAreaRemarks;
        $this->flaFileVersion = $source->flaFileVersion;
        $this->flaFileMustFlag = $source->flaFileMustFlag;
        $this->flaFilePublishFlag = $source->flaFilePublishFlag;
        $this->mustFlag = $source->mustFlag;
        $this->remarks = $source->remarks;
        $this->regPtnNo = $source->regPtnNo;
        $this->useMenuCarrierFlag = $source->useMenuCarrierFlag;
        $this->admissionAdCode = $source->admissionAdCode;
        $this->materialPatternSeq = $source->materialPatternSeq;
        $this->specialFlag = $source->specialFlag;
        $this->validFlag = $source->validFlag;
        $this->insertDateTime = $source->insertDateTime;
        $this->insertOperatorCode = $source->insertOperatorCode;
        $this->updateDateTime = $source->updateDateTime;
        $this->operatorCode = $source->operatorCode;
        
    }
}
