<?php
Zend_Loader::loadClass("CFW_FieldProperties_Abstract");
Zend_Loader::loadClass("CFW_Models_EntityProperty");

/**
* table auth_usersに対応するフィールドEロパティ
*/
class CFW_Sample_Models_Base_AuthUsersTableProperty extends  CFW_Models_EntityProperty
{
	/* var CFW_FieldProperties_Abstract [login_id] */
	public $loginId;
	/* var CFW_FieldProperties_Abstract [name] */
	public $name;
	/* var CFW_FieldProperties_Abstract [password] */
	public $password;
	/* var CFW_FieldProperties_Abstract [description] */
	public $description;
	

    /**
    * default construct
    */
    public function __construct()
    {
    	$this->tableName = "auth_users";
		$this->loginId =  CFW_FieldProperties_Abstract::newInstance("varchar", "auth_users", "login_id","[login_id]", 64, 0, 0, false, "",true);
		$this->name =  CFW_FieldProperties_Abstract::newInstance("varchar", "auth_users", "name","[name]", 100, 0, 0, false, "",false);
		$this->password =  CFW_FieldProperties_Abstract::newInstance("varchar", "auth_users", "password","[password]", 100, 0, 0, false, "",false);
		$this->description =  CFW_FieldProperties_Abstract::newInstance("varchar", "auth_users", "description","[description]", 500, 0, 0, true, "",false);
		

		$this->entityClass = "CFW_Sample_Models_Base_AuthUsersTableRow";
 		
    }

    /**
    * 全てのフィールドを列挙
    * 
    * @returns 
    */
    public function getFields()
    {
    	$fields = array();
		$fields[] = $this->loginId;
		$fields[] = $this->name;
		$fields[] = $this->password;
		$fields[] = $this->description;
		
		return $fields;
    }
    /**
    * 全ての主キーをE持E
    * 
    * @returns 
    */
    public function getPrimaryKeys()
    {
    	$fields = array();
        $fields[] = $this->loginId;
        
		return $fields;
    }
    public function getUpdateFields(){
    	$fields = array();
		if($this->loginId->doUpdate && !$this->loginId->isIdentity)$fields[] = $this->loginId;
		if($this->name->doUpdate && !$this->name->isIdentity)$fields[] = $this->name;
		if($this->password->doUpdate && !$this->password->isIdentity)$fields[] = $this->password;
		if($this->description->doUpdate && !$this->description->isIdentity)$fields[] = $this->description;
		
		return $fields;
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#getName()
     */
    public function getName(){
        return $this->tableName;
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#setName($value)
     */
    public function setName($value){
        $this->talbeName = $value;
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#getAlias()
     */
    public function getAlias(){
        return $this->alias;
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#setAlias($value)
     */
    public function setAlias($value){
        $this->alias= $value;
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#setDoUpdate($doUpdate)
     */
    public function setDoUpdate($doUpdate = true){
		$this->loginId->doUpdate = $doUpdate;
		$this->name->doUpdate = $doUpdate;
		$this->password->doUpdate = $doUpdate;
		$this->description->doUpdate = $doUpdate;
		
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#getEntityClass()
     */
    public function getEntityClass(){
        return $this->entityClass;
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#getIdentityField()
     */
    public function getIdentityField(){
        return $this->identityField;
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#getCreatedAtField()
     */
    public function getCreatedAtField(){
        return $this->createdAtField;
    }
    /* (non-PHPdoc)
     * @see library/CFW/Model/CFW_Models_IEntityProperty#getModifiedField()
     */
    public function getModifiedAtField(){
        return $this->modofiedAtField;
    }

    
}
