<?php
Zend_Loader::loadClass("CFW_Util_Date");
Zend_Loader::loadClass("CFW_Util_Number");
Zend_Loader::loadClass("CFW_Util_String");
Zend_Loader::loadClass("CFW_Html_Util");
Zend_Loader::loadClass("CFW_Util_Util");
Zend_Loader::loadClass("CFW_Constants_DateTime");
Zend_Loader::loadClass("CFW_Log_LoggerFactory");
/**
 * 各種Util系のショートカット関数
 */

/**
 * 日付型(DateTime)に変換
 * @param unknown_type $value
 * @return Date
 */
function toDate($value){
    return CFW_Util_Date::toDate($value);
}
/**
 * 日付をフォーマット
 * @param unknown_type $value
 * @param unknown_type $format
 * @return string
 */
function formatDate($value,$format = CFW_Constants_DateTime::FORMAT_DATE_TIME){

    return CFW_Util_Date::format($value,$format);
}
function now(){
    return CFW_Util_Date::now();
}
/**
 * 整数に変換
 * @param unknown_type $value
 * @return number
 */
function toInteger($value){
    return CFW_Util_Number::toInteger($value);
}
/**
 * 数値を書式化
 * @param decimal $value 入力値
 * @param bool $useThousandsSeparator 桁区切りを使うか
 * @param int $numDecimals 小数点以下の桁数
 * @return string $result 書式化結果文字列
 */
function formatNumber($value,$useThousandsSeparator = true,$numDecimals = -1){
    return CFW_Util_Number::formatNumber($value,$useThousandsSeparator,$numDecimals);
}
/**
 * ｈｔｍｌエスケープ
 * @param unknown_type $value
 * @return string
 */
function h($value){
    return CFW_Html_Util::escape($value);
}
/**
 * jsエスケープ
 * @param unknown_type $value
 * @return unknown_type
 */
function j($value){
    CFW_Util_Util::jsescape($value);
}
/**
 * jsエスケープに引用符を付ける
 * @param unknown_type $value
 * @return unknown_type
 */
function jq($value){
    CFW_Util_Util::jsquote($value);
}
/**
 * ログ出力 エラー
 * @param unknown_type $class クラス名。__CLASS__を使う。グローバル関数の場合basename(__FILE__)を使う
 * @param unknown_type $method メソッド名。__FUNCTION__を使う。(__METHOD__ではなく)
 * @param unknown_type $message 出力するメッセージ
 * @param unknown_type $name ログ出力先の名前。core.ini/log要素につけた名前。
 * @return unknown_type
 */
function logError($class,$method,$message,$name = "default"){
    $logger = CFW_Log_LoggerFactory::getLogger($name,$class);
    $logger->error($method,$message);
}
/**
 * ログ出力 info
 * @param unknown_type $class クラス名。__CLASS__を使う。グローバル関数の場合basename(__FILE__)を使う
 * @param unknown_type $method メソッド名。__FUNCTION__を使う。(__METHOD__ではなく)
 * @param unknown_type $message 出力するメッセージ
 * @param unknown_type $name ログ出力先の名前。core.ini/log要素につけた名前。
 * @return unknown_type
 */
function logInfo($class,$method,$message,$name = "default"){
    $logger = CFW_Log_LoggerFactory::getLogger($name,$class);
    $logger->info($method,$message);
}
/**
 * ログ出力デバッグ
 * @param unknown_type $class クラス名。__CLASS__を使う。グローバル関数の場合basename(__FILE__)を使う
 * @param unknown_type $method メソッド名。__FUNCTION__を使う。(__METHOD__ではなく)
 * @param unknown_type $message 出力するメッセージ
 * @param unknown_type $name ログ出力先の名前。core.ini/log要素につけた名前。
 * @return unknown_type
 */
function logDebug($class,$method,$message,$name = "default"){
    $logger = CFW_Log_LoggerFactory::getLogger($name,$class);
    $logger->debug($method,$message);
}


function eh($value){
    echo h($value);
}
function ej($value){
    echo j($value);
}
function ejq($value){
    echo jq($value);
}


