<?php
Zend_Loader::loadClass("CFW_Config_Configuration");
Zend_Loader::loadClass("Zend_Amf_Server");
/**
 * AMFのクラスマッピング.
 * PHPクラスとActionScriptクラスのマッピング情報を設定ファイルから読み込んで設定する
 * @author okada
 * @package CFW_Data_Amf
 */
class CFW_Amf_ClassMap{
    /**
     * 指定サーバーにマッピング情報を設定ファイルから読み込んで設定する
     * @param Zend_Amf_Server $service
     * @return unknown_type
     */
    public static function map(Zend_Amf_Server $service){
        $config = CFW_Config_Configuration::getInstance("classmappings");
        foreach($config->classmappings as $key => $value){
            $service->setClassMap($key,$value);
        }
    }
}