<?php 
Zend_Loader::loadClass("CFW_Models_Entity");

/**
* table acl_resources Field定義
*/
class CFW_Acl_Db_Models_Base_AclResourcesTableRow extends CFW_Models_Entity
{
    /** 
    * @var Number id [id]
    */
    public $id;
    /** 
    * @var Number parentId [parent_id]
    */
    public $parentId;
    /** 
    * @var String name [name]
    */
    public $name;
    /** 
    * @var Number leftSide [left_side]
    */
    public $leftSide;
    /** 
    * @var Number rightSide [right_side]
    */
    public $rightSide;
    /** 
    * @var String description [description]
    */
    public $description;
    
    /**
    * default construct 
    */
    public function __construct()
    {
        parent::__construct();
        $this->id = 0;
        $this->parentId = 0;
        $this->name = "";
        $this->leftSide = 0;
        $this->rightSide = 0;
        $this->description = "";
        
    }
    
    /**
    * 列名を指定して値を設定
    *
    * @param string name 列名
    * @param object value 値
    */
    public function setValue($name,$value)
    {
        if($name ==  "id") $this->id = CFW_Util_Number::numberValue( $value );
        if($name ==  "parent_id") $this->parentId = CFW_Util_Number::numberValue( $value );
        if($name ==  "name") $this->name = CFW_Util_String::stringValue( $value );
        if($name ==  "left_side") $this->leftSide = CFW_Util_Number::numberValue( $value );
        if($name ==  "right_side") $this->rightSide = CFW_Util_Number::numberValue( $value );
        if($name ==  "description") $this->description = CFW_Util_String::stringValue( $value );
        
    }
    /// <summary>
    /// 列名を指定して値を取得
    /// </summary>
    /// <param name="name">列名</param>
    /**
    * 列名を指定して値を取得
    *
    * @param string name 列名
    * @return object 値
    */
    public function getValue($name)
    {
        if($name ==  "id") return $this->id;
        if($name ==  "parent_id") return $this->parentId;
        if($name ==  "name") return $this->name;
        if($name ==  "left_side") return $this->leftSide;
        if($name ==  "right_side") return $this->rightSide;
        if($name ==  "description") return $this->description;
        
        return null;
    }
    
    /**
    * 指定データからのコピー
    * @param AclResourcesTableRow コピー元
    * @return none
    */
    public function copyFrom($source)
    {
        $this->id = $source->id;
        $this->parentId = $source->parentId;
        $this->name = $source->name;
        $this->leftSide = $source->leftSide;
        $this->rightSide = $source->rightSide;
        $this->description = $source->description;
        
    }
}
